/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file.open;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import org.openjump.core.ui.io.file.FileLayerLoader;
import org.openjump.core.ui.io.file.Option;
import org.openjump.core.ui.plugin.file.open.OpenFileWizardState;
import org.openjump.core.ui.swing.factory.field.FieldComponentFactoryRegistry;
import org.openjump.swing.factory.field.FieldComponentFactory;
import org.openjump.swing.listener.ValueChangeEvent;
import org.openjump.swing.listener.ValueChangeListener;
import org.openjump.swing.util.SpringUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectFileOptionsPanel
extends JPanel
implements WizardPanel {
    private static final long serialVersionUID = -3105562554743126639L;
    public static final String KEY = SelectFileOptionsPanel.class.getName();
    public static final String TITLE = I18N.get(KEY);
    public static final String FILE_TYPE = I18N.get(KEY + ".file-type");
    public static final String INSTRUCTIONS = I18N.get(KEY + ".instructions");
    public static final String USE_SAME_SETTINGS_FOR = I18N.get(KEY + ".use-same-settings-for");
    private JPanel mainPanel;
    private Set<InputChangedListener> listeners = new LinkedHashSet<InputChangedListener>();
    private OpenFileWizardState state;
    private WorkbenchContext workbenchContext;

    public SelectFileOptionsPanel(WorkbenchContext workbenchContext) {
        super(new BorderLayout());
        this.workbenchContext = workbenchContext;
        JPanel scrollPanel = new JPanel(new BorderLayout());
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        scrollPanel.add((Component)this.mainPanel, "North");
        JScrollPane scrollPane = new JScrollPane(scrollPanel);
        this.add((Component)scrollPane, "Center");
    }

    public OpenFileWizardState getState() {
        return this.state;
    }

    public void setState(OpenFileWizardState state) {
        this.state = state;
    }

    public void enteredFromLeft(Map dataMap) {
        this.mainPanel.removeAll();
        for (Map.Entry<FileLayerLoader, Set<URI>> entry : this.state.getFileLoaderFiles().entrySet()) {
            FileLayerLoader fileLayerLoader = entry.getKey();
            List<Option> optionFields = fileLayerLoader.getOptionMetadata();
            if (optionFields.isEmpty()) continue;
            Set<URI> files = entry.getValue();
            this.addLoader(fileLayerLoader, optionFields, files);
        }
    }

    private void addLoader(final FileLayerLoader loader, final List<Option> optionFields, final Set<URI> files) {
        final JPanel panel = new JPanel();
        final String description = loader.getDescription();
        panel.setBorder(BorderFactory.createTitledBorder(description));
        ActionListener useSameListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                panel.removeAll();
                if (((JCheckBox)e.getSource()).isSelected()) {
                    SelectFileOptionsPanel.this.addSameSettingsFields(loader, panel, description, files, optionFields, this);
                } else {
                    SelectFileOptionsPanel.this.addIndividualSettingsFields(loader, panel, description, files, optionFields, this);
                }
                SelectFileOptionsPanel.this.mainPanel.revalidate();
                SelectFileOptionsPanel.this.mainPanel.repaint();
                SelectFileOptionsPanel.this.fireInputChanged();
            }
        };
        this.addIndividualSettingsFields(loader, panel, description, files, optionFields, useSameListener);
        this.mainPanel.add(panel);
    }

    public void addIndividualSettingsFields(FileLayerLoader loader, JPanel panel, String description, Set<URI> files, List<Option> optionFields, ActionListener useSameListener) {
        panel.setLayout(new BoxLayout(panel, 1));
        if (files.size() > 1) {
            JPanel samePanel = new JPanel(new SpringLayout());
            samePanel.add(new JLabel(USE_SAME_SETTINGS_FOR + description));
            JCheckBox useSameField = new JCheckBox();
            useSameField.setSelected(false);
            samePanel.add(useSameField);
            useSameField.addActionListener(useSameListener);
            SpringUtilities.makeCompactGrid(samePanel, 1, 2, 5, 5, 5, 5);
            samePanel.setAlignmentX(0.0f);
            panel.add(samePanel);
        }
        for (final URI file : files) {
            JPanel filePanel = new JPanel(new SpringLayout());
            Map<String, Object> options = this.state.getOptions(file);
            filePanel.setBorder(BorderFactory.createTitledBorder(this.state.getFileName(file)));
            for (Option option : optionFields) {
                final String name = option.getName();
                String label = I18N.get(loader.getClass().getName() + "." + name.replaceAll(" ", "-"));
                filePanel.add(new JLabel(name));
                String type = option.getType();
                FieldComponentFactory factory = FieldComponentFactoryRegistry.getFactory(this.workbenchContext, type);
                ValueChangeListener fieldListener = new ValueChangeListener(){

                    public void valueChanged(ValueChangeEvent event) {
                        Object value = event.getValue();
                        SelectFileOptionsPanel.this.state.setOption(file, name, value);
                        SelectFileOptionsPanel.this.fireInputChanged();
                    }
                };
                JComponent field = factory.createComponent(fieldListener);
                factory.setValue(field, options.get(name));
                filePanel.add(field);
                SpringUtilities.makeCompactGrid(filePanel, filePanel.getComponentCount() / 2, 2, 5, 5, 5, 5);
            }
            filePanel.setAlignmentX(0.0f);
            panel.add(filePanel);
        }
    }

    public void addSameSettingsFields(final FileLayerLoader loader, JPanel panel, String description, Set<URI> files, List<Option> optionFields, ActionListener useSameListener) {
        panel.setLayout(new SpringLayout());
        panel.add(new JLabel(USE_SAME_SETTINGS_FOR + description));
        JCheckBox useSameField = new JCheckBox();
        useSameField.setSelected(true);
        useSameField.addActionListener(useSameListener);
        panel.add(useSameField);
        for (Option option : optionFields) {
            final String label = option.getName();
            panel.add(new JLabel(label));
            String type = option.getType();
            FieldComponentFactory factory = FieldComponentFactoryRegistry.getFactory(this.workbenchContext, type);
            panel.add(factory.createComponent(new ValueChangeListener(){

                public void valueChanged(ValueChangeEvent event) {
                    Object value = event.getValue();
                    SelectFileOptionsPanel.this.state.setOption(loader, label, value);
                    SelectFileOptionsPanel.this.fireInputChanged();
                }
            }));
            this.state.setOption(loader, option.getName(), null);
        }
        SpringUtilities.makeCompactGrid(panel, 1 + optionFields.size(), 2, 5, 5, 5, 5);
    }

    public void exitingToRight() throws Exception {
    }

    public String getID() {
        return KEY;
    }

    public String getInstructions() {
        return INSTRUCTIONS;
    }

    public String getNextID() {
        return this.state.getNextPanel(KEY);
    }

    public String getTitle() {
        return TITLE;
    }

    public boolean isInputValid() {
        return this.state.hasRequiredOptions();
    }

    public void add(InputChangedListener listener) {
        this.listeners.add(listener);
    }

    public void remove(InputChangedListener listener) {
        this.listeners.remove(listener);
    }

    private void fireInputChanged() {
        for (InputChangedListener listener : this.listeners) {
            listener.inputChanged();
        }
    }
}

