/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file.open;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.plugin.SaveProjectAsPlugIn;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JFileChooser;
import org.openjump.swing.listener.InvokeMethodActionListener;

public class SelectProjectFilesPanel
extends JFileChooser
implements WizardPanel {
    public static final String KEY = SelectProjectFilesPanel.class.getName();
    public static final String TITLE = I18N.get("ui.plugin.OpenProjectPlugIn.open-project");
    public static final String INSTRUCTIONS = I18N.get(KEY + ".instructions");
    public static final String ALL_FILES = I18N.get(KEY + ".all-files");
    private Set<InputChangedListener> listeners = new LinkedHashSet<InputChangedListener>();
    private Blackboard blackboard;
    private ActionListener dialogActionListener;

    public SelectProjectFilesPanel(WorkbenchContext context) {
        this.setDialogType(0);
        this.setFileSelectionMode(0);
        this.setMultiSelectionEnabled(true);
        GUIUtil.removeChoosableFileFilters((JFileChooser)this);
        this.addChoosableFileFilter(SaveProjectAsPlugIn.JUMP_PROJECT_FILE_FILTER);
        this.addChoosableFileFilter(GUIUtil.ALL_FILES_FILTER);
        this.setFileFilter(SaveProjectAsPlugIn.JUMP_PROJECT_FILE_FILTER);
        this.setControlButtonsAreShown(false);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SelectProjectFilesPanel.this.fireInputChanged();
            }
        });
    }

    public void setDialog(WizardDialog dialog) {
        this.removeActionListener(this.dialogActionListener);
        this.dialogActionListener = new InvokeMethodActionListener(dialog, "next");
        this.addActionListener(this.dialogActionListener);
    }

    public void enteredFromLeft(Map dataMap) {
        this.rescanCurrentDirectory();
    }

    public void exitingToRight() throws Exception {
    }

    public String getID() {
        return this.getClass().getName();
    }

    public String getInstructions() {
        return INSTRUCTIONS;
    }

    public String getNextID() {
        return null;
    }

    public String getTitle() {
        return TITLE;
    }

    public boolean isInputValid() {
        return this.getSelectedFile() != null;
    }

    public void add(InputChangedListener listener) {
        this.listeners.add(listener);
    }

    public void remove(InputChangedListener listener) {
        this.listeners.remove(listener);
    }

    private void fireInputChanged() {
        for (InputChangedListener listener : this.listeners) {
            listener.inputChanged();
        }
    }
}

