/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ExtractLayerInFence
extends AbstractPlugIn {
    private static final String EXTRACT_LAYER_IN_FENCE = I18N.get("org.openjump.core.ui.plugin.layer.ExtractLayerInFence.Extract-Layer-in-Fence");
    public static final ImageIcon ICON = IconLoader.icon((String)"extract1.gif");

    public void initialize(PlugInContext context) throws Exception {
        WorkbenchContext workbenchContext = context.getWorkbenchContext();
        FeatureInstaller featureInstaller = new FeatureInstaller(workbenchContext);
        context.getFeatureInstaller().addMainMenuItemWithJava14Fix((PlugIn)this, new String[]{MenuNames.EDIT, MenuNames.EXTRACT}, this.getName(), false, (Icon)ICON, (EnableCheck)ExtractLayerInFence.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1)).add(checkFactory.createFenceMustBeDrawnCheck());
    }

    public boolean execute(PlugInContext context) throws Exception {
        Layer[] layers = context.getWorkbenchContext().getLayerNamePanel().getSelectedLayers();
        if (layers.length > 0) {
            Layer layer = layers[0];
            this.splitLayer(context, layer);
            return true;
        }
        return false;
    }

    public String getName() {
        return EXTRACT_LAYER_IN_FENCE;
    }

    private void splitLayer(PlugInContext context, Layer layer) {
        Geometry fence = context.getLayerViewPanel().getFence();
        FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
        List featureList = featureCollection.getFeatures();
        FeatureSchema featureSchema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        boolean wasFiringEvents = context.getLayerManager().isFiringEvents();
        Collection selectedCategories = context.getLayerNamePanel().getSelectedCategories();
        context.getLayerManager().setFiringEvents(true);
        Layer fencedLayer = context.addLayer(selectedCategories.isEmpty() ? StandardCategoryNames.WORKING : selectedCategories.iterator().next().toString(), layer.getName(), (FeatureCollection)new FeatureDataset(featureSchema));
        FeatureCollectionWrapper fencedFeatureCollection = fencedLayer.getFeatureCollectionWrapper();
        context.getLayerManager().setFiringEvents(false);
        for (Feature feature : featureList) {
            Geometry geometry = feature.getGeometry();
            if (geometry.isEmpty() || fence == null || !geometry.intersects(fence)) continue;
            fencedFeatureCollection.add((Feature)feature.clone());
        }
        context.getLayerManager().setFiringEvents(wasFiringEvents);
        context.getLayerViewPanel().repaint();
    }
}

