/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStyle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LayerPropertiesPlugIn
extends AbstractPlugIn {
    private static final String LAST_TAB_KEY = LayerPropertiesPlugIn.class.getName() + " - LAST TAB";
    private static final String LAYER_PROPERTIES = I18N.get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Layer-Properties");
    private static final String INFO = I18N.get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Info");
    private static final String LAYER_NAME = I18N.get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Layer-Name");
    private static final String NUMBER_OF_LAYERS = I18N.get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Number-of-Layers");
    private static final String NUMBER_OF_FEATURES = I18N.get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Number-of-Features");
    private static final String NUMBER_OF_POINTS = I18N.get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Number-of-Points");
    private static final String GEOMETRY_TYPE = I18N.get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Geometry-Type");
    private static final String NUMBER_OF_ATTRIBUTES = I18N.get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Number-of-Attributes");
    private static final String DATASOURCE_CLASS = I18N.get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.DataSource-Class");
    private static final String SOURCE_PATH = I18N.get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Source-Path");
    private static final String NO_FEATURES = I18N.get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.No-Features");
    private static final String MULTIPLE_GEOMETRY_TYPES = I18N.get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Multiple-geometry-types");
    private static final String MULTIPLE_SOURCE_TYPES = I18N.get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Multiple-Source-Types");
    private static final String NULL_GEOMETRIES = I18N.get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Null-Geometries");
    private static final String NOT_SAVED = I18N.get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Not-Saved");
    private static final String AVERAGE_PER_LAYER = " (" + I18N.get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.average-per-layer") + ")";
    private static final String MULTIPLE_SOURCES = I18N.get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Multiple-Sources");
    private static final String STYLES = I18N.get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Styles");
    private static final String PROPORTIONAL_TRANSPARENCY_ADJUSTER = I18N.get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Proportional-Transparency-Adjustment");
    private WorkbenchContext workbenchContext;
    private InfoPanel infoPanel;
    private StylePanel stylePanel;
    private Layer[] layers;
    private int[] currTransArray;
    private boolean styleChanged = false;

    public void initialize(PlugInContext context) throws Exception {
        this.workbenchContext = context.getWorkbenchContext();
        FeatureInstaller featureInstaller = new FeatureInstaller(this.workbenchContext);
        TitledPopupMenu layerNamePopupMenu = this.workbenchContext.getWorkbench().getFrame().getLayerNamePopupMenu();
        featureInstaller.addPopupMenuItem((JPopupMenu)layerNamePopupMenu, (PlugIn)this, LAYER_PROPERTIES + "..." + "{pos:4}", false, null, (EnableCheck)LayerPropertiesPlugIn.createEnableCheck(this.workbenchContext));
    }

    /*
     * WARNING - void declaration
     */
    public boolean execute(PlugInContext context) throws Exception {
        this.styleChanged = false;
        this.layers = context.getSelectedLayers();
        this.currTransArray = new int[this.layers.length];
        for (int i = 0; i < this.layers.length; ++i) {
            this.currTransArray[i] = 255 - LayerPropertiesPlugIn.getAlpha(this.layers[i]);
        }
        ArrayList<Collection> oldStyleList = new ArrayList<Collection>(this.layers.length);
        for (int i = 0; i < this.layers.length; ++i) {
            Layer layerable = this.layers[i];
            if (!(layerable instanceof Layer)) continue;
            oldStyleList.add(layerable.cloneStyles());
        }
        this.infoPanel = new InfoPanel();
        this.stylePanel = new StylePanel();
        MultiInputDialog dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), LAYER_PROPERTIES, true);
        dialog.setInset(0);
        ArrayList<JPanel> propertyPanels = new ArrayList<JPanel>();
        propertyPanels.add(this.infoPanel);
        propertyPanels.add(this.stylePanel);
        this.infoPanel.setPreferredSize(new Dimension(350, 200));
        this.stylePanel.setPreferredSize(new Dimension(350, 200));
        JTabbedPane tabbedPane = new JTabbedPane();
        for (PropertyPanel propertyPanel : propertyPanels) {
            tabbedPane.add((Component)((Object)propertyPanel), propertyPanel.getTitle());
        }
        dialog.addRow((JComponent)tabbedPane);
        tabbedPane.setSelectedComponent(this.find(propertyPanels, (String)context.getWorkbenchContext().getWorkbench().getBlackboard().get(LAST_TAB_KEY, ((PropertyPanel)propertyPanels.iterator().next()).getTitle())));
        dialog.setVisible(true);
        context.getWorkbenchContext().getWorkbench().getBlackboard().put(LAST_TAB_KEY, ((PropertyPanel)((Object)tabbedPane.getSelectedComponent())).getTitle());
        if (!dialog.wasOKPressed() && this.styleChanged && oldStyleList != null) {
            void var7_12;
            int j = 0;
            boolean bl = false;
            while (var7_12 < this.layers.length) {
                Layer layerable = this.layers[var7_12];
                if (layerable instanceof Layer) {
                    Layer layer = layerable;
                    layer.setStyles((Collection)oldStyleList.get(j++));
                }
                ++var7_12;
            }
        }
        return true;
    }

    private Component find(Collection propertyPanels, String title) {
        for (PropertyPanel propertyPanel : propertyPanels) {
            if (!propertyPanel.getTitle().equals(title)) continue;
            return (Component)((Object)propertyPanel);
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1));
    }

    public static ColorThemingStyle getColorThemingStyleIfEnabled(Layer layer) {
        ColorThemingStyle someStyle = null;
        List currentStyles = layer.getStyles();
        for (Object style : currentStyles) {
            if (!(style instanceof ColorThemingStyle) || !((ColorThemingStyle)style).isEnabled()) continue;
            someStyle = (ColorThemingStyle)style;
        }
        return someStyle;
    }

    public static int getAlpha(Layer layer) {
        ColorThemingStyle cts = LayerPropertiesPlugIn.getColorThemingStyleIfEnabled(layer);
        int alpha = 0;
        alpha = cts == null ? layer.getBasicStyle().getAlpha() : cts.getDefaultStyle().getAlpha();
        return alpha;
    }

    public static void setAlpha(Layer layer, int alpha) {
        layer.getBasicStyle().setAlpha(alpha);
        ColorThemingStyle cts = LayerPropertiesPlugIn.getColorThemingStyleIfEnabled(layer);
        if (cts != null) {
            cts.setAlpha(alpha);
        }
    }

    private class StylePanel
    extends JPanel
    implements PropertyPanel {
        private JSlider transparencySlider = new JSlider();

        private StylePanel() {
            this.add(new JLabel(PROPORTIONAL_TRANSPARENCY_ADJUSTER));
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            labelTable.put(new Integer(0), new JLabel("100"));
            labelTable.put(new Integer(10), new JLabel("80"));
            labelTable.put(new Integer(20), new JLabel("60"));
            labelTable.put(new Integer(30), new JLabel("40"));
            labelTable.put(new Integer(40), new JLabel("20"));
            labelTable.put(new Integer(50), new JLabel("0"));
            labelTable.put(new Integer(60), new JLabel("20"));
            labelTable.put(new Integer(70), new JLabel("40"));
            labelTable.put(new Integer(80), new JLabel("60"));
            labelTable.put(new Integer(90), new JLabel("80"));
            labelTable.put(new Integer(100), new JLabel("100"));
            this.transparencySlider.setPreferredSize(new Dimension(250, 50));
            this.transparencySlider.setPaintLabels(true);
            this.transparencySlider.setPaintTicks(true);
            this.transparencySlider.setLabelTable(labelTable);
            this.transparencySlider.setMajorTickSpacing(10);
            this.transparencySlider.setMinimum(0);
            this.transparencySlider.setMaximum(100);
            this.transparencySlider.setValue(50);
            this.add(this.transparencySlider);
            this.transparencySlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    if (!source.getValueIsAdjusting()) {
                        int sliderVal = source.getValue();
                        for (int i = 0; i < LayerPropertiesPlugIn.this.layers.length; ++i) {
                            double percentChg;
                            Layer layer = LayerPropertiesPlugIn.this.layers[i];
                            int currTrans = LayerPropertiesPlugIn.this.currTransArray[i];
                            double newTrans = currTrans;
                            if (sliderVal < 50) {
                                percentChg = (double)(50 - sliderVal) / 50.0;
                                newTrans = (double)currTrans - (double)currTrans * percentChg;
                            } else if (sliderVal > 50) {
                                percentChg = (double)(sliderVal - 50) / 50.0;
                                newTrans = (double)currTrans + (double)(255 - currTrans) * percentChg;
                            }
                            LayerPropertiesPlugIn.setAlpha(layer, 255 - (int)newTrans);
                            layer.fireAppearanceChanged();
                            LayerPropertiesPlugIn.this.styleChanged = true;
                        }
                    }
                }
            });
        }

        public String getTitle() {
            return STYLES;
        }

        public void updateStyles() {
        }

        public String validateInput() {
            return null;
        }
    }

    private class InfoPanel
    extends JPanel
    implements PropertyPanel {
        private JLabel label_Name_L;
        private JLabel label_NumItems_L;
        private JLabel label_NumPts_L;
        private JLabel label_GeoType_L;
        private JLabel label_NumAtts_L;
        private JLabel label_DSClass_L;
        private JLabel label_Path_L;
        private JTextArea label_Name_R;
        private JLabel label_NumItems_R;
        private JLabel label_NumPts_R;
        private JLabel label_GeoType_R;
        private JLabel label_NumAtts_R;
        private JLabel label_DSClass_R;
        private JTextArea label_Path_R;

        private InfoPanel() {
            super(new GridBagLayout());
            this.label_Name_L = new JLabel();
            this.label_NumItems_L = new JLabel();
            this.label_NumPts_L = new JLabel();
            this.label_GeoType_L = new JLabel();
            this.label_NumAtts_L = new JLabel();
            this.label_DSClass_L = new JLabel();
            this.label_Path_L = new JLabel();
            this.label_Name_R = new JTextArea();
            this.label_NumItems_R = new JLabel();
            this.label_NumPts_R = new JLabel();
            this.label_GeoType_R = new JLabel();
            this.label_NumAtts_R = new JLabel();
            this.label_DSClass_R = new JLabel();
            this.label_Path_R = new JTextArea();
            this.label_Name_R.setFont(this.getFont());
            this.label_Name_R.setLineWrap(true);
            this.label_Name_R.setBackground(this.getBackground());
            this.label_Name_R.setSize(200, 30);
            this.label_Path_R.setFont(this.getFont());
            this.label_Path_R.setLineWrap(true);
            this.label_Path_R.setBackground(this.getBackground());
            this.label_Path_R.setSize(200, 50);
            if (LayerPropertiesPlugIn.this.layers.length == 1) {
                this.label_Name_L.setText(LAYER_NAME + ": ");
            } else {
                this.label_Name_L.setText(NUMBER_OF_LAYERS + ": ");
            }
            this.label_NumItems_L.setText(NUMBER_OF_FEATURES + ": ");
            this.label_NumPts_L.setText(NUMBER_OF_POINTS + ": ");
            this.label_GeoType_L.setText(GEOMETRY_TYPE + ": ");
            this.label_NumAtts_L.setText(NUMBER_OF_ATTRIBUTES + ": ");
            this.label_DSClass_L.setText(DATASOURCE_CLASS + ": ");
            this.label_Path_L.setText(SOURCE_PATH + ": ");
            this.setInfo(LayerPropertiesPlugIn.this.layers);
            int row = 0;
            this.add((Component)this.label_Name_L, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)this.label_NumItems_L, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)this.label_NumPts_L, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)this.label_GeoType_L, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)this.label_NumAtts_L, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)this.label_DSClass_L, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)this.label_Path_L, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 12, 0, new Insets(10, 0, 0, 5), 0, 0));
            row = 0;
            this.add((Component)this.label_Name_R, new GridBagConstraints(1, row++, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.label_NumItems_R, new GridBagConstraints(1, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.label_NumPts_R, new GridBagConstraints(1, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.label_GeoType_R, new GridBagConstraints(1, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.label_NumAtts_R, new GridBagConstraints(1, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.label_DSClass_R, new GridBagConstraints(1, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.label_Path_R, new GridBagConstraints(1, row++, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        }

        public String getTitle() {
            return INFO;
        }

        public void updateStyles() {
        }

        public String validateInput() {
            return null;
        }

        private void setInfo(Layer[] layers) {
            int dotPos;
            if (layers.length == 1) {
                this.label_Name_R.setText(layers[0].getName());
            } else {
                this.label_Name_R.setText("" + layers.length);
            }
            String sourcePath = NOT_SAVED;
            String geoClass = "";
            String sourceClass = "";
            int numFeatures = 0;
            int numPts = 0;
            int numAtts = 0;
            Geometry geo = null;
            boolean multipleGeoTypes = false;
            boolean multipleSourceTypes = false;
            for (int l = 0; l < layers.length; ++l) {
                FeatureCollectionWrapper fcw = layers[l].getFeatureCollectionWrapper();
                numFeatures += fcw.size();
                numAtts += fcw.getFeatureSchema().getAttributeCount() - 1;
                Iterator i = fcw.getFeatures().iterator();
                while (i.hasNext()) {
                    geo = ((Feature)i.next()).getGeometry();
                    if (geo == null) continue;
                    numPts += geo.getNumPoints();
                    if (geoClass.equals("")) {
                        geoClass = geo.getClass().getName();
                        continue;
                    }
                    if (geo.getClass().getName().equals(geoClass)) continue;
                    multipleGeoTypes = true;
                }
                DataSourceQuery dsq = layers[l].getDataSourceQuery();
                if (dsq == null) continue;
                String dsqSourceClass = dsq.getDataSource().getClass().getName();
                if (sourceClass.equals("")) {
                    sourceClass = dsqSourceClass;
                } else if (!sourceClass.equals(dsqSourceClass)) {
                    multipleSourceTypes = true;
                }
                Object fnameObj = dsq.getDataSource().getProperties().get("File");
                if (fnameObj == null) continue;
                sourcePath = fnameObj.toString();
            }
            if (numFeatures == 0) {
                geoClass = NO_FEATURES;
            } else if (multipleGeoTypes) {
                geoClass = MULTIPLE_GEOMETRY_TYPES;
            } else if (geoClass.equals("")) {
                geoClass = NULL_GEOMETRIES;
            } else {
                dotPos = geoClass.lastIndexOf(".");
                if (dotPos > 0) {
                    geoClass = geoClass.substring(dotPos + 1);
                }
            }
            if (sourceClass.equals("")) {
                sourceClass = NOT_SAVED;
            } else if (multipleSourceTypes) {
                sourceClass = MULTIPLE_SOURCE_TYPES;
            } else {
                dotPos = sourceClass.lastIndexOf(".");
                if (dotPos > 0) {
                    sourceClass = sourceClass.substring(dotPos + 1);
                }
                if ((dotPos = sourceClass.lastIndexOf("$")) > 0) {
                    sourceClass = sourceClass.substring(dotPos + 1);
                }
            }
            this.label_GeoType_R.setText(geoClass);
            if (layers.length == 1) {
                this.label_NumItems_R.setText("" + numFeatures);
                this.label_NumPts_R.setText("" + numPts);
                this.label_NumAtts_R.setText("" + numAtts);
            } else {
                DecimalFormat df = new DecimalFormat("0.0");
                double numLayers = layers.length;
                double avgNumFeatures = (double)numFeatures / numLayers;
                double avgNumPts = (double)numPts / numLayers;
                double avgNumAtts = (double)numAtts / numLayers;
                this.label_NumItems_R.setText(numFeatures + "  " + df.format(avgNumFeatures) + AVERAGE_PER_LAYER);
                this.label_NumPts_R.setText(numPts + "  " + df.format(avgNumPts) + AVERAGE_PER_LAYER);
                this.label_NumAtts_R.setText(df.format(avgNumAtts) + AVERAGE_PER_LAYER);
            }
            this.label_DSClass_R.setText(sourceClass);
            this.label_Path_R.setText(sourcePath);
            if (layers.length > 1 && !sourcePath.equalsIgnoreCase(NOT_SAVED)) {
                this.label_Path_R.setText(MULTIPLE_SOURCES);
            }
        }
    }

    public static interface PropertyPanel {
        public String getTitle();

        public void updateStyles();

        public String validateInput();
    }
}

