/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer.pirolraster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.rasterimage.RasterImageLayer;

public class ToggleRasterImageVisibility
extends AbstractPlugIn
implements PopupMenuListener {
    protected WorkbenchContext wbContext = null;
    protected JCheckBoxMenuItem menuItem = null;

    public ToggleRasterImageVisibility(WorkbenchContext wbContext) {
        this.wbContext = wbContext;
    }

    public String getIconString() {
        return "visibility.png";
    }

    public String getName() {
        return I18N.get("org.openjump.core.ui.plugin.layer.pirolraster.ToggleRasterImageVisibility.Toggle-Raster-Image-Visibility");
    }

    public boolean execute(PlugInContext context) throws Exception {
        RasterImageLayer rLayer = (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class);
        if (rLayer == null) {
            context.getWorkbenchFrame().warnUser(I18N.get("pirol.plugIns.EditAttributeByFormulaPlugIn.no-layer-selected"));
            return false;
        }
        rLayer.setVisible(!rLayer.isVisible());
        rLayer.fireAppearanceChanged();
        return true;
    }

    public void popupMenuCanceled(PopupMenuEvent arg0) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
        RasterImageLayer rLayer = (RasterImageLayer)LayerTools.getSelectedLayerable(this.wbContext.createPlugInContext(), RasterImageLayer.class);
        if (rLayer == null) {
            return;
        }
        if (this.menuItem != null) {
            this.menuItem.setSelected(rLayer.isVisible());
        }
    }

    public JCheckBoxMenuItem getMenuItem() {
        return this.menuItem;
    }

    public void setMenuItem(JCheckBoxMenuItem menuItem) {
        this.menuItem = menuItem;
    }
}

