/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.mousemenu;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.UndoableEditReceiver;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.OKCancelPanel;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.renderer.style.ArrowLineStringEndpointStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openjump.core.geomutils.Arc;
import org.openjump.core.geomutils.GeoUtils;
import org.openjump.core.geomutils.MathVector;

public class EditSelectedSideDialog
extends JDialog {
    static final String sIsAnInvalidDouble = I18N.get("org.openjump.core.ui.plugin.mousemenu.EditSelectedSideDialog.is-an-invalid-double");
    static final String sLength = I18N.get("org.openjump.core.ui.plugin.mousemenu.EditSelectedSideDialog.length");
    static final String sAngle = I18N.get("org.openjump.core.ui.plugin.mousemenu.EditSelectedSideDialog.angle");
    static final String sInteriorAngle = I18N.get("org.openjump.core.ui.plugin.mousemenu.EditSelectedSideDialog.interior-angle");
    static final String sSide = I18N.get("org.openjump.core.ui.plugin.mousemenu.EditSelectedSideDialog.Side");
    static final String sChangeDirection = I18N.get("org.openjump.core.ui.plugin.mousemenu.EditSelectedSideDialog.Change-Direction");
    static final String sZoomToSide = I18N.get("org.openjump.core.ui.plugin.mousemenu.EditSelectedSideDialog.Zoom-To-Side");
    static final String sMakeSideOne = I18N.get("org.openjump.core.ui.plugin.mousemenu.EditSelectedSideDialog.Make-Side-One");
    static final String sFront = I18N.get("org.openjump.core.ui.plugin.mousemenu.EditSelectedSideDialog.Front");
    static final String sSelectedSide = I18N.get("org.openjump.core.ui.plugin.mousemenu.EditSelectedSideDialog.Selected-Side");
    static final String sEditSelectedSide = I18N.get("org.openjump.core.ui.plugin.mousemenu.EditSelectedSideDialog.Edit-Selected-Side");
    static final String sNA = I18N.get("org.openjump.core.ui.plugin.mousemenu.EditSelectedSideDialog.NA");
    static final String sLengthMustBeGreaterThanZero = I18N.get("org.openjump.core.ui.plugin.mousemenu.EditSelectedSideDialog.Length-must-be-greater-than-zero");
    private static final int SIDEBAR_WIDTH = 150;
    OKCancelPanel okCancelPanel = new OKCancelPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JPanel outerMainPanel = new JPanel();
    static final int LENGTH = 0;
    static final int ANGLE = 1;
    static final int INTERIOR_ANGLE = 2;
    private BorderLayout borderLayout2 = new BorderLayout();
    private JPanel imagePanel = new JPanel();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private JLabel imageLabel = new JLabel();
    private JPanel mainPanel = new JPanel();
    private GridBagLayout mainPanelGridBagLayout = new GridBagLayout();
    private JPanel innerMainPanel = new JPanel();
    private JPanel innerMainPanel2 = new JPanel();
    private GridBagLayout gridBagLayout5 = new GridBagLayout();
    private GridBagLayout gridBagLayout7 = new GridBagLayout();
    private GridBagLayout gridBagLayout6 = new GridBagLayout();
    private JTextArea descriptionTextArea = new JTextArea();
    private JPanel strutPanel = new JPanel();
    private JPanel currentMainPanel = this.innerMainPanel;
    private JPanel verticalSeparatorPanel = new JPanel();
    private JPanel mainEditPanel = new JPanel();
    private Border titleBorder;
    private JPanel inputPanel = new JPanel();
    private JPanel inputSubPanel = new JPanel();
    private GridBagLayout inputPanelGridBagLayout = new GridBagLayout();
    private GridBagLayout inputSubPanelGridBagLayout = new GridBagLayout();
    private TitledBorder inputPanelTitle = new TitledBorder(this.titleBorder, "");
    private JCheckBox readonlyCheckBox = new JCheckBox();
    private JTextField lengthTextField = new JTextField(10);
    private JTextField angleTextField = new JTextField(6);
    private JTextField interiorAngleTextField = new JTextField(6);
    private JLabel sideLabel = new JLabel();
    private JLabel lengthLabel = new JLabel();
    private JLabel angleLabel = new JLabel();
    private JLabel interiorAngleLabel = new JLabel();
    private JPanel buttonPanel = new JPanel();
    private JPanel buttonSubPanel = new JPanel();
    private GridBagLayout buttonPanelGridBagLayout = new GridBagLayout();
    private GridBagLayout buttonSubPanelGridBagLayout = new GridBagLayout();
    private TitledBorder buttonPanelTitle = new TitledBorder(this.titleBorder, "");
    private JButton changeDirectionButton = new JButton();
    private JButton makeSideOneButton = new JButton();
    private JCheckBox zoomToSideCheckBox = new JCheckBox();
    private JButton selectedButton;
    private PlugInContext context;
    private Layer selectedSideLayer;
    private Layer editLayer;
    private Layer activeLayer;
    private Collection selectedFeatures;
    private Feature selectedFeature;
    private Geometry selectedGeo;
    public Geometry ghostGeo;
    private Coordinate[] ghostCoords;
    private Arc angleArc;
    private Feature arrowFeature;
    private int direction;
    private JSpinner sideSpinner;
    private DecimalFormat df2 = new DecimalFormat("##0.0#");
    private DecimalFormat df3 = new DecimalFormat("###,###,##0.0##");
    private int currSide;
    private boolean isClockwise;
    private boolean isLineString;
    private boolean hasPendingEdits;

    public EditSelectedSideDialog(PlugInContext context, String title, boolean modal) {
        super((Frame)context.getWorkbenchFrame(), title, modal);
        this.context = context;
        try {
            this.verticalSeparatorPanel.setBackground(Color.black);
            this.okCancelPanel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EditSelectedSideDialog.this.okCancelPanel_actionPerformed(e);
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                public void componentShown(ComponentEvent e) {
                    EditSelectedSideDialog.this.this_componentShown(e);
                }
            });
            this.setResizable(true);
            this.getContentPane().setLayout(this.borderLayout2);
            this.getContentPane().add((Component)this.okCancelPanel, "South");
            this.getContentPane().add((Component)this.outerMainPanel, "Center");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.inputPanel.setBorder(this.inputPanelTitle);
        this.inputPanel.setLayout(this.inputPanelGridBagLayout);
        this.inputSubPanel.setLayout(this.inputSubPanelGridBagLayout);
        this.sideLabel.setText(sSide + ": ");
        SpinnerNumberModel sideSpinnerModel = new SpinnerNumberModel(1, 1, 1, 1);
        this.sideSpinner = new JSpinner(sideSpinnerModel);
        this.sideSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSpinner spinner = (JSpinner)e.getSource();
                EditSelectedSideDialog.this.currSide = (Integer)spinner.getValue();
                if (EditSelectedSideDialog.this.currSide == 0) {
                    EditSelectedSideDialog.this.currSide = EditSelectedSideDialog.this.ghostCoords.length - 1;
                    spinner.setValue(new Integer(EditSelectedSideDialog.this.ghostCoords.length - 1));
                }
                if (EditSelectedSideDialog.this.currSide == EditSelectedSideDialog.this.ghostCoords.length) {
                    EditSelectedSideDialog.this.currSide = 1;
                    spinner.setValue(new Integer(1));
                }
                EditSelectedSideDialog.this.changeSide();
                if (EditSelectedSideDialog.this.zoomToSideCheckBox.isSelected()) {
                    EditSelectedSideDialog.this.zoomToSide();
                }
            }
        });
        this.lengthLabel.setText(sLength + ": ");
        this.lengthTextField.setText("999999.000");
        this.lengthTextField.setHorizontalAlignment(10);
        this.angleLabel.setText(sAngle + ": ");
        this.angleTextField.setText("000.00");
        this.angleTextField.setHorizontalAlignment(10);
        this.interiorAngleLabel.setText(sInteriorAngle + ": ");
        this.interiorAngleTextField.setText("000.00");
        this.interiorAngleTextField.setHorizontalAlignment(10);
        this.lengthTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                EditSelectedSideDialog.this.updateGeo(0);
            }
        });
        this.angleTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                EditSelectedSideDialog.this.updateGeo(1);
            }
        });
        this.interiorAngleTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                EditSelectedSideDialog.this.updateGeo(2);
            }
        });
        this.inputPanel.add((Component)this.inputSubPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.inputSubPanel.add((Component)this.sideLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.inputSubPanel.add((Component)this.sideSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.inputSubPanel.add((Component)this.lengthLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.inputSubPanel.add((Component)this.lengthTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.inputSubPanel.add((Component)this.angleLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.inputSubPanel.add((Component)this.angleTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.inputSubPanel.add((Component)this.interiorAngleLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.inputSubPanel.add((Component)this.interiorAngleTextField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.buttonPanel.setBorder(this.buttonPanelTitle);
        this.buttonPanel.setLayout(this.buttonPanelGridBagLayout);
        this.buttonSubPanel.setLayout(this.buttonSubPanelGridBagLayout);
        this.changeDirectionButton.setText(sChangeDirection);
        this.makeSideOneButton.setText(sMakeSideOne + " (" + sFront + ")");
        this.zoomToSideCheckBox.setText(sZoomToSide);
        this.changeDirectionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditSelectedSideDialog.this.selectedButton = EditSelectedSideDialog.this.changeDirectionButton;
                EditSelectedSideDialog.this.changeDirection();
            }
        });
        this.makeSideOneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditSelectedSideDialog.this.selectedButton = EditSelectedSideDialog.this.makeSideOneButton;
                EditSelectedSideDialog.this.makeSideOne();
            }
        });
        this.zoomToSideCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EditSelectedSideDialog.this.zoomToSideCheckBox.isSelected()) {
                    EditSelectedSideDialog.this.zoomToSide();
                }
            }
        });
        this.buttonPanel.add((Component)this.buttonSubPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonSubPanel.add((Component)this.changeDirectionButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonSubPanel.add((Component)this.makeSideOneButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonSubPanel.add((Component)this.zoomToSideCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainEditPanel.add((Component)this.inputPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainEditPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.okCancelPanel, "South");
        this.getContentPane().add((Component)this.mainEditPanel, "Center");
        this.init();
    }

    public EditSelectedSideDialog() {
        this((PlugInContext)null, "", false);
    }

    public void init() {
        SelectionManager selectionManager = this.context.getLayerViewPanel().getSelectionManager();
        Collection selectedLayers = selectionManager.getLayersWithSelectedItems();
        this.activeLayer = (Layer)selectedLayers.iterator().next();
        this.selectedFeatures = selectionManager.getFeaturesWithSelectedItems();
        this.selectedFeature = (Feature)this.selectedFeatures.iterator().next();
        Collection selectedItems = selectionManager.getSelectedItems(this.activeLayer);
        this.selectedGeo = (Geometry)selectedItems.iterator().next();
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        FeatureDataset featureDataset = new FeatureDataset(featureSchema);
        Collection selectedCategories = this.context.getLayerNamePanel().getSelectedCategories();
        this.selectedSideLayer = this.context.addLayer(selectedCategories.isEmpty() ? StandardCategoryNames.WORKING : selectedCategories.iterator().next().toString(), sSelectedSide, (FeatureCollection)featureDataset);
        this.selectedSideLayer.setFeatureCollectionModified(false).setEditable(true);
        this.selectedSideLayer.addStyle((Style)new ArrowLineStringEndpointStyle.SolidEnd());
        this.selectedSideLayer.getBasicStyle().setLineColor(Color.red);
        this.selectedSideLayer.getLayerManager().addLayerListener(new LayerListener(){

            public void featuresChanged(FeatureEvent e) {
            }

            public void categoryChanged(CategoryEvent e) {
            }

            public void layerChanged(LayerEvent e) {
                if (e.getType() == LayerEventType.METADATA_CHANGED) {
                    EditSelectedSideDialog.this.selectedSideLayer.setEditable(false);
                }
            }
        });
        FeatureSchema featureSchema2 = new FeatureSchema();
        featureSchema2.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        FeatureDataset featureDataset2 = new FeatureDataset(featureSchema2);
        this.editLayer = this.context.addLayer(selectedCategories.isEmpty() ? StandardCategoryNames.WORKING : selectedCategories.iterator().next().toString(), MenuNames.EDIT, (FeatureCollection)featureDataset2);
        this.editLayer.getBasicStyle().setLineColor(Color.red);
        this.editLayer.getLayerManager().addLayerListener(new LayerListener(){

            public void featuresChanged(FeatureEvent e) {
            }

            public void categoryChanged(CategoryEvent e) {
            }

            public void layerChanged(LayerEvent e) {
                if (e.getType() == LayerEventType.METADATA_CHANGED) {
                    EditSelectedSideDialog.this.editLayer.setEditable(false);
                }
            }
        });
        ArrayList transactions = new ArrayList();
        EditTransaction transaction = new EditTransaction(this.selectedFeatures, this.getName(), this.activeLayer, false, false, this.context.getWorkbenchContext().getLayerViewPanel());
        this.selectedGeo = this.selectedFeature.getGeometry();
        this.direction = 0;
        new GeoUtils();
        this.isClockwise = GeoUtils.clockwise(this.selectedGeo);
        this.hasPendingEdits = false;
        Coordinate[] geoCoords = this.selectedGeo.getCoordinates();
        this.ghostCoords = new Coordinate[geoCoords.length];
        for (int i = 0; i < this.ghostCoords.length; ++i) {
            this.ghostCoords[i] = (Coordinate)geoCoords[i].clone();
        }
        Coordinate clickPoint = new Coordinate(0.0, 0.0, 0.0);
        try {
            clickPoint = this.context.getLayerViewPanel().getViewport().toModelCoordinate((Point2D)this.context.getLayerViewPanel().getLastClickedPoint());
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        new GeoUtils();
        double distToSide = GeoUtils.getDistance(clickPoint, this.ghostCoords[0], this.ghostCoords[1]);
        this.currSide = 1;
        for (int i = 1; i < this.ghostCoords.length - 1; ++i) {
            new GeoUtils();
            double currDistToSide = GeoUtils.getDistance(clickPoint, this.ghostCoords[i], this.ghostCoords[i + 1]);
            if (!(currDistToSide < distToSide)) continue;
            distToSide = currDistToSide;
            this.currSide = i + 1;
        }
        this.sideSpinner.setModel(new SpinnerNumberModel(this.currSide, 0, this.ghostCoords.length, 1));
        FeatureSchema fs2 = this.editLayer.getFeatureCollectionWrapper().getFeatureSchema();
        BasicFeature feature2 = new BasicFeature(fs2);
        if (this.selectedGeo instanceof Polygon || this.selectedGeo instanceof LinearRing) {
            this.isLineString = false;
            this.ghostGeo = new GeometryFactory().createLinearRing(this.ghostCoords);
        } else {
            this.isLineString = true;
            this.ghostGeo = new GeometryFactory().createLineString(this.ghostCoords);
            this.makeSideOneButton.setEnabled(false);
        }
        this.ghostCoords = this.ghostGeo.getCoordinates();
        feature2.setGeometry(this.ghostGeo);
        this.editLayer.getFeatureCollectionWrapper().add(feature2);
        FeatureSchema fs = this.selectedSideLayer.getFeatureCollectionWrapper().getFeatureSchema();
        this.arrowFeature = new BasicFeature(fs);
        this.arrowFeature.setGeometry((Geometry)this.getArcArrow());
        this.selectedSideLayer.getFeatureCollectionWrapper().add(this.arrowFeature);
        this.changeSide();
    }

    public void setVisible(boolean visible) {
        this.pack();
        this.pack();
        GUIUtil.centreOnWindow((Component)this);
        super.setVisible(visible);
    }

    protected Coordinate[] toArray(List coordinates) {
        return coordinates.toArray(new Coordinate[0]);
    }

    public boolean wasOKPressed() {
        return this.okCancelPanel.wasOKPressed();
    }

    void okCancelPanel_actionPerformed(ActionEvent e) {
        if (this.okCancelPanel.wasOKPressed() && this.hasPendingEdits) {
            UndoableEditReceiver undoableEditReceiver;
            UndoableEditReceiver undoableEditReceiver2 = undoableEditReceiver = this.context.getWorkbenchContext().getLayerManager() != null ? this.context.getWorkbenchContext().getLayerManager().getUndoableEditReceiver() : null;
            if (undoableEditReceiver != null) {
                undoableEditReceiver.startReceiving();
            }
            if (this.selectedGeo instanceof Polygon) {
                this.ghostGeo = new GeometryFactory().createPolygon((LinearRing)this.ghostGeo, null);
            }
            EditTransaction transaction = new EditTransaction(this.selectedFeatures, sEditSelectedSide, this.activeLayer, false, false, this.context.getWorkbenchContext().getLayerViewPanel());
            transaction.setGeometry(this.selectedFeature, this.ghostGeo);
            transaction.commit();
            if (undoableEditReceiver != null) {
                undoableEditReceiver.stopReceiving();
            }
        }
        this.setVisible(false);
        this.selectedSideLayer.getLayerManager().remove((Layerable)this.selectedSideLayer);
        this.editLayer.getLayerManager().remove((Layerable)this.editLayer);
    }

    void this_componentShown(ComponentEvent e) {
        this.okCancelPanel.setOKPressed(false);
    }

    private void reportValidationError(String errorMessage) {
        JOptionPane.showMessageDialog(this, errorMessage, "JUMP", 0);
    }

    void changeDirection() {
        this.direction = 1 - this.direction;
        this.changeSide();
    }

    void makeSideOne() {
        if (this.currSide != 1) {
            int i;
            Coordinate[] tempCoords = new Coordinate[this.ghostCoords.length];
            for (int i2 = 0; i2 < this.ghostCoords.length; ++i2) {
                tempCoords[i2] = (Coordinate)this.ghostCoords[i2].clone();
            }
            int index = 0;
            for (i = this.currSide - 1; i < this.ghostCoords.length; ++i) {
                this.ghostCoords[index] = tempCoords[i];
                ++index;
            }
            for (i = 1; i < this.currSide; ++i) {
                this.ghostCoords[index] = tempCoords[i];
                ++index;
            }
            this.ghostGeo = new GeometryFactory().createLinearRing(this.ghostCoords);
            this.sideSpinner.setModel(new SpinnerNumberModel(1, 0, this.ghostCoords.length, 1));
            this.hasPendingEdits = true;
            this.currSide = 1;
        }
    }

    void zoomToSide() {
        Envelope sideEnv = this.getArcArrow().getEnvelopeInternal();
        double width = sideEnv.getWidth() / 10.0;
        double height = sideEnv.getHeight() / 10.0;
        double extraOnRight = sideEnv.getMaxX() + width;
        double extraOnLeft = sideEnv.getMinX() - width;
        double extraOnTop = sideEnv.getMaxY() + height;
        double extraOnBot = sideEnv.getMinY() - height;
        sideEnv.expandToInclude(extraOnRight, extraOnTop);
        sideEnv.expandToInclude(extraOnLeft, extraOnBot);
        try {
            this.context.getWorkbenchContext().getLayerViewPanel().getViewport().zoom(sideEnv);
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        this.changeSide();
    }

    void zoomToShape() {
        Envelope shapeEnv = this.ghostGeo.getEnvelopeInternal();
        shapeEnv.expandToInclude(this.selectedGeo.getEnvelopeInternal());
        double width = shapeEnv.getWidth() / 10.0;
        double height = shapeEnv.getHeight() / 10.0;
        double extraOnRight = shapeEnv.getMaxX() + width;
        double extraOnLeft = shapeEnv.getMinX() - width;
        double extraOnTop = shapeEnv.getMaxY() + height;
        double extraOnBot = shapeEnv.getMinY() - height;
        shapeEnv.expandToInclude(extraOnRight, extraOnTop);
        shapeEnv.expandToInclude(extraOnLeft, extraOnBot);
        try {
            this.context.getWorkbenchContext().getLayerViewPanel().getViewport().zoom(shapeEnv);
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        this.changeSide();
    }

    private void changeSide() {
        Coordinate startPt = this.ghostCoords[this.getStartIndex()];
        Coordinate endPt = this.ghostCoords[this.getEndIndex()];
        Coordinate prevPt = this.ghostCoords[this.getPrevIndex()];
        this.lengthTextField.setText(this.df3.format(startPt.distance(endPt)));
        new GeoUtils();
        this.angleTextField.setText(this.df2.format(GeoUtils.getBearing180(startPt, endPt)));
        if (prevPt.equals2D(startPt)) {
            this.interiorAngleTextField.setEnabled(false);
            this.interiorAngleTextField.setText(sNA);
        } else {
            this.interiorAngleTextField.setEnabled(true);
            this.interiorAngleTextField.setText(this.df2.format(this.getInteriorAngle(prevPt, startPt, endPt)));
        }
        this.selectedSideLayer.getFeatureCollectionWrapper().remove(this.arrowFeature);
        FeatureSchema fs = this.selectedSideLayer.getFeatureCollectionWrapper().getFeatureSchema();
        this.arrowFeature = new BasicFeature(fs);
        this.arrowFeature.setGeometry((Geometry)this.getArcArrow());
        this.selectedSideLayer.getFeatureCollectionWrapper().add(this.arrowFeature);
        this.selectedSideLayer.fireAppearanceChanged();
    }

    private LineString getArcArrow() {
        Coordinate startPt = this.ghostCoords[this.getStartIndex()];
        Coordinate endPt = this.ghostCoords[this.getEndIndex()];
        Coordinate prevPt = this.ghostCoords[this.getPrevIndex()];
        CoordinateList arcCoords = new CoordinateList();
        if (prevPt.equals2D(startPt)) {
            arcCoords.add((Object)startPt);
        } else {
            double scale = this.context.getWorkbenchContext().getLayerViewPanel().getViewport().getScale();
            double arcAngle = this.getInteriorAngle(prevPt, startPt, endPt);
            new GeoUtils();
            Coordinate startArcPt = GeoUtils.along(15.0 / scale, startPt, prevPt);
            boolean cw = this.isClockwise;
            if (this.direction == 1) {
                boolean bl = cw = !cw;
            }
            if (cw) {
                arcAngle = -arcAngle;
            }
            this.angleArc = new Arc(startPt, startArcPt, arcAngle);
            arcCoords = this.angleArc.getCoordinates();
        }
        arcCoords.add((Object)endPt);
        return new GeometryFactory().createLineString(arcCoords.toCoordinateArray());
    }

    private double getInteriorAngle(Coordinate prevPt, Coordinate startPt, Coordinate endPt) {
        if (prevPt.equals2D(startPt)) {
            return 0.0;
        }
        MathVector v1 = new MathVector(prevPt).vectorBetween(new MathVector(startPt));
        MathVector v2 = new MathVector(startPt).vectorBetween(new MathVector(endPt));
        new GeoUtils();
        boolean toRight = GeoUtils.pointToRight(endPt, prevPt, startPt);
        boolean cw = this.isClockwise;
        if (this.direction == 1) {
            cw = !cw;
        }
        double angle = v1.angleDeg(v2);
        angle = cw && toRight || !cw && !toRight ? 180.0 - angle : 180.0 + angle;
        return angle;
    }

    private void updateGeo(int from) {
        switch (from) {
            case 0: {
                try {
                    double length = Double.parseDouble(this.lengthTextField.getText().trim());
                    if (length <= 0.0) {
                        this.reportValidationError(sLengthMustBeGreaterThanZero);
                        break;
                    }
                    Coordinate startPt = this.ghostCoords[this.getStartIndex()];
                    Coordinate endPt = this.ghostCoords[this.getEndIndex()];
                    new GeoUtils();
                    Coordinate newPt = GeoUtils.along(length, startPt, endPt);
                    this.replaceVertex(this.getEndIndex(), newPt);
                }
                catch (NumberFormatException e) {
                    this.reportValidationError("\"" + this.lengthTextField.getText().trim() + "\" " + sIsAnInvalidDouble + " (" + sLength + ")");
                }
                break;
            }
            case 1: {
                try {
                    double angle = Double.parseDouble(this.angleTextField.getText().trim());
                    Coordinate startPt = this.ghostCoords[this.getStartIndex()];
                    Coordinate endPt = this.ghostCoords[this.getEndIndex()];
                    double length = startPt.distance(endPt);
                    Coordinate newPt = (Coordinate)startPt.clone();
                    newPt.x += length;
                    new GeoUtils();
                    newPt = GeoUtils.rotPt(newPt, startPt, -angle);
                    this.replaceVertex(this.getEndIndex(), newPt);
                }
                catch (NumberFormatException e) {
                    this.reportValidationError("\"" + this.angleTextField.getText().trim() + "\" " + sIsAnInvalidDouble + " (" + sAngle + ")");
                }
                break;
            }
            case 2: {
                try {
                    Coordinate prevPt = this.ghostCoords[this.getPrevIndex()];
                    Coordinate startPt = this.ghostCoords[this.getStartIndex()];
                    Coordinate endPt = this.ghostCoords[this.getEndIndex()];
                    double angle = Double.parseDouble(this.interiorAngleTextField.getText().trim());
                    double length = startPt.distance(endPt);
                    boolean cw = this.isClockwise;
                    if (this.direction == 1) {
                        boolean bl = cw = !cw;
                    }
                    if (cw) {
                        angle = -angle;
                    }
                    new GeoUtils();
                    Coordinate newPt = GeoUtils.rotPt(prevPt, startPt, angle);
                    new GeoUtils();
                    newPt = GeoUtils.along(length, startPt, newPt);
                    this.replaceVertex(this.getEndIndex(), newPt);
                    break;
                }
                catch (NumberFormatException e) {
                    this.reportValidationError("\"" + this.interiorAngleTextField.getText().trim() + "\" " + sIsAnInvalidDouble + " (" + sInteriorAngle + ")");
                }
            }
        }
        this.changeSide();
        this.editLayer.fireAppearanceChanged();
    }

    private void replaceVertex(int index, Coordinate coord) {
        this.ghostCoords[index].x = coord.x;
        this.ghostCoords[index].y = coord.y;
        if (!this.isLineString) {
            if (index == 0) {
                this.ghostCoords[this.ghostCoords.length - 1].x = coord.x;
                this.ghostCoords[this.ghostCoords.length - 1].y = coord.y;
            }
            if (index == this.ghostCoords.length - 1) {
                this.ghostCoords[0].x = coord.x;
                this.ghostCoords[0].y = coord.y;
            }
        }
        this.ghostGeo.geometryChanged();
        this.hasPendingEdits = true;
    }

    private int getStartIndex() {
        if (this.direction == 0) {
            return this.currSide - 1;
        }
        return this.currSide;
    }

    private int getEndIndex() {
        if (this.direction == 0) {
            return this.currSide;
        }
        return this.currSide - 1;
    }

    private int getPrevIndex() {
        int prevIndex = this.currSide - 2;
        int nextIndex = this.currSide + 1;
        if (this.isLineString) {
            if (prevIndex < 0) {
                prevIndex = 0;
            }
            if (nextIndex >= this.ghostCoords.length) {
                nextIndex = this.ghostCoords.length - 1;
            }
        } else {
            if (prevIndex < 0) {
                prevIndex = this.ghostCoords.length - 2;
            }
            if (nextIndex >= this.ghostCoords.length) {
                nextIndex = 1;
            }
        }
        if (this.direction == 1) {
            prevIndex = nextIndex;
        }
        return prevIndex;
    }

    private int getNextIndex() {
        int prevIndex = this.currSide - 2;
        int nextIndex = this.currSide + 1;
        if (this.isLineString) {
            if (prevIndex < 0) {
                prevIndex = 0;
            }
            if (nextIndex >= this.ghostCoords.length) {
                nextIndex = this.ghostCoords.length - 1;
            }
        } else {
            if (prevIndex < 0) {
                prevIndex = this.ghostCoords.length - 2;
            }
            if (nextIndex >= this.ghostCoords.length) {
                nextIndex = 1;
            }
        }
        if (this.direction == 1) {
            nextIndex = prevIndex;
        }
        return nextIndex;
    }

    private boolean goodDouble(String fieldName) {
        try {
            Double.parseDouble(this.lengthTextField.getText().trim());
            return true;
        }
        catch (NumberFormatException e) {
            this.reportValidationError("\"" + this.lengthTextField.getText().trim() + "\" " + sIsAnInvalidDouble + " (" + fieldName + ")");
            return false;
        }
    }
}

