/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.mousemenu.category;

import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.util.List;
import org.openjump.core.ui.plugin.mousemenu.category.SetCategoryVisibilityPlugIn;

public class CategoryMover {
    protected PlugInContext context = null;

    public CategoryMover(PlugInContext context) {
        this.context = context;
    }

    protected Category getCategory(String name) {
        return this.context.getLayerManager().getCategory(name);
    }

    public void moveCategoryToPosition(String name, int pos) {
        this.moveCategoryToPosition(this.getCategory(name), pos);
    }

    public void moveCategoryToPosition(Category cat, int pos) {
        int i;
        LayerManager lm = this.context.getLayerManager();
        boolean catIsVisible = SetCategoryVisibilityPlugIn.getInstance(this.context).IsCategoryVisible(cat);
        lm.setFiringEvents(false);
        List categories = lm.getCategories();
        int currentPos = categories.indexOf(cat);
        if (pos < 0 || pos == currentPos) {
            return;
        }
        List layers = cat.getLayerables();
        Object[] layerArray = layers.toArray();
        for (i = 0; i < layerArray.length; ++i) {
            lm.remove((Layerable)layerArray[i]);
        }
        lm.setFiringEvents(true);
        lm.removeIfEmpty(cat);
        lm.addCategory(cat.getName(), Math.min(pos, categories.size()));
        SetCategoryVisibilityPlugIn.getInstance(this.context).setCategoryVisibility(lm.getCategory(cat.getName()), catIsVisible);
        for (i = 0; i < layerArray.length; ++i) {
            lm.addLayerable(cat.getName(), (Layerable)layerArray[i]);
        }
    }

    public void moveCategoryToTop(Category cat) {
        this.moveCategoryToPosition(cat, 0);
    }

    public void moveCategoryToBottom(Category cat) {
        List categories = this.context.getLayerManager().getCategories();
        this.moveCategoryToPosition(cat, categories.size() - 1);
    }

    public void moveCategoryOneUp(Category cat) {
        List categories = this.context.getLayerManager().getCategories();
        int currentPos = categories.indexOf(cat);
        this.moveCategoryToPosition(cat, currentPos - 1);
    }

    public void moveCategoryOneDown(Category cat) {
        List categories = this.context.getLayerManager().getCategories();
        int currentPos = categories.indexOf(cat);
        this.moveCategoryToPosition(cat, currentPos + 1);
    }
}

