/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.queries;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.openjump.core.ui.plugin.queries.Function;
import org.openjump.core.ui.plugin.queries.Operator;
import org.openjump.core.ui.plugin.queries.QueryDialog;

public class Condition {
    QueryDialog query;
    Function ft;
    Operator op;
    Pattern pattern;
    PlugInContext context;

    public Condition(QueryDialog query, PlugInContext context) {
        this.query = query;
        this.ft = query.function;
        this.op = query.operator;
        if (this.op == Operator.MATC || this.op == Operator.FIND) {
            this.pattern = query.caseSensitive.getState() ? Pattern.compile((String)query.valueCB.getSelectedValue()) : Pattern.compile((String)query.valueCB.getSelectedValue(), 2);
        }
        this.context = context;
    }

    public String toString() {
        String att = this.query.attribute.trim().equals("") ? "GEOMETRY" : this.query.attribute;
        String func = this.ft.toString().trim().equals("") ? "" : "." + this.ft;
        return "" + att + func + " " + this.op + " \"" + this.query.valueCB.getSelectedValue() + "\"";
    }

    public boolean test(Feature feature) throws Exception {
        Object o = null;
        if (this.query.attributeType == 'G') {
            o = feature.getGeometry();
            if (this.ft.type == 'G') {
                return this.test(this.gfunction((Geometry)o));
            }
            if (this.ft.type == 'N') {
                return this.test(this.nfunction((Geometry)o));
            }
            if (this.ft.type == 'B') {
                return this.test(this.bfunction((Geometry)o));
            }
            return false;
        }
        o = feature.getAttribute(this.query.attribute);
        if (o instanceof Boolean) {
            return this.test((Boolean)o);
        }
        if (o instanceof Integer) {
            return this.test(((Integer)o).doubleValue());
        }
        if (o instanceof Long) {
            return this.test(((Long)o).doubleValue());
        }
        if (o instanceof Double) {
            return this.test((Double)o);
        }
        if (o instanceof BigDecimal) {
            return this.test(((BigDecimal)o).doubleValue());
        }
        if (o instanceof Date) {
            return this.test(((Date)o).getTime());
        }
        if (o instanceof String && this.ft.type == 'S') {
            return this.test(this.sfunction((String)o));
        }
        if (o instanceof String && this.ft.type == 'N') {
            return this.test(this.nfunction((String)o));
        }
        return false;
    }

    private boolean test(boolean b) throws Exception {
        boolean value;
        boolean bl = value = this.query.valueCB.getSelectedIndex() == 0;
        return b == value && this.op == Operator.BEQ;
    }

    private boolean test(double d) throws Exception {
        double value = Double.parseDouble((String)this.query.valueCB.getSelectedValue());
        if (this.op == Operator.EQ && d == value) {
            return true;
        }
        if (this.op == Operator.NE && d != value) {
            return true;
        }
        if (this.op == Operator.LT && d < value) {
            return true;
        }
        if (this.op == Operator.GT && d > value) {
            return true;
        }
        if (this.op == Operator.LE && d <= value) {
            return true;
        }
        return this.op == Operator.GE && d >= value;
    }

    private boolean test(String s) throws Exception {
        String value = (String)this.query.valueCB.getSelectedValue();
        if (this.query.caseSensitive.getState()) {
            if (this.op == Operator.EQUA) {
                return s.equals(value);
            }
            if (this.op == Operator.DIFF) {
                return !s.equals(value);
            }
            if (this.op == Operator.STAR) {
                return s.startsWith(value);
            }
            if (this.op == Operator.ENDS) {
                return s.endsWith(value);
            }
            if (this.op == Operator.MATC) {
                return this.pattern.matcher(s).matches();
            }
            if (this.op == Operator.FIND) {
                return this.pattern.matcher(s).find();
            }
            if (this.op == Operator.BEFO) {
                return s.compareTo(value) <= 0;
            }
            if (this.op == Operator.AFTE) {
                return s.compareTo(value) >= 0;
            }
            return false;
        }
        if (this.op == Operator.EQUA) {
            return s.equalsIgnoreCase(value);
        }
        if (this.op == Operator.DIFF) {
            return !s.equalsIgnoreCase(value);
        }
        if (this.op == Operator.STAR) {
            return s.toUpperCase().startsWith(value.toUpperCase());
        }
        if (this.op == Operator.ENDS) {
            return s.toUpperCase().endsWith(value.toUpperCase());
        }
        if (this.op == Operator.MATC) {
            return this.pattern.matcher(s).matches();
        }
        if (this.op == Operator.FIND) {
            return this.pattern.matcher(s).find();
        }
        if (this.op == Operator.BEFO) {
            return s.compareToIgnoreCase(value) <= 0;
        }
        if (this.op == Operator.AFTE) {
            return s.compareToIgnoreCase(value) >= 0;
        }
        return false;
    }

    private boolean test(Geometry g) throws Exception {
        int pos = this.query.valueCB.getSelectedIndex();
        if (pos == 1) {
            for (Geometry p : this.query.selection) {
                if (this.op == Operator.INTER && g.intersects(p)) {
                    return true;
                }
                if (this.op == Operator.CONTA && g.contains(p)) {
                    return true;
                }
                if (this.op == Operator.WITHI && g.within(p)) {
                    return true;
                }
                if (this.op == Operator.WDIST && g.distance(p) < this.op.arg) {
                    return true;
                }
                if (this.op == Operator.TOUCH && g.touches(p)) {
                    return true;
                }
                if (this.op == Operator.CROSS && g.crosses(p)) {
                    return true;
                }
                if (this.op == Operator.OVERL && g.overlaps(p)) {
                    return true;
                }
                if (this.op != Operator.DISJO || !g.disjoint(p)) continue;
                return true;
            }
            return false;
        }
        if (pos == 2) {
            int i = 0;
            Layer[] ll = this.context.getLayerNamePanel().getSelectedLayers();
            if (i < ll.length) {
                FeatureCollectionWrapper fc = ll[i].getFeatureCollectionWrapper();
                Iterator it = fc.iterator();
                while (it.hasNext()) {
                    Geometry p = ((Feature)it.next()).getGeometry();
                    if (this.op == Operator.INTER && g.intersects(p)) {
                        return true;
                    }
                    if (this.op == Operator.CONTA && g.contains(p)) {
                        return true;
                    }
                    if (this.op == Operator.WITHI && g.within(p)) {
                        return true;
                    }
                    if (this.op == Operator.WDIST && g.distance(p) < this.op.arg) {
                        return true;
                    }
                    if (this.op == Operator.TOUCH && g.touches(p)) {
                        return true;
                    }
                    if (this.op == Operator.CROSS && g.crosses(p)) {
                        return true;
                    }
                    if (this.op == Operator.OVERL && g.overlaps(p)) {
                        return true;
                    }
                    if (this.op != Operator.DISJO || !g.disjoint(p)) continue;
                    return true;
                }
                return false;
            }
        } else if (pos == 0) {
            int i = 0;
            List ll = this.context.getLayerManager().getLayers();
            if (i < ll.size()) {
                FeatureCollectionWrapper fc = ((Layer)ll.get(i)).getFeatureCollectionWrapper();
                Iterator it = fc.iterator();
                while (it.hasNext()) {
                    Geometry p = ((Feature)it.next()).getGeometry();
                    if (this.op == Operator.INTER && g.intersects(p)) {
                        return true;
                    }
                    if (this.op == Operator.CONTA && g.contains(p)) {
                        return true;
                    }
                    if (this.op == Operator.WITHI && g.within(p)) {
                        return true;
                    }
                    if (this.op == Operator.WDIST && g.distance(p) < this.op.arg) {
                        return true;
                    }
                    if (this.op == Operator.TOUCH && g.touches(p)) {
                        return true;
                    }
                    if (this.op == Operator.CROSS && g.crosses(p)) {
                        return true;
                    }
                    if (this.op == Operator.OVERL && g.overlaps(p)) {
                        return true;
                    }
                    if (this.op != Operator.DISJO || !g.disjoint(p)) continue;
                    return true;
                }
                return false;
            }
        } else {
            Layer layer = this.context.getLayerManager().getLayer((String)this.query.valueCB.getSelectedValue());
            FeatureCollectionWrapper fc = layer.getFeatureCollectionWrapper();
            Iterator it = fc.iterator();
            while (it.hasNext()) {
                Geometry p = ((Feature)it.next()).getGeometry();
                if (this.op == Operator.INTER && g.intersects(p)) {
                    return true;
                }
                if (this.op == Operator.CONTA && g.contains(p)) {
                    return true;
                }
                if (this.op == Operator.WITHI && g.within(p)) {
                    return true;
                }
                if (this.op == Operator.WDIST && g.distance(p) < this.op.arg) {
                    return true;
                }
                if (this.op == Operator.TOUCH && g.touches(p)) {
                    return true;
                }
                if (this.op == Operator.CROSS && g.crosses(p)) {
                    return true;
                }
                if (this.op == Operator.OVERL && g.overlaps(p)) {
                    return true;
                }
                if (this.op != Operator.DISJO || !g.disjoint(p)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private String sfunction(String s) {
        if (this.ft == Function.SNOF) {
            return s;
        }
        if (this.ft == Function.TRIM) {
            return s.trim();
        }
        if (this.ft == Function.SUBS && this.ft.args.length == 1) {
            return s.substring(this.ft.args[0]);
        }
        if (this.ft == Function.SUBS && this.ft.args.length == 2) {
            return s.substring(this.ft.args[0], this.ft.args[1]);
        }
        return s;
    }

    private double nfunction(String s) {
        if (this.ft == Function.LENG) {
            return s.length();
        }
        return 0.0;
    }

    private Geometry gfunction(Geometry g) {
        if (this.ft == Function.GNOF) {
            return g;
        }
        if (this.ft == Function.CENT) {
            return g.getInteriorPoint();
        }
        if (this.ft == Function.BUFF) {
            return g.buffer((double)this.ft.args[0]);
        }
        return g;
    }

    private double nfunction(Geometry g) {
        if (this.ft == Function.LENG) {
            return g.getLength();
        }
        if (this.ft == Function.AREA) {
            return g.getArea();
        }
        if (this.ft == Function.NBPT) {
            return g.getNumPoints();
        }
        if (this.ft == Function.NBPA) {
            if (g.isEmpty()) {
                return 0.0;
            }
            if (g instanceof GeometryCollection) {
                return ((GeometryCollection)g).getNumGeometries();
            }
            return 1.0;
        }
        return 0.0;
    }

    private boolean bfunction(Geometry g) {
        if (this.ft == Function.EMPT) {
            return g.isEmpty();
        }
        if (this.ft == Function.SIMP) {
            return g.isSimple();
        }
        if (this.ft == Function.VALI) {
            return g.isValid();
        }
        return false;
    }
}

