/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class AutoAssignAttributePlugIn
extends AbstractPlugIn {
    private static String LAYER_COMBO_BOX = GenericNames.LAYER;
    private static String DEST_COMBO_BOX = "Destination attribute";
    private static String SOURCE_COMBO_BOX = "Source attribute";
    private static String FROM_SOURCE_CHECK_BOX = "Assign from other attribute";
    private static final String A_CHECK_BOX = "invisible checkbox";
    private static String AUTOINC_CHECK_BOX = "Auto-increment";
    private static String INC_VALUE_EDIT_BOX = "Increment by";
    private static String SELECTED_CHECK_BOX = "Selected features only";
    private static String ASSIGN_VALUE_TEXT_BOX = "Assign this value";
    private static String SELECTONLYONONELAYER = "Select features on only one layer";
    private static String DESCRIPTION = "Assign a value from another attribute, a value, an auto-increment number or a combination of a value and an auto-increment number";
    private int autoInc;
    private Layer destinationLayer;
    private FeatureSchema schema;
    private String attributeName;
    private String sourceAttributeName;
    private int destinationAttributeIndex;
    private int sourceAttributeIndex;
    private AttributeType attributeType;
    private boolean autoIncrement;
    private int incValue;
    private boolean assignFromSource;
    private boolean selectedFeaturesOnly;
    private String textToAssign;
    private String numeric;
    private JTextField incfield = null;
    private Map typeToConverterMap = new HashMap(){
        {
            this.put(AttributeType.STRING, new Converter(){

                public Object convert(String d) {
                    return d;
                }
            });
            this.put(AttributeType.INTEGER, new Converter(){

                public Object convert(String d) {
                    String s = AutoAssignAttributePlugIn.this.parseNumber(d);
                    if (s.length() == 0) {
                        return new Integer(0);
                    }
                    return new Integer(s);
                }
            });
            this.put(AttributeType.DOUBLE, new Converter(){

                public Object convert(String d) {
                    String s = AutoAssignAttributePlugIn.this.parseNumber(d);
                    if (s.length() == 0) {
                        return new Double(0.0);
                    }
                    return new Double(AutoAssignAttributePlugIn.this.parseNumber(d));
                }
            });
        }
    };

    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuItem((PlugIn)this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_ATTRIBUTES}, this.getName() + "...", false, null, (EnableCheck)this.createEnableCheck(context.getWorkbenchContext()));
        DEST_COMBO_BOX = I18N.get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Destination-attribute");
        SOURCE_COMBO_BOX = I18N.get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Source-attribute");
        FROM_SOURCE_CHECK_BOX = I18N.get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Assign-from-other-attribute");
        AUTOINC_CHECK_BOX = I18N.get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Auto-increment");
        INC_VALUE_EDIT_BOX = I18N.get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Increment-by");
        SELECTED_CHECK_BOX = I18N.get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Selected-features-only");
        ASSIGN_VALUE_TEXT_BOX = I18N.get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Assign-this-value");
        SELECTONLYONONELAYER = I18N.get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Select-features-on-only-one-layer");
        DESCRIPTION = I18N.get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Description");
    }

    public String getName() {
        return I18N.get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Auto-Assign-Attribute");
    }

    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = this.prompt(context);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        this.assignValues(context);
        return true;
    }

    private MultiInputDialog prompt(PlugInContext context) {
        final MultiInputDialog dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), true);
        dialog.setSideBarDescription(DESCRIPTION);
        dialog.addEditableLayerComboBox(LAYER_COMBO_BOX, null, null, context.getLayerManager());
        this.initComboFields(dialog, A_CHECK_BOX, DEST_COMBO_BOX, 0);
        dialog.addCheckBox(AUTOINC_CHECK_BOX, true);
        this.incfield = dialog.addIntegerField(INC_VALUE_EDIT_BOX, 1, 4, "Auto-increment number by this value");
        dialog.indentLabel(INC_VALUE_EDIT_BOX);
        this.initComboFields(dialog, FROM_SOURCE_CHECK_BOX, SOURCE_COMBO_BOX, 1);
        dialog.getCheckBox(FROM_SOURCE_CHECK_BOX).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.getComboBox(SOURCE_COMBO_BOX).setEnabled(dialog.getCheckBox(FROM_SOURCE_CHECK_BOX).isSelected());
                boolean fromSelected = dialog.getCheckBox(FROM_SOURCE_CHECK_BOX).isSelected();
                dialog.getLabel(SOURCE_COMBO_BOX).setEnabled(fromSelected);
                JCheckBox checkbox = dialog.getCheckBox(AUTOINC_CHECK_BOX);
                checkbox.setEnabled(!fromSelected);
                AutoAssignAttributePlugIn.this.incfield.setEnabled(!fromSelected);
                if (fromSelected) {
                    checkbox.setSelected(false);
                }
            }
        });
        this.initEnableChecks(dialog);
        boolean selectionExists = context.getLayerViewPanel().getSelectionManager().getFeatureSelection().getSelectedItems().size() > 0;
        dialog.addCheckBox(SELECTED_CHECK_BOX, selectionExists);
        dialog.addTextField(ASSIGN_VALUE_TEXT_BOX, "", 15, null, "Enter value to assign. Numeric portion used as start value.");
        this.loadValues(dialog, context);
        dialog.getCheckBox(A_CHECK_BOX).setVisible(false);
        dialog.setVisible(true);
        if (dialog.wasOKPressed()) {
            this.saveValues(dialog, context);
        }
        return dialog;
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.destinationLayer = dialog.getLayer(LAYER_COMBO_BOX);
        this.attributeName = dialog.getText(DEST_COMBO_BOX);
        this.sourceAttributeName = dialog.getText(SOURCE_COMBO_BOX);
        this.schema = this.destinationLayer.getFeatureCollectionWrapper().getFeatureSchema();
        this.destinationAttributeIndex = this.schema.getAttributeIndex(this.attributeName);
        this.sourceAttributeIndex = this.schema.getAttributeIndex(this.sourceAttributeName);
        this.attributeType = this.schema.getAttributeType(this.destinationAttributeIndex);
        this.autoIncrement = dialog.getBoolean(AUTOINC_CHECK_BOX);
        this.incValue = dialog.getInteger(INC_VALUE_EDIT_BOX);
        this.selectedFeaturesOnly = dialog.getBoolean(SELECTED_CHECK_BOX);
        this.textToAssign = dialog.getText(ASSIGN_VALUE_TEXT_BOX);
        this.numeric = this.parseNumber(this.textToAssign);
        this.autoInc = this.autoIncrement ? (this.numeric.length() == 0 ? 0 : new Integer(this.numeric)) : 0;
        this.assignFromSource = dialog.getBoolean(FROM_SOURCE_CHECK_BOX);
    }

    private void saveValues(MultiInputDialog dialog, PlugInContext context) {
        Blackboard blackboard = context.getLayerManager().getBlackboard();
        blackboard.put(this.namespace() + LAYER_COMBO_BOX, dialog.getLayer(LAYER_COMBO_BOX));
        blackboard.put(this.namespace() + FROM_SOURCE_CHECK_BOX, dialog.getCheckBox(FROM_SOURCE_CHECK_BOX).isSelected());
        blackboard.put(this.namespace() + DEST_COMBO_BOX, dialog.getComboBox(DEST_COMBO_BOX).getSelectedItem());
        blackboard.put(this.namespace() + SOURCE_COMBO_BOX, dialog.getComboBox(SOURCE_COMBO_BOX).getSelectedItem());
    }

    private void loadValues(MultiInputDialog dialog, PlugInContext context) {
        Blackboard blackboard = context.getLayerManager().getBlackboard();
        dialog.getComboBox(LAYER_COMBO_BOX).setSelectedItem(CollectionUtil.ifNotIn(blackboard.get(this.namespace() + LAYER_COMBO_BOX), GUIUtil.items((JComboBox)dialog.getComboBox(LAYER_COMBO_BOX)), this.candidateLayer(context)));
        GUIUtil.setSelectedWithClick((JCheckBox)dialog.getCheckBox(FROM_SOURCE_CHECK_BOX), (boolean)blackboard.get(this.namespace() + FROM_SOURCE_CHECK_BOX, false));
        dialog.getComboBox(DEST_COMBO_BOX).setSelectedItem(CollectionUtil.ifNotIn(blackboard.get(this.namespace() + DEST_COMBO_BOX), GUIUtil.items((JComboBox)dialog.getComboBox(DEST_COMBO_BOX)), dialog.getComboBox(DEST_COMBO_BOX).getSelectedItem()));
        dialog.getComboBox(SOURCE_COMBO_BOX).setSelectedItem(CollectionUtil.ifNotIn(blackboard.get(this.namespace() + SOURCE_COMBO_BOX), GUIUtil.items((JComboBox)dialog.getComboBox(SOURCE_COMBO_BOX)), dialog.getComboBox(SOURCE_COMBO_BOX).getSelectedItem()));
    }

    private String namespace() {
        return ((Object)((Object)this)).getClass().getName() + " - ";
    }

    private void initEnableChecks(final MultiInputDialog dialog) {
        dialog.addEnableChecks(SOURCE_COMBO_BOX, Arrays.asList(new EnableCheck(){

            public String check(JComponent component) {
                return dialog.getBoolean(FROM_SOURCE_CHECK_BOX) && dialog.getText(DEST_COMBO_BOX).equals(dialog.getText(SOURCE_COMBO_BOX)) ? "Source and destination attributes must be different" : null;
            }
        }));
    }

    private String attributeName(List attributeNames, int preferredIndex) {
        return (String)attributeNames.get(attributeNames.size() > preferredIndex ? preferredIndex : 0);
    }

    private void initComboFields(final MultiInputDialog dialog, final String checkBoxFieldName, final String comboBoxFieldName, final int preferredCandidateAttributeIndex) {
        dialog.addCheckBox(checkBoxFieldName, true);
        dialog.addComboBox(comboBoxFieldName, null, new ArrayList(), null);
        dialog.getComboBox(LAYER_COMBO_BOX).addActionListener(new ActionListener(){
            private Layer lastLayer = null;

            public void actionPerformed(ActionEvent e) {
                Layer newLayer = (Layer)dialog.getComboBox(LAYER_COMBO_BOX).getSelectedItem();
                if (this.lastLayer == newLayer) {
                    return;
                }
                this.lastLayer = newLayer;
                dialog.getComboBox(comboBoxFieldName).setModel(new DefaultComboBoxModel(new Vector(AutoAssignAttributePlugIn.this.candidateAttributeNames(newLayer))));
                if (!AutoAssignAttributePlugIn.this.candidateAttributeNames(newLayer).isEmpty()) {
                    dialog.getComboBox(comboBoxFieldName).setSelectedItem(AutoAssignAttributePlugIn.this.attributeName(AutoAssignAttributePlugIn.this.candidateAttributeNames(newLayer), preferredCandidateAttributeIndex));
                }
            }
        });
        dialog.addEnableChecks(comboBoxFieldName, Arrays.asList(new EnableCheck(){

            public String check(JComponent component) {
                return dialog.getBoolean(checkBoxFieldName) && dialog.getComboBox(comboBoxFieldName).getItemCount() == 0 ? "Layer has no string, integer, or double attributes" : null;
            }
        }));
        dialog.indentLabel(comboBoxFieldName);
    }

    private Layer candidateLayer(PlugInContext context) {
        if (context.getActiveInternalFrame() instanceof LayerNamePanelProxy) {
            Layer[] selectedLayers = context.getSelectedLayers();
            for (int i = 0; i < selectedLayers.length; ++i) {
                if (!selectedLayers[i].isEditable()) continue;
                return selectedLayers[i];
            }
        }
        return (Layer)context.getLayerManager().getEditableLayers().iterator().next();
    }

    private List candidateAttributeNames(Layer layer) {
        ArrayList<String> candidateAttributeNames = new ArrayList<String>();
        FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (!this.typeToConverterMap.keySet().contains(schema.getAttributeType(i))) continue;
            candidateAttributeNames.add(schema.getAttributeName(i));
        }
        return candidateAttributeNames;
    }

    private String parseNumber(String assignText) {
        int b = 0;
        int e = 0;
        for (int i = 0; i < assignText.length(); ++i) {
            if (!Character.isDigit(assignText.charAt(i))) continue;
            b = i;
            for (e = i; e < assignText.length() && Character.isDigit(assignText.charAt(e)); ++e) {
            }
            return assignText.substring(b, e);
        }
        return "";
    }

    private void assignValues(PlugInContext context) {
        Iterator iterator;
        if (this.selectedFeaturesOnly) {
            Collection layers = context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
            if (layers.size() > 1) {
                context.getWorkbenchFrame().warnUser(SELECTONLYONONELAYER);
            }
            iterator = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems().iterator();
        } else {
            iterator = this.destinationLayer.getFeatureCollectionWrapper().getFeatures().iterator();
        }
        Iterator i = iterator;
        while (i.hasNext()) {
            Feature feature = (Feature)i.next();
            String s = this.textToAssign;
            if (this.autoIncrement) {
                String value = "" + this.autoInc;
                this.autoInc += this.incValue;
                s = this.numeric.length() == 0 ? value : this.textToAssign.replaceFirst(this.numeric, value);
            } else if (this.assignFromSource) {
                s = feature.getAttribute(this.sourceAttributeIndex).toString();
                if (this.numeric.length() > 0) {
                    s = this.textToAssign.replaceFirst(this.numeric, s);
                }
            }
            Object object = ((Converter)this.typeToConverterMap.get(this.attributeType)).convert(s);
            feature.setAttribute(this.destinationAttributeIndex, object);
        }
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1)).add(checkFactory.createAtLeastNLayersMustBeEditableCheck(1));
    }

    private static interface Converter {
        public Object convert(String var1);
    }
}

