/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;

public class DeleteDuplicateGeometriesPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private String CLAYER = "select layer";
    private String sDescription = "deletes features with similar geometry";
    private String deleteByAttribute = "delete only if attributes are the same";
    private String sName = "Delete Duplicate Geometries";
    private String sChecked = "checked";
    private String sCleaned = "cleaned";
    private Layer itemlayer = null;
    private boolean deleteOnlyForSameAttributes = false;

    public void initialize(PlugInContext context) throws Exception {
        this.CLAYER = GenericNames.SELECT_LAYER;
        this.sDescription = I18N.get("org.openjump.core.ui.plugin.tools.DeleteDuplicateGeometriesPlugIn.deletes-features-with-similar-geometry");
        this.deleteByAttribute = I18N.get("org.openjump.core.ui.plugin.tools.DeleteDuplicateGeometriesPlugIn.delete-only-if-attributes-are-the-same");
        this.sName = I18N.get("org.openjump.core.ui.plugin.tools.DeleteDuplicateGeometriesPlugIn.Delete-Duplicate-Geometries");
        this.sChecked = I18N.get("org.openjump.core.ui.plugin.tools.DeleteDuplicateGeometriesPlugIn.checked");
        this.sCleaned = I18N.get("org.openjump.core.ui.plugin.tools.DeleteDuplicateGeometriesPlugIn.cleaned");
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem((PlugIn)this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_QA}, this.getName() + "...", false, null, (EnableCheck)DeleteDuplicateGeometriesPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    public String getName() {
        return this.sName;
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow((Component)dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(this.sDescription);
        JComboBox addLayerComboBoxBuild = dialog.addLayerComboBox(this.CLAYER, context.getCandidateLayer(0), null, context.getLayerManager());
        dialog.addCheckBox(this.deleteByAttribute, this.deleteOnlyForSameAttributes);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.itemlayer = dialog.getLayer(this.CLAYER);
        this.deleteOnlyForSameAttributes = dialog.getBoolean(this.deleteByAttribute);
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        this.delete(context, monitor);
        System.gc();
    }

    private boolean delete(PlugInContext context, TaskMonitor monitor) throws Exception {
        System.gc();
        List features = this.itemlayer.getFeatureCollectionWrapper().getFeatures();
        ArrayList notFoundItemsOld = new ArrayList();
        ArrayList<Feature> notFoundItemsNew = new ArrayList<Feature>();
        ArrayList doneItems = new ArrayList();
        int size = features.size();
        Iterator iter = features.iterator();
        Feature f = (Feature)iter.next();
        FeatureSchema fs = f.getSchema();
        FeatureDataset myCollA = new FeatureDataset(fs);
        Feature fi = null;
        int count = 1;
        int dropped = 0;
        notFoundItemsOld.addAll(features);
        while (iter.hasNext()) {
            monitor.report(count, size, this.sChecked);
            ++count;
            fi = (Feature)iter.next();
            Geometry geom = fi.getGeometry();
            int copycounter = 0;
            for (int j = 0; j < notFoundItemsOld.size(); ++j) {
                boolean isequal = false;
                Feature testF = (Feature)notFoundItemsOld.get(j);
                try {
                    isequal = geom.equals(testF.getGeometry());
                    if (isequal && this.deleteOnlyForSameAttributes) {
                        boolean attributesAreDifferent = false;
                        for (int k = 0; k < fs.getAttributeCount(); ++k) {
                            Object val2;
                            Object val1;
                            if (fs.getAttributeType(k) == AttributeType.GEOMETRY || (val1 = fi.getAttribute(k)).equals(val2 = testF.getAttribute(k))) continue;
                            attributesAreDifferent = true;
                        }
                        if (attributesAreDifferent) {
                            isequal = false;
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println("items have problem (toplogy): " + testF.getID() + " and " + fi.getID());
                    System.out.println(e.getStackTrace());
                }
                if (isequal) {
                    if (++copycounter == 1) {
                        notFoundItemsNew.add(testF);
                        continue;
                    }
                    ++dropped;
                    continue;
                }
                notFoundItemsNew.add(testF);
            }
            notFoundItemsOld.clear();
            notFoundItemsOld.addAll(notFoundItemsNew);
            notFoundItemsNew.clear();
        }
        for (Feature element : notFoundItemsOld) {
            myCollA.add((Feature)element.clone());
        }
        context.addLayer(StandardCategoryNames.WORKING, this.itemlayer.getName() + "-" + this.sCleaned, (FeatureCollection)myCollA);
        return true;
    }
}

