/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class ZoomRealtimeTool
extends DragTool {
    private static final double ZOOM_FACTOR = 5.0;
    private static final double ZOOM_OUT_LIMIT = 0.1;
    private boolean dragging = false;
    private Image origImage;
    private Image auxImage = null;
    private double scale = 1.0;
    private Point2D.Double zoomTo = new Point2D.Double(0.0, 0.0);
    private boolean rightMouse = false;
    private static final String sName = I18N.get("org.openjump.core.ui.plugin.tools.ZoomRealtimeTool.Zoom-Realtime");

    public Cursor getCursor() {
        return ZoomRealtimeTool.createCursor((Image)IconLoader.icon((String)"MagnifyCursor2.gif").getImage());
    }

    public Icon getIcon() {
        return IconLoader.icon((String)"Magnify3.gif");
    }

    public boolean isRightMouseButtonUsed() {
        return true;
    }

    public String getName() {
        return sName;
    }

    public void mouseDragged(MouseEvent e) {
        try {
            this.rightMouse = SwingUtilities.isRightMouseButton(e);
            if (!this.dragging) {
                this.dragging = true;
                this.getPanel().getRenderingManager().setPaintingEnabled(false);
                this.cacheImage();
            }
            this.drawImage(e.getPoint());
            super.mouseDragged(e);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.dragging) {
            try {
                this.getPanel().getViewport().zoomToViewPoint((Point2D)e.getPoint(), 1.0);
            }
            catch (NoninvertibleTransformException ex) {
                return;
            }
        }
        this.getPanel().getRenderingManager().setPaintingEnabled(true);
        this.dragging = false;
        super.mouseReleased(e);
    }

    protected Shape getShape(Point2D source, Point2D destination) {
        return null;
    }

    protected void gestureFinished() throws NoninvertibleTransformException {
        this.reportNothingToUndoYet();
        RenderingManager renderManager = this.getPanel().getRenderingManager();
        renderManager.setPaintingEnabled(false);
        this.getPanel().getViewport().zoomToViewPoint((Point2D)this.zoomTo, this.scale);
        renderManager.getDefaultRendererThreadQueue().add(new Runnable(){

            public void run() {
                RenderingManager renderManager = ZoomRealtimeTool.this.getPanel().getRenderingManager();
                renderManager.setPaintingEnabled(true);
                renderManager.repaintPanel();
            }
        });
    }

    private void cacheImage() {
        this.origImage = this.createImageIfNeeded(this.origImage);
        this.getPanel().paint(this.origImage.getGraphics());
    }

    private void drawImage(Point p) throws NoninvertibleTransformException {
        double xdrag = p.getX() - this.getViewSource().getX();
        double ydrag = p.getY() - this.getViewSource().getY();
        double scaleFactor = this.rightMouse ? 5.0 * xdrag : 5.0 * ydrag;
        double w = this.origImage.getWidth((ImageObserver)this.getPanel());
        double h = this.origImage.getHeight((ImageObserver)this.getPanel());
        this.scale = (h + scaleFactor) / h;
        this.scale = this.scale < 0.1 ? 0.1 : this.scale;
        double w2 = w * this.scale;
        double h2 = h * this.scale;
        double dx = (w - w2) / 2.0;
        double dy = (h - h2) / 2.0;
        double xoff = 0.0;
        double yoff = 0.0;
        if (this.rightMouse) {
            yoff = ydrag / this.scale;
        } else {
            xoff = xdrag / this.scale;
        }
        this.zoomTo.x = dx + w2 / 2.0 - xoff;
        this.zoomTo.y = dy + h2 / 2.0 - yoff;
        if (this.rightMouse) {
            dy += ydrag;
        } else {
            dx += xdrag;
        }
        this.auxImage = this.createImageIfNeeded(this.auxImage);
        Graphics2D g = (Graphics2D)this.auxImage.getGraphics();
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHints(rh);
        g.setComposite(AlphaComposite.Src);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.auxImage.getWidth((ImageObserver)this.getPanel()), this.auxImage.getHeight((ImageObserver)this.getPanel()));
        g.drawImage(this.origImage, (int)dx, (int)dy, (int)w2, (int)h2, (ImageObserver)this.getPanel());
        this.getPanel().getGraphics().drawImage(this.auxImage, 0, 0, (ImageObserver)this.getPanel());
    }

    private Image createImageIfNeeded(Image currImage) {
        if (currImage == null || currImage.getHeight(null) != this.getPanel().getHeight() || currImage.getWidth(null) != this.getPanel().getWidth()) {
            Graphics2D g = (Graphics2D)this.getPanel().getGraphics();
            BufferedImage img = g.getDeviceConfiguration().createCompatibleImage(this.getPanel().getWidth(), this.getPanel().getHeight(), 1);
            return img;
        }
        return currImage;
    }
}

