/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.io;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Viewport;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import org.openjump.core.ui.plugin.layer.AddSIDLayerPlugIn;

public class SIDLayer
extends WMSLayer {
    static final String sLayer = I18N.get("org.openjump.io.SIDLayer.Layer");
    static final String couldNotGetSIDinfoFor = I18N.get("org.openjump.io.SIDLayer.Could-not-get-SID-info-for");
    static final String sLevel = I18N.get("org.openjump.io.SIDLayer.level");
    static final String sOf = I18N.get("org.openjump.io.SIDLayer.of");
    private SID_Info_List sidInfoList;
    private List imageFilenames = new ArrayList();
    private List deletedSIDs = new ArrayList();
    private int sidPixelWidth = 0;
    private int sidPixelHeight = 0;
    private double sid_xres = 1.0;
    private double sid_xrot = 0.0;
    private double sid_yrot = 0.0;
    private double sid_yres = 1.0;
    private double sid_ulx = 0.0;
    private double sid_uly = 0.0;
    private String sid_colorspace;
    private int maxLevel = 0;
    private PlugInContext callingContext;

    public SIDLayer() {
        this.sidInfoList = new SID_Info_List();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIDLayer(PlugInContext context, List layerNames) throws IOException {
        this.callingContext = context;
        LayerManager layerManager = context.getLayerManager();
        String name = "MrSID " + sLayer;
        Assert.isTrue((name != null ? 1 : 0) != 0);
        Assert.isTrue((layerManager != null ? 1 : 0) != 0);
        this.setLayerManager(layerManager);
        boolean firingEvents = layerManager.isFiringEvents();
        layerManager.setFiringEvents(false);
        try {
            this.setName(layerManager.uniqueLayerName(name));
        }
        finally {
            layerManager.setFiringEvents(firingEvents);
        }
        this.sidInfoList = new SID_Info_List(layerNames);
    }

    private int round(double num) {
        return (int)Math.round(num);
    }

    public Image createImage(LayerViewPanel panel) throws IOException {
        this.totalBounds = new Envelope();
        BufferedImage newImage = new BufferedImage(panel.getWidth(), panel.getHeight(), 2);
        Graphics2D g = (Graphics2D)newImage.getGraphics();
        g.setColor(new Color(0, 0, 0, 0));
        g.fillRect(0, 0, panel.getWidth(), panel.getHeight());
        List imageFilenames = this.sidInfoList.getFileNames();
        for (Object currObj : imageFilenames) {
            int sid_h;
            String sidFilename = (String)currObj;
            SID_Info sidInfo = this.sidInfoList.getInfo(sidFilename);
            if (sidInfo == null) {
                this.callingContext.getWorkbenchFrame().getOutputFrame().addText("Could not get SID info for " + sidFilename);
                continue;
            }
            int sidPixelWidth = sidInfo.getPixelWidth();
            int sidPixelHeight = sidInfo.getPixelHeight();
            double sid_xres = sidInfo.getXRes();
            double sid_ulx = sidInfo.getULX();
            double sid_uly = sidInfo.getULY();
            int image_x = 0;
            int image_y = 0;
            int image_w = panel.getWidth();
            int image_h = panel.getHeight();
            Viewport viewport = panel.getViewport();
            Envelope vpEnvelope = viewport.getEnvelopeInModelCoordinates();
            double view_res = 1.0 / viewport.getScale();
            double rwViewLeft = vpEnvelope.getMinX();
            double rwViewRight = vpEnvelope.getMaxX();
            double rwViewTop = vpEnvelope.getMaxY();
            double rwViewBot = vpEnvelope.getMinY();
            double halfPixel = 0.5 * sid_xres;
            double rwSidFileLeftEdge = sid_ulx - halfPixel;
            double rwSidFileRightEdge = rwSidFileLeftEdge + (double)sidPixelWidth * sid_xres;
            double rwSidFileTopEdge = sid_uly + halfPixel;
            double rwSidFileBotEdge = rwSidFileTopEdge - (double)sidPixelHeight * sid_xres;
            this.totalBounds.expandToInclude(rwSidFileLeftEdge, rwSidFileBotEdge);
            this.totalBounds.expandToInclude(rwSidFileRightEdge, rwSidFileTopEdge);
            double rwRasterLeft = Math.max(rwViewLeft, rwSidFileLeftEdge);
            double rwRasterRight = Math.min(rwViewRight, rwSidFileRightEdge);
            double rwRasterTop = Math.min(rwViewTop, rwSidFileTopEdge);
            double rwRasterBot = Math.max(rwViewBot, rwSidFileBotEdge);
            double rwViewWidth = rwViewRight - rwViewLeft;
            double widthInFilePixels = rwViewWidth / sid_xres;
            double widthInViewPixels = rwViewWidth / view_res;
            int sidLevel = (int)Math.round(Math.log(widthInFilePixels / widthInViewPixels) / Math.log(2.0));
            if (sidLevel < 0) {
                sidLevel = 0;
            }
            if (sidLevel > this.maxLevel) {
                sidLevel = this.maxLevel;
            }
            double lvlres = sid_xres * Math.pow(2.0, sidLevel);
            panel.getContext().setStatusMessage("MrSID " + sLevel + " " + sidLevel + " " + sOf + " " + this.maxLevel);
            int sidLvlPixelWidth = sidPixelWidth;
            int sidLvlPixelHeight = sidPixelHeight;
            for (int lvl = 0; lvl < sidLevel; ++lvl) {
                sidLvlPixelWidth = this.round(0.5 * (double)sidLvlPixelWidth);
                sidLvlPixelHeight = this.round(0.5 * (double)sidLvlPixelHeight);
            }
            halfPixel = 0.5 * lvlres;
            rwSidFileLeftEdge = sid_ulx - halfPixel;
            rwSidFileRightEdge = rwSidFileLeftEdge + (double)sidLvlPixelWidth * lvlres;
            rwSidFileTopEdge = sid_uly + halfPixel;
            rwSidFileBotEdge = rwSidFileTopEdge - (double)sidLvlPixelHeight * lvlres;
            if (rwSidFileRightEdge <= rwViewLeft || rwSidFileLeftEdge >= rwViewRight || rwSidFileTopEdge <= rwViewBot || rwSidFileBotEdge >= rwViewTop) continue;
            int sidLeftPixel = (int)((rwRasterLeft - rwSidFileLeftEdge) / lvlres);
            int sidRightPixel = (int)((rwRasterRight - rwSidFileLeftEdge) / lvlres);
            if (sidRightPixel == sidLvlPixelWidth) {
                sidRightPixel = sidLvlPixelWidth - 1;
            }
            int sidTopPixel = (int)((rwSidFileTopEdge - rwRasterTop) / lvlres);
            int sidBotPixel = (int)((rwSidFileTopEdge - rwRasterBot) / lvlres);
            if (sidBotPixel == sidLvlPixelHeight) {
                sidBotPixel = sidLvlPixelHeight - 1;
            }
            double rwSidLeft = rwSidFileLeftEdge + (double)sidLeftPixel * lvlres;
            double rwSidRight = rwSidFileLeftEdge + (double)sidRightPixel * lvlres + lvlres;
            double rwSidTop = rwSidFileTopEdge - (double)sidTopPixel * lvlres;
            double rwSidBot = rwSidFileTopEdge - (double)sidBotPixel * lvlres - lvlres;
            int leftOffset = this.round((rwRasterLeft - rwSidLeft) / view_res);
            int rightOffset = this.round((rwSidRight - rwRasterRight) / view_res);
            int topOffset = this.round((rwSidTop - rwRasterTop) / view_res);
            int botOffset = this.round((rwRasterBot - rwSidBot) / view_res);
            int sid_x = sidLeftPixel;
            int sid_y = sidTopPixel;
            int sid_w = sidRightPixel - sidLeftPixel + 1;
            if (sid_w <= 0) {
                sid_w = 1;
            }
            if ((sid_h = sidBotPixel - sidTopPixel + 1) <= 0) {
                sid_h = 1;
            }
            image_x = this.round(rwRasterLeft / view_res) - this.round(rwViewLeft / view_res);
            image_w = this.round(rwRasterRight / view_res) - this.round(rwRasterLeft / view_res);
            if (image_w <= 0) {
                image_w = 1;
            }
            image_y = this.round(rwViewTop / view_res) - this.round(rwRasterTop / view_res);
            image_h = this.round(rwRasterTop / view_res) - this.round(rwRasterBot / view_res);
            if (image_h <= 0) {
                image_h = 1;
            }
            image_x -= leftOffset;
            image_y -= topOffset;
            image_w += leftOffset + rightOffset;
            image_h += topOffset + botOffset;
            File jpgDir = new File(AddSIDLayerPlugIn.TMP_PATH);
            File jpgFile = File.createTempFile("Temp", ".jpg", jpgDir);
            String jpgFilename = jpgFile.getCanonicalPath();
            try {
                String[] runStr = new String[]{AddSIDLayerPlugIn.MRSIDDECODE, "-i", sidFilename, "-s", "" + sidLevel, "-ulxy", "" + sid_x, "" + sid_y, "-wh", "" + sid_w, "" + sid_h, "-o", jpgFilename, "-jpg", "-quiet", "-coord", "image"};
                Process p = Runtime.getRuntime().exec(runStr);
                p.waitFor();
                p.destroy();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (!jpgFile.exists() || !jpgFile.isFile() || !jpgFile.canRead()) continue;
            FileImageInputStream in = new FileImageInputStream(new File(jpgFilename));
            ImageReader decoder = ImageIO.getImageReadersByFormatName("JPEG").next();
            decoder.setInput(in);
            BufferedImage image = decoder.read(0);
            decoder.dispose();
            in.close();
            if (!this.sid_colorspace.equals("GREYSCALE")) {
                RenderingHints rh = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.setRenderingHints(rh);
            }
            g.setComposite(AlphaComposite.Src);
            g.drawImage(image, image_x, image_y, image_w, image_h, (ImageObserver)panel);
            new File(jpgFilename).delete();
        }
        return newImage;
    }

    protected SID_Info readWorldFile(String filename) throws IOException, FileNotFoundException {
        String wfname = filename.indexOf(46) < 0 ? filename : filename.substring(0, filename.indexOf(46));
        File file = new File(wfname = wfname + ".sdw");
        if (!file.exists()) {
            return null;
        }
        if (!file.isFile() || !file.canRead()) {
            return null;
        }
        FileReader wf = new FileReader(wfname);
        BufferedReader in = new BufferedReader(wf);
        double sid_xres = Double.parseDouble(in.readLine());
        double sid_xrot = Double.parseDouble(in.readLine());
        double sid_yrot = Double.parseDouble(in.readLine());
        double sid_yres = Double.parseDouble(in.readLine());
        double sid_ulx = Double.parseDouble(in.readLine());
        double sid_uly = Double.parseDouble(in.readLine());
        SID_Info sidInfo = new SID_Info(filename, 0, 0, sid_xres, sid_xrot, sid_yrot, sid_yres, sid_ulx, sid_uly);
        in.close();
        wf.close();
        return sidInfo;
    }

    protected SID_Info readInfo(String sidFilename) {
        int sidPixelWidth = 0;
        int sidPixelHeight = 0;
        double sid_xres = 1.0;
        double sid_xrot = 0.0;
        double sid_yrot = 0.0;
        double sid_yres = 1.0;
        double sid_ulx = 0.0;
        double sid_uly = 0.0;
        this.maxLevel = 0;
        String infoFilename = AddSIDLayerPlugIn.TMP_PATH + "MrSIDinfo.txt";
        int numInfoItems = 0;
        try {
            String[] runStr = new String[]{AddSIDLayerPlugIn.MRSIDINFO, sidFilename, "-sid", "-quiet", "-log", infoFilename};
            Process p = Runtime.getRuntime().exec(runStr);
            p.waitFor();
            p.destroy();
            File file = new File(infoFilename);
            if (!(file.exists() && file.isFile() && file.canRead())) {
                return null;
            }
            FileReader fin = new FileReader(infoFilename);
            BufferedReader in = new BufferedReader(fin);
            String lineIn = in.readLine();
            while (in.ready()) {
                String value = "";
                if (lineIn.indexOf("width:") != -1) {
                    value = lineIn.substring(lineIn.indexOf(":") + 1);
                    sidPixelWidth = Integer.parseInt(value.trim());
                    ++numInfoItems;
                }
                if (lineIn.indexOf("height:") != -1) {
                    value = lineIn.substring(lineIn.indexOf(":") + 1);
                    sidPixelHeight = Integer.parseInt(value.trim());
                    ++numInfoItems;
                }
                if (lineIn.indexOf("number of levels:") != -1) {
                    value = lineIn.substring(lineIn.indexOf(":") + 1);
                    this.maxLevel = Integer.parseInt(value.trim());
                    ++numInfoItems;
                }
                if (lineIn.indexOf("X UL:") != -1) {
                    value = lineIn.substring(lineIn.indexOf(":") + 1);
                    sid_ulx = Double.parseDouble(value.trim());
                    ++numInfoItems;
                }
                if (lineIn.indexOf("Y UL:") != -1) {
                    value = lineIn.substring(lineIn.indexOf(":") + 1);
                    sid_uly = Double.parseDouble(value.trim());
                    ++numInfoItems;
                }
                if (lineIn.indexOf("X res:") != -1) {
                    value = lineIn.substring(lineIn.indexOf(":") + 1);
                    sid_xres = Double.parseDouble(value.trim());
                    ++numInfoItems;
                }
                if (lineIn.indexOf("Y res:") != -1) {
                    value = lineIn.substring(lineIn.indexOf(":") + 1);
                    sid_yres = Double.parseDouble(value.trim());
                    ++numInfoItems;
                }
                if (lineIn.indexOf("color space:") != -1) {
                    value = lineIn.substring(lineIn.indexOf(":") + 1);
                    this.sid_colorspace = value.trim();
                    ++numInfoItems;
                }
                lineIn = in.readLine();
            }
            in.close();
            fin.close();
            if (numInfoItems == 8) {
                return new SID_Info(sidFilename, sidPixelWidth, sidPixelHeight, sid_xres, sid_xrot, sid_yrot, sid_yres, sid_ulx, sid_uly);
            }
            return null;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public void addImageFilename(String imageFilename) {
        this.sidInfoList.addInfo(imageFilename);
    }

    public List getImageFilenames() {
        return this.sidInfoList.getFileNames();
    }

    private class SID_Info_List {
        private Vector infoList = new Vector(50, 10);

        SID_Info_List() {
        }

        SID_Info_List(List fileNames) {
            for (String fileName : fileNames) {
                SID_Info sidInfo = SIDLayer.this.readInfo(fileName);
                if (sidInfo == null) {
                    SIDLayer.this.callingContext.getWorkbenchFrame().getOutputFrame().addText("Could not get SID info for " + fileName);
                    continue;
                }
                this.infoList.add(sidInfo);
            }
        }

        public void addInfo(String fileName) {
            SID_Info sidInfo = SIDLayer.this.readInfo(fileName);
            if (sidInfo != null) {
                this.infoList.add(sidInfo);
            }
        }

        public SID_Info getInfo(String filename) {
            for (SID_Info sidInfo : this.infoList) {
                if (!sidInfo.getFileName().equals(filename)) continue;
                return sidInfo;
            }
            return null;
        }

        public List getFileNames() {
            ArrayList<String> imageFilenames = new ArrayList<String>();
            Iterator i = this.infoList.iterator();
            while (i.hasNext()) {
                imageFilenames.add(((SID_Info)i.next()).getFileName());
            }
            return Collections.unmodifiableList(imageFilenames);
        }
    }

    private class SID_Info {
        private String fileName;
        private int pixelWidth;
        private int pixelHeight;
        private double xres;
        private double xrot;
        private double yrot;
        private double yres;
        private double ulx;
        private double uly;

        SID_Info(String fileName, int pixelWidth, int pixelHeight, double xres, double xrot, double yrot, double yres, double ulx, double uly) {
            this.fileName = fileName;
            this.pixelWidth = pixelWidth;
            this.pixelHeight = pixelHeight;
            this.xres = xres;
            this.xrot = xrot;
            this.yrot = yrot;
            this.yres = yres;
            this.ulx = ulx;
            this.uly = uly;
        }

        String getFileName() {
            return this.fileName;
        }

        int getPixelWidth() {
            return this.pixelWidth;
        }

        int getPixelHeight() {
            return this.pixelHeight;
        }

        double getXRes() {
            return this.xres;
        }

        double getXRot() {
            return this.xrot;
        }

        double getYRot() {
            return this.yrot;
        }

        double getYRes() {
            return this.yres;
        }

        double getULX() {
            return this.ulx;
        }

        double getULY() {
            return this.uly;
        }
    }
}

