/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.sigle.plugin.joinTable;

import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import org.openjump.sigle.plugin.joinTable.JoinTableDataSource;

public class JoinTableDataSourceCSV
implements JoinTableDataSource {
    private ArrayList fieldNames = null;
    private ArrayList fieldTypes = null;
    private String filePath = null;
    private int fieldCount = 0;
    private String DEFAULT_DELEM = "\t";
    private String DELIMITATEURS = ";|\t";

    public JoinTableDataSourceCSV(String filePath) {
        this.filePath = filePath;
        this.fieldNames = new ArrayList();
        this.readHeader();
    }

    public ArrayList getFieldNames() {
        return this.fieldNames;
    }

    public ArrayList getFieldTypes() {
        return this.fieldTypes;
    }

    public Hashtable buildTable(int keyIndex) {
        Hashtable<String, String[]> table = new Hashtable<String, String[]>();
        int nl = 1;
        this.fieldTypes = new ArrayList();
        try {
            FileReader fileReader = new FileReader(this.filePath);
            FileInputStream fis = new FileInputStream(this.filePath);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fis));
            try {
                String line = bufferedReader.readLine();
                ++nl;
                line = bufferedReader.readLine();
                ++nl;
                if (line == null) {
                    throw new Exception(I18N.get("org.openjump.sigle.plugin.joinTable.Empty_file"));
                }
                nl = 1;
                while (line != null) {
                    int i;
                    line = " " + this.DEFAULT_DELEM + line + this.DEFAULT_DELEM + " ";
                    String[] aux = line.split(this.DELIMITATEURS);
                    String[] valeurs = new String[aux.length - 2];
                    int nbCol = valeurs.length;
                    if (nbCol != this.fieldCount) {
                        throw new Exception(I18N.get("org.openjump.sigle.plugin.joinTable.Field_problem_at_line") + nl);
                    }
                    for (i = 0; i < valeurs.length; ++i) {
                        valeurs[i] = aux[i + 1];
                    }
                    for (i = 0; i < nbCol; ++i) {
                        AttributeType fieldType;
                        String s = valeurs[i];
                        if (i + 1 > this.fieldTypes.size()) {
                            this.fieldTypes.add(i, this.typeOfString(s));
                            continue;
                        }
                        AttributeType newFieldType = this.typeOfString(s);
                        if (newFieldType == (fieldType = (AttributeType)this.fieldTypes.get(i))) continue;
                        if (newFieldType == AttributeType.STRING) {
                            this.fieldTypes.set(i, newFieldType);
                            continue;
                        }
                        if (fieldType == AttributeType.STRING || newFieldType != AttributeType.DOUBLE) continue;
                        this.fieldTypes.set(i, newFieldType);
                    }
                    line = bufferedReader.readLine();
                    ++nl;
                    table.put(valeurs[keyIndex], valeurs);
                }
            }
            catch (Exception e) {
                String msg = I18N.get("org.openjump.sigle.plugin.joinTable.Error_while_reading_file") + this.filePath + " (" + e.getMessage() + ").";
                throw new ParseException(msg);
            }
            finally {
                bufferedReader.close();
                fileReader.close();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
        return table;
    }

    private void readHeader() {
        try {
            FileReader fileReader = new FileReader(this.filePath);
            FileInputStream fis = new FileInputStream(this.filePath);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fis));
            try {
                String firstLine = bufferedReader.readLine();
                if (firstLine == null) {
                    throw new Exception(I18N.get("org.openjump.sigle.plugin.joinTable.Empty_file"));
                }
                String[] champs = firstLine.split(this.DELIMITATEURS);
                for (int k = 0; k < champs.length; ++k) {
                    String s = champs[k];
                    boolean nomUnique = false;
                    String suffixe = "";
                    int j = 0;
                    int i = 1;
                    while (!nomUnique) {
                        nomUnique = true;
                        for (j = 0; j < this.fieldNames.size(); ++j) {
                            String saux = (String)this.fieldNames.get(j);
                            nomUnique = nomUnique && !(s + suffixe).equalsIgnoreCase(saux);
                        }
                        if (nomUnique) continue;
                        suffixe = String.valueOf(i);
                        ++i;
                    }
                    this.fieldNames.add(s + suffixe);
                }
                this.fieldCount = this.fieldNames.size();
            }
            catch (Exception e) {
                String msg = I18N.get("org.openjump.sigle.plugin.joinTable.Error_while_reading_fields_in_file") + this.filePath + "(" + e.getMessage() + ").";
                throw new ParseException(msg);
            }
            finally {
                bufferedReader.close();
                fileReader.close();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private AttributeType typeOfString(String s) {
        AttributeType res = AttributeType.STRING;
        if (s.length() == 0) {
            res = AttributeType.INTEGER;
        } else {
            char firstChar = s.charAt(0);
            char lastChar = s.charAt(s.length() - 1);
            res = firstChar == '0' && s.length() == 1 || firstChar > '0' && firstChar <= '9' || firstChar == '-' || firstChar == '.' || firstChar == ',' ? (s.indexOf(46) == -1 && s.indexOf(44) == -1 ? (s.length() < 10 ? AttributeType.INTEGER : AttributeType.DOUBLE) : AttributeType.DOUBLE) : AttributeType.STRING;
        }
        return res;
    }
}

