/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.util;

import java.util.LinkedList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathUtils {
    private static final XPath XPATH = XPathFactory.newInstance().newXPath();
    private static final Logger LOG = Logger.getLogger(XPathUtils.class);

    public static int getInt(String xpath, Element e, NamespaceContext nscontext) throws XPathExpressionException {
        double res = XPathUtils.getDouble(xpath, e, nscontext);
        return (int)res;
    }

    public static double getDouble(String xpath, Element e, NamespaceContext nscontext) throws XPathExpressionException {
        XPATH.setNamespaceContext(nscontext);
        Object res = XPATH.evaluate(xpath, e, XPathConstants.NUMBER);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("XPath expression " + xpath + " yielded " + res));
        }
        if (res instanceof Double) {
            return (Double)res;
        }
        return ((Integer)res).intValue();
    }

    public static LinkedList<Node> getNodes(String xpath, Element e, NamespaceContext nscontext) throws XPathExpressionException {
        XPATH.setNamespaceContext(nscontext);
        NodeList nl = (NodeList)XPATH.evaluate(xpath, e, XPathConstants.NODESET);
        LOG.debug((Object)("XPath expression " + xpath + " yielded " + nl.getLength() + " nodes."));
        LinkedList<Node> list = new LinkedList<Node>();
        for (int i = 0; i < nl.getLength(); ++i) {
            list.add(nl.item(i));
        }
        return list;
    }

    public static LinkedList<Element> getElements(String xpath, Element e, NamespaceContext nscontext) throws XPathExpressionException {
        LinkedList<Node> nodes = XPathUtils.getNodes(xpath, e, nscontext);
        LinkedList<Element> list = new LinkedList<Element>();
        for (Node n : nodes) {
            list.add((Element)n);
        }
        return list;
    }

    public static Node getNode(String xpath, Element e, NamespaceContext nscontext) throws XPathExpressionException {
        XPATH.setNamespaceContext(nscontext);
        Node n = (Node)XPATH.evaluate(xpath, e, XPathConstants.NODE);
        LOG.debug((Object)("XPath expression " + xpath + " yielded " + (n == null ? "nothing." : "a node.")));
        return n;
    }

    public static Element getElement(String xpath, Element e, NamespaceContext nscontext) throws XPathExpressionException {
        return (Element)XPathUtils.getNode(xpath, e, nscontext);
    }
}

