/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.css.engine.CSSEngineListener;
import org.apache.batik.css.engine.CSSEngineUserAgent;
import org.apache.batik.css.engine.CSSNavigableDocument;
import org.apache.batik.css.engine.CSSNavigableDocumentListener;
import org.apache.batik.css.engine.CSSNavigableNode;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.CSSStyleSheetNode;
import org.apache.batik.css.engine.FontFaceRule;
import org.apache.batik.css.engine.ImportRule;
import org.apache.batik.css.engine.MediaRule;
import org.apache.batik.css.engine.Messages;
import org.apache.batik.css.engine.Rule;
import org.apache.batik.css.engine.StringIntMap;
import org.apache.batik.css.engine.StyleDeclaration;
import org.apache.batik.css.engine.StyleDeclarationProvider;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.StyleRule;
import org.apache.batik.css.engine.StyleSheet;
import org.apache.batik.css.engine.sac.CSSConditionFactory;
import org.apache.batik.css.engine.sac.CSSSelectorFactory;
import org.apache.batik.css.engine.sac.ExtendedSelector;
import org.apache.batik.css.engine.value.ComputedValue;
import org.apache.batik.css.engine.value.InheritValue;
import org.apache.batik.css.engine.value.ShorthandManager;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.util.ParsedURL;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public abstract class CSSEngine {
    protected CSSEngineUserAgent userAgent;
    protected CSSContext cssContext;
    protected Document document;
    protected URL documentURI;
    protected boolean isCSSNavigableDocument;
    protected StringIntMap indexes;
    protected StringIntMap shorthandIndexes;
    protected ValueManager[] valueManagers;
    protected ShorthandManager[] shorthandManagers;
    protected ExtendedParser parser;
    protected String[] pseudoElementNames;
    protected int fontSizeIndex = -1;
    protected int lineHeightIndex = -1;
    protected int colorIndex = -1;
    protected StyleSheet userAgentStyleSheet;
    protected StyleSheet userStyleSheet;
    protected SACMediaList media;
    protected List styleSheetNodes;
    protected List fontFaces = new LinkedList();
    protected String styleNamespaceURI;
    protected String styleLocalName;
    protected String classNamespaceURI;
    protected String classLocalName;
    protected Set nonCSSPresentationalHints;
    protected String nonCSSPresentationalHintsNamespaceURI;
    protected StyleDeclarationDocumentHandler styleDeclarationDocumentHandler = new StyleDeclarationDocumentHandler();
    protected StyleDeclarationUpdateHandler styleDeclarationUpdateHandler;
    protected StyleSheetDocumentHandler styleSheetDocumentHandler = new StyleSheetDocumentHandler();
    protected StyleDeclarationBuilder styleDeclarationBuilder = new StyleDeclarationBuilder();
    protected CSSStylableElement element;
    protected URL cssBaseURI;
    protected String alternateStyleSheet;
    protected CSSNavigableDocumentHandler cssNavigableDocumentListener;
    protected EventListener domAttrModifiedListener;
    protected EventListener domNodeInsertedListener;
    protected EventListener domNodeRemovedListener;
    protected EventListener domSubtreeModifiedListener;
    protected EventListener domCharacterDataModifiedListener;
    protected boolean styleSheetRemoved;
    protected Node removedStylableElementSibling;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected Set selectorAttributes;
    protected final int[] ALL_PROPERTIES;
    protected CSSConditionFactory cssConditionFactory;
    protected static final CSSEngineListener[] LISTENER_ARRAY = new CSSEngineListener[0];

    public static Node getCSSParentNode(Node node) {
        if (node instanceof CSSNavigableNode) {
            return ((CSSNavigableNode)((Object)node)).getCSSParentNode();
        }
        return node.getParentNode();
    }

    protected static Node getCSSFirstChild(Node node) {
        if (node instanceof CSSNavigableNode) {
            return ((CSSNavigableNode)((Object)node)).getCSSFirstChild();
        }
        return node.getFirstChild();
    }

    protected static Node getCSSNextSibling(Node node) {
        if (node instanceof CSSNavigableNode) {
            return ((CSSNavigableNode)((Object)node)).getCSSNextSibling();
        }
        return node.getNextSibling();
    }

    protected static Node getCSSPreviousSibling(Node node) {
        if (node instanceof CSSNavigableNode) {
            return ((CSSNavigableNode)((Object)node)).getCSSPreviousSibling();
        }
        return node.getPreviousSibling();
    }

    public static CSSStylableElement getParentCSSStylableElement(Element element) {
        Node node = CSSEngine.getCSSParentNode(element);
        while (node != null) {
            if (node instanceof CSSStylableElement) {
                return (CSSStylableElement)node;
            }
            node = CSSEngine.getCSSParentNode(node);
        }
        return null;
    }

    protected CSSEngine(Document document, URL uRL, ExtendedParser extendedParser, ValueManager[] valueManagerArray, ShorthandManager[] shorthandManagerArray, String[] stringArray, String string, String string2, String string3, String string4, boolean bl, String string5, CSSContext cSSContext) {
        String string6;
        int n;
        this.document = document;
        this.documentURI = uRL;
        this.parser = extendedParser;
        this.pseudoElementNames = stringArray;
        this.styleNamespaceURI = string;
        this.styleLocalName = string2;
        this.classNamespaceURI = string3;
        this.classLocalName = string4;
        this.cssContext = cSSContext;
        this.isCSSNavigableDocument = document instanceof CSSNavigableDocument;
        this.cssConditionFactory = new CSSConditionFactory(string3, string4, null, "id");
        int n2 = valueManagerArray.length;
        this.indexes = new StringIntMap(n2);
        this.valueManagers = valueManagerArray;
        for (n = n2 - 1; n >= 0; --n) {
            string6 = valueManagerArray[n].getPropertyName();
            this.indexes.put(string6, n);
            if (this.fontSizeIndex == -1 && string6.equals("font-size")) {
                this.fontSizeIndex = n;
            }
            if (this.lineHeightIndex == -1 && string6.equals("line-height")) {
                this.lineHeightIndex = n;
            }
            if (this.colorIndex != -1 || !string6.equals("color")) continue;
            this.colorIndex = n;
        }
        n2 = shorthandManagerArray.length;
        this.shorthandIndexes = new StringIntMap(n2);
        this.shorthandManagers = shorthandManagerArray;
        for (n = n2 - 1; n >= 0; --n) {
            this.shorthandIndexes.put(shorthandManagerArray[n].getPropertyName(), n);
        }
        if (bl) {
            this.nonCSSPresentationalHints = new HashSet(valueManagerArray.length + shorthandManagerArray.length);
            this.nonCSSPresentationalHintsNamespaceURI = string5;
            n2 = valueManagerArray.length;
            for (n = 0; n < n2; ++n) {
                string6 = valueManagerArray[n].getPropertyName();
                this.nonCSSPresentationalHints.add(string6);
            }
            n2 = shorthandManagerArray.length;
            for (n = 0; n < n2; ++n) {
                string6 = shorthandManagerArray[n].getPropertyName();
                this.nonCSSPresentationalHints.add(string6);
            }
        }
        if (this.cssContext.isDynamic() && this.document instanceof EventTarget) {
            this.addEventListeners((EventTarget)((Object)this.document));
            this.styleDeclarationUpdateHandler = new StyleDeclarationUpdateHandler();
        }
        this.ALL_PROPERTIES = new int[this.getNumberOfProperties()];
        for (n = this.getNumberOfProperties() - 1; n >= 0; --n) {
            this.ALL_PROPERTIES[n] = n;
        }
    }

    protected void addEventListeners(EventTarget eventTarget) {
        if (this.isCSSNavigableDocument) {
            this.cssNavigableDocumentListener = new CSSNavigableDocumentHandler();
            CSSNavigableDocument cSSNavigableDocument = (CSSNavigableDocument)((Object)eventTarget);
            cSSNavigableDocument.addCSSNavigableDocumentListener(this.cssNavigableDocumentListener);
        } else {
            this.domAttrModifiedListener = new DOMAttrModifiedListener();
            eventTarget.addEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
            this.domNodeInsertedListener = new DOMNodeInsertedListener();
            eventTarget.addEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
            this.domNodeRemovedListener = new DOMNodeRemovedListener();
            eventTarget.addEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
            this.domSubtreeModifiedListener = new DOMSubtreeModifiedListener();
            eventTarget.addEventListener("DOMSubtreeModified", this.domSubtreeModifiedListener, false);
            this.domCharacterDataModifiedListener = new DOMCharacterDataModifiedListener();
            eventTarget.addEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, false);
        }
    }

    protected void removeEventListeners(EventTarget eventTarget) {
        if (this.isCSSNavigableDocument) {
            CSSNavigableDocument cSSNavigableDocument = (CSSNavigableDocument)((Object)eventTarget);
            cSSNavigableDocument.removeCSSNavigableDocumentListener(this.cssNavigableDocumentListener);
        } else {
            eventTarget.removeEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
            eventTarget.removeEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
            eventTarget.removeEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
            eventTarget.removeEventListener("DOMSubtreeModified", this.domSubtreeModifiedListener, false);
            eventTarget.removeEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, false);
        }
    }

    public void dispose() {
        this.setCSSEngineUserAgent(null);
        this.disposeStyleMaps(this.document.getDocumentElement());
        if (this.document instanceof EventTarget) {
            this.removeEventListeners((EventTarget)((Object)this.document));
        }
    }

    protected void disposeStyleMaps(Node node) {
        if (node instanceof CSSStylableElement) {
            ((CSSStylableElement)node).setComputedStyleMap(null, null);
        }
        Node node2 = CSSEngine.getCSSFirstChild(node);
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                this.disposeStyleMaps(node2);
            }
            node2 = CSSEngine.getCSSNextSibling(node2);
        }
    }

    public CSSContext getCSSContext() {
        return this.cssContext;
    }

    public Document getDocument() {
        return this.document;
    }

    public int getFontSizeIndex() {
        return this.fontSizeIndex;
    }

    public int getLineHeightIndex() {
        return this.lineHeightIndex;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public int getNumberOfProperties() {
        return this.valueManagers.length;
    }

    public int getPropertyIndex(String string) {
        return this.indexes.get(string);
    }

    public int getShorthandIndex(String string) {
        return this.shorthandIndexes.get(string);
    }

    public String getPropertyName(int n) {
        return this.valueManagers[n].getPropertyName();
    }

    public void setCSSEngineUserAgent(CSSEngineUserAgent cSSEngineUserAgent) {
        this.userAgent = cSSEngineUserAgent;
    }

    public CSSEngineUserAgent getCSSEngineUserAgent() {
        return this.userAgent;
    }

    public void setUserAgentStyleSheet(StyleSheet styleSheet) {
        this.userAgentStyleSheet = styleSheet;
    }

    public void setUserStyleSheet(StyleSheet styleSheet) {
        this.userStyleSheet = styleSheet;
    }

    public ValueManager[] getValueManagers() {
        return this.valueManagers;
    }

    public ShorthandManager[] getShorthandManagers() {
        return this.shorthandManagers;
    }

    public List getFontFaces() {
        return this.fontFaces;
    }

    public void setMedia(String string) {
        try {
            this.media = this.parser.parseMedia(string);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            String string3 = Messages.formatMessage("media.error", new Object[]{string, string2});
            throw new DOMException(12, string3);
        }
    }

    public void setAlternateStyleSheet(String string) {
        this.alternateStyleSheet = string;
    }

    public void importCascadedStyleMaps(Element element, CSSEngine cSSEngine, Element element2) {
        Node node;
        Node node2;
        if (element instanceof CSSStylableElement) {
            node2 = (CSSStylableElement)element;
            node = (CSSStylableElement)element2;
            StyleMap styleMap = cSSEngine.getCascadedStyleMap((CSSStylableElement)node2, null);
            styleMap.setFixedCascadedStyle(true);
            node.setComputedStyleMap(null, styleMap);
            if (this.pseudoElementNames != null) {
                for (String string : this.pseudoElementNames) {
                    styleMap = cSSEngine.getCascadedStyleMap((CSSStylableElement)node2, string);
                    node.setComputedStyleMap(string, styleMap);
                }
            }
        }
        node2 = CSSEngine.getCSSFirstChild(element2);
        node = CSSEngine.getCSSFirstChild(element);
        while (node2 != null) {
            if (node.getNodeType() == 1) {
                this.importCascadedStyleMaps((Element)node, cSSEngine, (Element)node2);
            }
            node2 = CSSEngine.getCSSNextSibling(node2);
            node = CSSEngine.getCSSNextSibling(node);
        }
    }

    public URL getCSSBaseURI() {
        if (this.cssBaseURI == null) {
            this.cssBaseURI = this.element.getCSSBase();
        }
        return this.cssBaseURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleMap getCascadedStyleMap(CSSStylableElement cSSStylableElement, String string) {
        Object object;
        int n = this.getNumberOfProperties();
        final StyleMap styleMap = new StyleMap(n);
        if (this.userAgentStyleSheet != null) {
            object = new ArrayList();
            this.addMatchingRules((List)object, this.userAgentStyleSheet, cSSStylableElement, string);
            this.addRules(cSSStylableElement, string, styleMap, (List)object, (short)0);
        }
        if (this.userStyleSheet != null) {
            object = new ArrayList();
            this.addMatchingRules((List)object, this.userStyleSheet, cSSStylableElement, string);
            this.addRules(cSSStylableElement, string, styleMap, (List)object, (short)8192);
        }
        this.element = cSSStylableElement;
        try {
            StyleDeclaration styleDeclaration;
            StyleDeclarationProvider styleDeclarationProvider;
            String string2;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            int n2;
            Object object6;
            if (this.nonCSSPresentationalHints != null) {
                object = new ShorthandManager.PropertyHandler(){

                    public void property(String string, LexicalUnit lexicalUnit, boolean bl) {
                        int n = CSSEngine.this.getPropertyIndex(string);
                        if (n != -1) {
                            ValueManager valueManager = CSSEngine.this.valueManagers[n];
                            Value value = valueManager.createValue(lexicalUnit, CSSEngine.this);
                            CSSEngine.this.putAuthorProperty(styleMap, n, value, bl, (short)16384);
                            return;
                        }
                        n = CSSEngine.this.getShorthandIndex(string);
                        if (n == -1) {
                            return;
                        }
                        CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
                    }
                };
                object6 = cSSStylableElement.getAttributes();
                n2 = object6.getLength();
                for (int i = 0; i < n2; ++i) {
                    Node node = object6.item(i);
                    object5 = node.getNodeName();
                    if (!this.nonCSSPresentationalHints.contains(object5)) continue;
                    object4 = node.getNodeValue();
                    try {
                        object3 = this.parser.parsePropertyValue(node.getNodeValue());
                        object.property((String)object5, (LexicalUnit)object3, false);
                        continue;
                    }
                    catch (Exception exception) {
                        System.err.println("\n***** CSSEngine: exception property.syntax.error:" + exception);
                        System.err.println("\nAttrValue:" + (String)object4);
                        System.err.println("\nException:" + exception.getClass().getName());
                        exception.printStackTrace(System.err);
                        System.err.println("\n***** CSSEngine: exception....");
                        object2 = exception.getMessage();
                        if (object2 == null) {
                            object2 = "";
                        }
                        String string3 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                        String string4 = Messages.formatMessage("property.syntax.error.at", new Object[]{string3, object5, node.getNodeValue(), object2});
                        DOMException dOMException = new DOMException(12, string4);
                        if (this.userAgent == null) {
                            throw dOMException;
                        }
                        this.userAgent.displayError(dOMException);
                    }
                }
            }
            if ((n2 = (object6 = ((CSSEngine)(object = this.cssContext.getCSSEngineForElement(cSSStylableElement))).getStyleSheetNodes()).size()) > 0) {
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < n2; ++i) {
                    object5 = (CSSStyleSheetNode)object6.get(i);
                    object4 = object5.getCSSStyleSheet();
                    if (object4 == null || ((StyleSheet)object4).isAlternate() && ((StyleSheet)object4).getTitle() != null && !((StyleSheet)object4).getTitle().equals(this.alternateStyleSheet) || !this.mediaMatch(((StyleSheet)object4).getMedia())) continue;
                    this.addMatchingRules(arrayList, (StyleSheet)object4, cSSStylableElement, string);
                }
                this.addRules(cSSStylableElement, string, styleMap, arrayList, (short)24576);
            }
            if (this.styleLocalName != null && (string2 = cSSStylableElement.getAttributeNS(this.styleNamespaceURI, this.styleLocalName)).length() > 0) {
                try {
                    this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
                    this.parser.setConditionFactory(this.cssConditionFactory);
                    this.styleDeclarationDocumentHandler.styleMap = styleMap;
                    this.parser.setDocumentHandler(this.styleDeclarationDocumentHandler);
                    this.parser.parseStyleDeclaration(string2);
                    this.styleDeclarationDocumentHandler.styleMap = null;
                }
                catch (Exception exception) {
                    object5 = exception.getMessage();
                    if (object5 == null) {
                        object5 = "";
                    }
                    object4 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                    object3 = Messages.formatMessage("style.syntax.error.at", new Object[]{object4, this.styleLocalName, string2, object5});
                    object2 = new DOMException(12, (String)object3);
                    if (this.userAgent == null) {
                        throw object2;
                    }
                    this.userAgent.displayError((Exception)object2);
                }
            }
            if ((styleDeclarationProvider = cSSStylableElement.getOverrideStyleDeclarationProvider()) != null && (styleDeclaration = styleDeclarationProvider.getStyleDeclaration()) != null) {
                int n3 = styleDeclaration.size();
                for (int i = 0; i < n3; ++i) {
                    int n4 = styleDeclaration.getIndex(i);
                    object2 = styleDeclaration.getValue(i);
                    boolean bl = styleDeclaration.getPriority(i);
                    if (styleMap.isImportant(n4) && !bl) continue;
                    styleMap.putValue(n4, (Value)object2);
                    styleMap.putImportant(n4, bl);
                    styleMap.putOrigin(n4, (short)-24576);
                }
            }
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
        return styleMap;
    }

    public Value getComputedStyle(CSSStylableElement cSSStylableElement, String string, int n) {
        StyleMap styleMap = cSSStylableElement.getComputedStyleMap(string);
        if (styleMap == null) {
            styleMap = this.getCascadedStyleMap(cSSStylableElement, string);
            cSSStylableElement.setComputedStyleMap(string, styleMap);
        }
        Value value = styleMap.getValue(n);
        if (styleMap.isComputed(n)) {
            return value;
        }
        Value value2 = value;
        ValueManager valueManager = this.valueManagers[n];
        CSSStylableElement cSSStylableElement2 = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
        if (value == null) {
            if (cSSStylableElement2 == null || !valueManager.isInheritedProperty()) {
                value2 = valueManager.getDefaultValue();
            }
        } else if (cSSStylableElement2 != null && value == InheritValue.INSTANCE) {
            value2 = null;
        }
        if (value2 == null) {
            value2 = this.getComputedStyle(cSSStylableElement2, null, n);
            styleMap.putParentRelative(n, true);
            styleMap.putInherited(n, true);
        } else {
            value2 = valueManager.computeValue(cSSStylableElement, string, this, n, styleMap, value2);
        }
        if (value == null) {
            styleMap.putValue(n, value2);
            styleMap.putNullCascaded(n, true);
        } else if (value2 != value) {
            ComputedValue computedValue = new ComputedValue(value);
            computedValue.setComputedValue(value2);
            styleMap.putValue(n, computedValue);
            value2 = computedValue;
        }
        styleMap.putComputed(n, true);
        return value2;
    }

    public List getStyleSheetNodes() {
        if (this.styleSheetNodes == null) {
            this.styleSheetNodes = new ArrayList();
            this.selectorAttributes = new HashSet();
            this.findStyleSheetNodes(this.document);
            int n = this.styleSheetNodes.size();
            for (int i = 0; i < n; ++i) {
                CSSStyleSheetNode cSSStyleSheetNode = (CSSStyleSheetNode)this.styleSheetNodes.get(i);
                StyleSheet styleSheet = cSSStyleSheetNode.getCSSStyleSheet();
                if (styleSheet == null) continue;
                this.findSelectorAttributes(this.selectorAttributes, styleSheet);
            }
        }
        return this.styleSheetNodes;
    }

    protected void findStyleSheetNodes(Node node) {
        if (node instanceof CSSStyleSheetNode) {
            this.styleSheetNodes.add(node);
        }
        Node node2 = CSSEngine.getCSSFirstChild(node);
        while (node2 != null) {
            this.findStyleSheetNodes(node2);
            node2 = CSSEngine.getCSSNextSibling(node2);
        }
    }

    protected void findSelectorAttributes(Set set, StyleSheet styleSheet) {
        int n = styleSheet.getSize();
        block4: for (int i = 0; i < n; ++i) {
            Rule rule = styleSheet.getRule(i);
            switch (rule.getType()) {
                case 0: {
                    StyleRule styleRule = (StyleRule)rule;
                    SelectorList selectorList = styleRule.getSelectorList();
                    int n2 = selectorList.getLength();
                    for (int j = 0; j < n2; ++j) {
                        ExtendedSelector extendedSelector = (ExtendedSelector)selectorList.item(j);
                        extendedSelector.fillAttributeSet(set);
                    }
                    continue block4;
                }
                case 1: 
                case 2: {
                    MediaRule mediaRule = (MediaRule)rule;
                    if (!this.mediaMatch(mediaRule.getMediaList())) continue block4;
                    this.findSelectorAttributes(set, mediaRule);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainProperties(CSSStylableElement cSSStylableElement, final MainPropertyReceiver mainPropertyReceiver, String string, String string2, boolean bl) {
        try {
            this.element = cSSStylableElement;
            LexicalUnit lexicalUnit = this.parser.parsePropertyValue(string2);
            ShorthandManager.PropertyHandler propertyHandler = new ShorthandManager.PropertyHandler(){

                public void property(String string, LexicalUnit lexicalUnit, boolean bl) {
                    int n = CSSEngine.this.getPropertyIndex(string);
                    if (n != -1) {
                        ValueManager valueManager = CSSEngine.this.valueManagers[n];
                        Value value = valueManager.createValue(lexicalUnit, CSSEngine.this);
                        mainPropertyReceiver.setMainProperty(string, value, bl);
                        return;
                    }
                    n = CSSEngine.this.getShorthandIndex(string);
                    if (n == -1) {
                        return;
                    }
                    CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
                }
            };
            propertyHandler.property(string, lexicalUnit, bl);
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            if (string3 == null) {
                string3 = "";
            }
            String string4 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String string5 = Messages.formatMessage("property.syntax.error.at", new Object[]{string4, string, string2, string3});
            DOMException dOMException = new DOMException(12, string5);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value parsePropertyValue(CSSStylableElement cSSStylableElement, String string, String string2) {
        int n = this.getPropertyIndex(string);
        if (n == -1) {
            return null;
        }
        ValueManager valueManager = this.valueManagers[n];
        try {
            this.element = cSSStylableElement;
            LexicalUnit lexicalUnit = this.parser.parsePropertyValue(string2);
            Value value = valueManager.createValue(lexicalUnit, this);
            return value;
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            if (string3 == null) {
                string3 = "";
            }
            String string4 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String string5 = Messages.formatMessage("property.syntax.error.at", new Object[]{string4, string, string2, string3});
            DOMException dOMException = new DOMException(12, string5);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
        return valueManager.getDefaultValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleDeclaration parseStyleDeclaration(CSSStylableElement cSSStylableElement, String string) {
        this.styleDeclarationBuilder.styleDeclaration = new StyleDeclaration();
        try {
            this.element = cSSStylableElement;
            this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
            this.parser.setConditionFactory(this.cssConditionFactory);
            this.parser.setDocumentHandler(this.styleDeclarationBuilder);
            this.parser.parseStyleDeclaration(string);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            String string3 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String string4 = Messages.formatMessage("syntax.error.at", new Object[]{string3, string2});
            DOMException dOMException = new DOMException(12, string4);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
        return this.styleDeclarationBuilder.styleDeclaration;
    }

    public StyleSheet parseStyleSheet(URL uRL, String string) throws DOMException {
        StyleSheet styleSheet = new StyleSheet();
        try {
            styleSheet.setMedia(this.parser.parseMedia(string));
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            String string3 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String string4 = Messages.formatMessage("syntax.error.at", new Object[]{string3, string2});
            DOMException dOMException = new DOMException(12, string4);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
            return styleSheet;
        }
        this.parseStyleSheet(styleSheet, uRL);
        return styleSheet;
    }

    public StyleSheet parseStyleSheet(InputSource inputSource, URL uRL, String string) throws DOMException {
        StyleSheet styleSheet = new StyleSheet();
        try {
            styleSheet.setMedia(this.parser.parseMedia(string));
            this.parseStyleSheet(styleSheet, inputSource, uRL);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            String string3 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String string4 = Messages.formatMessage("syntax.error.at", new Object[]{string3, string2});
            DOMException dOMException = new DOMException(12, string4);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
        }
        return styleSheet;
    }

    public void parseStyleSheet(StyleSheet styleSheet, URL uRL) throws DOMException {
        if (uRL == null) {
            String string = Messages.formatMessage("syntax.error.at", new Object[]{"Null Document reference", ""});
            DOMException dOMException = new DOMException(12, string);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
            return;
        }
        try {
            ParsedURL parsedURL = null;
            if (this.documentURI != null) {
                parsedURL = new ParsedURL(this.documentURI);
            }
            ParsedURL parsedURL2 = new ParsedURL(uRL);
            this.cssContext.checkLoadExternalResource(parsedURL2, parsedURL);
            this.parseStyleSheet(styleSheet, new InputSource(uRL.toString()), uRL);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "";
            }
            String string2 = Messages.formatMessage("syntax.error.at", new Object[]{uRL.toString(), string});
            DOMException dOMException = new DOMException(12, string2);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
        }
    }

    public StyleSheet parseStyleSheet(String string, URL uRL, String string2) throws DOMException {
        StyleSheet styleSheet = new StyleSheet();
        try {
            styleSheet.setMedia(this.parser.parseMedia(string2));
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            if (string3 == null) {
                string3 = "";
            }
            String string4 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String string5 = Messages.formatMessage("syntax.error.at", new Object[]{string4, string3});
            DOMException dOMException = new DOMException(12, string5);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
            return styleSheet;
        }
        this.parseStyleSheet(styleSheet, string, uRL);
        return styleSheet;
    }

    public void parseStyleSheet(StyleSheet styleSheet, String string, URL uRL) throws DOMException {
        try {
            this.parseStyleSheet(styleSheet, new InputSource((Reader)new StringReader(string)), uRL);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            String string3 = Messages.formatMessage("stylesheet.syntax.error", new Object[]{uRL.toString(), string, string2});
            DOMException dOMException = new DOMException(12, string3);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseStyleSheet(StyleSheet styleSheet, InputSource inputSource, URL uRL) throws IOException {
        this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
        this.parser.setConditionFactory(this.cssConditionFactory);
        try {
            this.cssBaseURI = uRL;
            this.styleSheetDocumentHandler.styleSheet = styleSheet;
            this.parser.setDocumentHandler(this.styleSheetDocumentHandler);
            this.parser.parseStyleSheet(inputSource);
            int n = styleSheet.getSize();
            for (int i = 0; i < n; ++i) {
                Rule rule = styleSheet.getRule(i);
                if (rule.getType() != 2) {
                    break;
                }
                ImportRule importRule = (ImportRule)rule;
                this.parseStyleSheet(importRule, importRule.getURI());
            }
        }
        finally {
            this.cssBaseURI = null;
        }
    }

    protected void putAuthorProperty(StyleMap styleMap, int n, Value value, boolean bl, short s) {
        boolean bl2;
        Value value2 = styleMap.getValue(n);
        short s2 = styleMap.getOrigin(n);
        boolean bl3 = styleMap.isImportant(n);
        boolean bl4 = bl2 = value2 == null;
        if (!bl2) {
            switch (s2) {
                case 8192: {
                    bl2 = !bl3;
                    break;
                }
                case 24576: {
                    bl2 = !bl3 || bl;
                    break;
                }
                case -24576: {
                    bl2 = false;
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            styleMap.putValue(n, value);
            styleMap.putImportant(n, bl);
            styleMap.putOrigin(n, s);
        }
    }

    protected void addMatchingRules(List list, StyleSheet styleSheet, Element element, String string) {
        int n = styleSheet.getSize();
        block4: for (int i = 0; i < n; ++i) {
            Rule rule = styleSheet.getRule(i);
            switch (rule.getType()) {
                case 0: {
                    StyleRule styleRule = (StyleRule)rule;
                    SelectorList selectorList = styleRule.getSelectorList();
                    int n2 = selectorList.getLength();
                    for (int j = 0; j < n2; ++j) {
                        ExtendedSelector extendedSelector = (ExtendedSelector)selectorList.item(j);
                        if (!extendedSelector.match(element, string)) continue;
                        list.add(styleRule);
                    }
                    continue block4;
                }
                case 1: 
                case 2: {
                    MediaRule mediaRule = (MediaRule)rule;
                    if (!this.mediaMatch(mediaRule.getMediaList())) continue block4;
                    this.addMatchingRules(list, mediaRule, element, string);
                }
            }
        }
    }

    protected void addRules(Element element, String string, StyleMap styleMap, List list, short s) {
        this.sortRules(list, element, string);
        int n = list.size();
        if (s == 24576) {
            for (int i = 0; i < n; ++i) {
                StyleRule styleRule = (StyleRule)list.get(i);
                StyleDeclaration styleDeclaration = styleRule.getStyleDeclaration();
                int n2 = styleDeclaration.size();
                for (int j = 0; j < n2; ++j) {
                    this.putAuthorProperty(styleMap, styleDeclaration.getIndex(j), styleDeclaration.getValue(j), styleDeclaration.getPriority(j), s);
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                StyleRule styleRule = (StyleRule)list.get(i);
                StyleDeclaration styleDeclaration = styleRule.getStyleDeclaration();
                int n3 = styleDeclaration.size();
                for (int j = 0; j < n3; ++j) {
                    int n4 = styleDeclaration.getIndex(j);
                    styleMap.putValue(n4, styleDeclaration.getValue(j));
                    styleMap.putImportant(n4, styleDeclaration.getPriority(j));
                    styleMap.putOrigin(n4, s);
                }
            }
        }
    }

    protected void sortRules(List list, Element element, String string) {
        int n = list.size();
        for (int i = 0; i < n - 1; ++i) {
            int n2 = i;
            int n3 = Integer.MAX_VALUE;
            for (int j = i; j < n; ++j) {
                StyleRule styleRule = (StyleRule)list.get(j);
                SelectorList selectorList = styleRule.getSelectorList();
                int n4 = 0;
                int n5 = selectorList.getLength();
                for (int k = 0; k < n5; ++k) {
                    int n6;
                    ExtendedSelector extendedSelector = (ExtendedSelector)selectorList.item(k);
                    if (!extendedSelector.match(element, string) || (n6 = extendedSelector.getSpecificity()) <= n4) continue;
                    n4 = n6;
                }
                if (n4 >= n3) continue;
                n3 = n4;
                n2 = j;
            }
            if (i == n2) continue;
            Object e = list.get(i);
            list.set(i, list.get(n2));
            list.set(n2, e);
        }
    }

    protected boolean mediaMatch(SACMediaList sACMediaList) {
        if (this.media == null || sACMediaList == null || this.media.getLength() == 0 || sACMediaList.getLength() == 0) {
            return true;
        }
        for (int i = 0; i < sACMediaList.getLength(); ++i) {
            if (sACMediaList.item(i).equalsIgnoreCase("all")) {
                return true;
            }
            for (int j = 0; j < this.media.getLength(); ++j) {
                if (!this.media.item(j).equalsIgnoreCase("all") && !sACMediaList.item(i).equalsIgnoreCase(this.media.item(j))) continue;
                return true;
            }
        }
        return false;
    }

    public void addCSSEngineListener(CSSEngineListener cSSEngineListener) {
        this.listeners.add(cSSEngineListener);
    }

    public void removeCSSEngineListener(CSSEngineListener cSSEngineListener) {
        this.listeners.remove(cSSEngineListener);
    }

    protected void firePropertiesChangedEvent(Element element, int[] nArray) {
        CSSEngineListener[] cSSEngineListenerArray = this.listeners.toArray(LISTENER_ARRAY);
        int n = cSSEngineListenerArray.length;
        if (n > 0) {
            CSSEngineEvent cSSEngineEvent = new CSSEngineEvent(this, element, nArray);
            for (int i = 0; i < n; ++i) {
                cSSEngineListenerArray[i].propertiesChanged(cSSEngineEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void inlineStyleAttributeUpdated(CSSStylableElement cSSStylableElement, StyleMap styleMap, short s, String string, String string2) {
        int n;
        boolean[] blArray = this.styleDeclarationUpdateHandler.updatedProperties;
        for (n = this.getNumberOfProperties() - 1; n >= 0; --n) {
            blArray[n] = false;
        }
        switch (s) {
            case 1: 
            case 2: {
                if (string2.length() > 0) {
                    this.element = cSSStylableElement;
                    try {
                        this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
                        this.parser.setConditionFactory(this.cssConditionFactory);
                        this.styleDeclarationUpdateHandler.styleMap = styleMap;
                        this.parser.setDocumentHandler(this.styleDeclarationUpdateHandler);
                        this.parser.parseStyleDeclaration(string2);
                        this.styleDeclarationUpdateHandler.styleMap = null;
                    }
                    catch (Exception exception) {
                        String string3 = exception.getMessage();
                        if (string3 == null) {
                            string3 = "";
                        }
                        String string4 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                        String string5 = Messages.formatMessage("style.syntax.error.at", new Object[]{string4, this.styleLocalName, string2, string3});
                        DOMException dOMException = new DOMException(12, string5);
                        if (this.userAgent == null) {
                            throw dOMException;
                        }
                        this.userAgent.displayError(dOMException);
                    }
                    finally {
                        this.element = null;
                        this.cssBaseURI = null;
                    }
                }
            }
            case 3: {
                n = 0;
                if (string != null && string.length() > 0) {
                    for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                        short s2;
                        if (!styleMap.isComputed(i) || blArray[i] || (s2 = styleMap.getOrigin(i)) < Short.MIN_VALUE) continue;
                        n = 1;
                        blArray[i] = true;
                    }
                }
                if (n != 0) {
                    this.invalidateProperties(cSSStylableElement, null, blArray, true);
                    break;
                }
                int n2 = 0;
                boolean bl = this.fontSizeIndex == -1 ? false : blArray[this.fontSizeIndex];
                boolean bl2 = this.lineHeightIndex == -1 ? false : blArray[this.lineHeightIndex];
                boolean bl3 = this.colorIndex == -1 ? false : blArray[this.colorIndex];
                for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                    if (blArray[i]) {
                        ++n2;
                        continue;
                    }
                    if (!(bl && styleMap.isFontSizeRelative(i) || bl2 && styleMap.isLineHeightRelative(i)) && (!bl3 || !styleMap.isColorRelative(i))) continue;
                    blArray[i] = true;
                    CSSEngine.clearComputedValue(styleMap, i);
                    ++n2;
                }
                if (n2 <= 0) break;
                int[] nArray = new int[n2];
                n2 = 0;
                for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                    if (!blArray[i]) continue;
                    nArray[n2++] = i;
                }
                this.invalidateProperties(cSSStylableElement, nArray, null, true);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid attrChangeType");
            }
        }
    }

    private static void clearComputedValue(StyleMap styleMap, int n) {
        if (styleMap.isNullCascaded(n)) {
            styleMap.putValue(n, null);
        } else {
            Value value = styleMap.getValue(n);
            if (value instanceof ComputedValue) {
                ComputedValue computedValue = (ComputedValue)value;
                value = computedValue.getCascadedValue();
                styleMap.putValue(n, value);
            }
        }
        styleMap.putComputed(n, false);
    }

    protected void invalidateProperties(Node node, int[] nArray, boolean[] blArray, boolean bl) {
        int n;
        int n2;
        if (!(node instanceof CSSStylableElement)) {
            return;
        }
        CSSStylableElement cSSStylableElement = (CSSStylableElement)node;
        StyleMap styleMap = cSSStylableElement.getComputedStyleMap(null);
        if (styleMap == null) {
            return;
        }
        boolean[] blArray2 = new boolean[this.getNumberOfProperties()];
        if (blArray != null) {
            System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
        }
        if (nArray != null) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                blArray2[nArray[n2]] = true;
            }
        }
        n2 = 0;
        if (!bl) {
            for (int i = 0; i < blArray2.length; ++i) {
                if (!blArray2[i]) continue;
                ++n2;
            }
        } else {
            StyleMap styleMap2 = this.getCascadedStyleMap(cSSStylableElement, null);
            cSSStylableElement.setComputedStyleMap(null, styleMap2);
            for (n = 0; n < blArray2.length; ++n) {
                if (blArray2[n]) {
                    ++n2;
                    continue;
                }
                Value value = styleMap2.getValue(n);
                Value value2 = null;
                if (!styleMap.isNullCascaded(n) && (value2 = styleMap.getValue(n)) instanceof ComputedValue) {
                    value2 = ((ComputedValue)value2).getCascadedValue();
                }
                if (value == value2) continue;
                if (value != null && value2 != null) {
                    if (value.equals(value2)) continue;
                    String string = value2.getCssText();
                    String string2 = value.getCssText();
                    if (string2 == string || string2 != null && string2.equals(string)) continue;
                }
                ++n2;
                blArray2[n] = true;
            }
        }
        int[] nArray2 = null;
        if (n2 != 0) {
            nArray2 = new int[n2];
            n2 = 0;
            for (n = 0; n < blArray2.length; ++n) {
                if (!blArray2[n]) continue;
                nArray2[n2++] = n;
            }
        }
        this.propagateChanges(cSSStylableElement, nArray2, bl);
    }

    protected void propagateChanges(Node node, int[] nArray, boolean bl) {
        int n;
        int n2;
        Object[] objectArray;
        if (!(node instanceof CSSStylableElement)) {
            return;
        }
        CSSStylableElement cSSStylableElement = (CSSStylableElement)node;
        StyleMap styleMap = cSSStylableElement.getComputedStyleMap(null);
        if (styleMap != null) {
            int n3;
            objectArray = this.styleDeclarationUpdateHandler.updatedProperties;
            for (n2 = this.getNumberOfProperties() - 1; n2 >= 0; --n2) {
                objectArray[n2] = 0;
            }
            if (nArray != null) {
                for (n2 = nArray.length - 1; n2 >= 0; --n2) {
                    n = nArray[n2];
                    objectArray[n] = 1;
                }
            }
            n2 = this.fontSizeIndex == -1 ? 0 : objectArray[this.fontSizeIndex];
            n = this.lineHeightIndex == -1 ? 0 : objectArray[this.lineHeightIndex];
            int n4 = this.colorIndex == -1 ? 0 : objectArray[this.colorIndex];
            int n5 = 0;
            for (n3 = this.getNumberOfProperties() - 1; n3 >= 0; --n3) {
                if (objectArray[n3] != 0) {
                    ++n5;
                    continue;
                }
                if (!(n2 != 0 && styleMap.isFontSizeRelative(n3) || n != 0 && styleMap.isLineHeightRelative(n3)) && (n4 == 0 || !styleMap.isColorRelative(n3))) continue;
                objectArray[n3] = 1;
                CSSEngine.clearComputedValue(styleMap, n3);
                ++n5;
            }
            if (n5 == 0) {
                nArray = null;
            } else {
                nArray = new int[n5];
                n5 = 0;
                for (n3 = this.getNumberOfProperties() - 1; n3 >= 0; --n3) {
                    if (objectArray[n3] == 0) continue;
                    nArray[n5++] = n3;
                }
                this.firePropertiesChangedEvent(cSSStylableElement, nArray);
            }
        }
        objectArray = nArray;
        if (nArray != null) {
            n2 = 0;
            for (n = 0; n < nArray.length; ++n) {
                ValueManager valueManager = this.valueManagers[nArray[n]];
                if (valueManager.isInheritedProperty()) {
                    ++n2;
                    continue;
                }
                nArray[n] = -1;
            }
            if (n2 == 0) {
                objectArray = null;
            } else {
                objectArray = new int[n2];
                n2 = 0;
                for (n = 0; n < nArray.length; ++n) {
                    if (nArray[n] == -1) continue;
                    objectArray[n2++] = nArray[n];
                }
            }
        }
        Node node2 = CSSEngine.getCSSFirstChild(node);
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                this.invalidateProperties(node2, (int[])objectArray, null, bl);
            }
            node2 = CSSEngine.getCSSNextSibling(node2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nonCSSPresentationalHintUpdated(CSSStylableElement cSSStylableElement, StyleMap styleMap, String string, short s, String string2) {
        int n;
        Object object;
        int n2 = this.getPropertyIndex(string);
        if (styleMap.isImportant(n2)) {
            return;
        }
        if (styleMap.getOrigin(n2) >= 24576) {
            return;
        }
        switch (s) {
            case 1: 
            case 2: {
                Object object2;
                Object object3;
                this.element = cSSStylableElement;
                try {
                    object = this.parser.parsePropertyValue(string2);
                    object3 = this.valueManagers[n2];
                    object2 = object3.createValue((LexicalUnit)object, this);
                    styleMap.putMask(n2, (short)0);
                    styleMap.putValue(n2, (Value)object2);
                    styleMap.putOrigin(n2, (short)16384);
                    break;
                }
                catch (Exception exception) {
                    object3 = exception.getMessage();
                    if (object3 == null) {
                        object3 = "";
                    }
                    object2 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                    String string3 = Messages.formatMessage("property.syntax.error.at", new Object[]{object2, string, string2, object3});
                    DOMException dOMException = new DOMException(12, string3);
                    if (this.userAgent == null) {
                        throw dOMException;
                    }
                    this.userAgent.displayError(dOMException);
                    break;
                }
                finally {
                    this.element = null;
                    this.cssBaseURI = null;
                }
            }
            case 3: {
                int[] nArray = new int[]{n2};
                this.invalidateProperties(cSSStylableElement, nArray, null, true);
                return;
            }
        }
        object = this.styleDeclarationUpdateHandler.updatedProperties;
        for (n = this.getNumberOfProperties() - 1; n >= 0; --n) {
            object[n] = false;
        }
        object[n2] = true;
        n = n2 == this.fontSizeIndex ? 1 : 0;
        boolean bl = n2 == this.lineHeightIndex;
        boolean bl2 = n2 == this.colorIndex;
        int n3 = 0;
        for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            if (object[i]) {
                ++n3;
                continue;
            }
            if (!(n != 0 && styleMap.isFontSizeRelative(i) || bl && styleMap.isLineHeightRelative(i)) && (!bl2 || !styleMap.isColorRelative(i))) continue;
            object[i] = true;
            CSSEngine.clearComputedValue(styleMap, i);
            ++n3;
        }
        int[] nArray = new int[n3];
        n3 = 0;
        for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            if (!object[i]) continue;
            nArray[n3++] = i;
        }
        this.invalidateProperties(cSSStylableElement, nArray, null, true);
    }

    protected boolean hasStyleSheetNode(Node node) {
        if (node instanceof CSSStyleSheetNode) {
            return true;
        }
        node = CSSEngine.getCSSFirstChild(node);
        while (node != null) {
            if (this.hasStyleSheetNode(node)) {
                return true;
            }
            node = CSSEngine.getCSSNextSibling(node);
        }
        return false;
    }

    protected void handleAttrModified(Element element, Attr attr, short s, String string, String string2) {
        if (!(element instanceof CSSStylableElement)) {
            return;
        }
        if (string2.equals(string)) {
            return;
        }
        String string3 = attr.getNamespaceURI();
        String string4 = string3 == null ? attr.getNodeName() : attr.getLocalName();
        CSSStylableElement cSSStylableElement = (CSSStylableElement)element;
        StyleMap styleMap = cSSStylableElement.getComputedStyleMap(null);
        if (styleMap != null) {
            if ((string3 == this.styleNamespaceURI || string3 != null && string3.equals(this.styleNamespaceURI)) && string4.equals(this.styleLocalName)) {
                this.inlineStyleAttributeUpdated(cSSStylableElement, styleMap, s, string, string2);
                return;
            }
            if (this.nonCSSPresentationalHints != null && (string3 == this.nonCSSPresentationalHintsNamespaceURI || string3 != null && string3.equals(this.nonCSSPresentationalHintsNamespaceURI)) && this.nonCSSPresentationalHints.contains(string4)) {
                this.nonCSSPresentationalHintUpdated(cSSStylableElement, styleMap, string4, s, string2);
                return;
            }
        }
        if (this.selectorAttributes != null && this.selectorAttributes.contains(string4)) {
            this.invalidateProperties(cSSStylableElement, null, null, true);
            Node node = CSSEngine.getCSSNextSibling(cSSStylableElement);
            while (node != null) {
                this.invalidateProperties(node, null, null, true);
                node = CSSEngine.getCSSNextSibling(node);
            }
        }
    }

    protected void handleNodeInserted(Node node) {
        if (this.hasStyleSheetNode(node)) {
            this.styleSheetNodes = null;
            this.invalidateProperties(this.document.getDocumentElement(), null, null, true);
        } else if (node instanceof CSSStylableElement) {
            node = CSSEngine.getCSSNextSibling(node);
            while (node != null) {
                this.invalidateProperties(node, null, null, true);
                node = CSSEngine.getCSSNextSibling(node);
            }
        }
    }

    protected void handleNodeRemoved(Node node) {
        if (this.hasStyleSheetNode(node)) {
            this.styleSheetRemoved = true;
        } else if (node instanceof CSSStylableElement) {
            this.removedStylableElementSibling = CSSEngine.getCSSNextSibling(node);
        }
        this.disposeStyleMaps(node);
    }

    protected void handleSubtreeModified(Node node) {
        if (this.styleSheetRemoved) {
            this.styleSheetRemoved = false;
            this.styleSheetNodes = null;
            this.invalidateProperties(this.document.getDocumentElement(), null, null, true);
        } else if (this.removedStylableElementSibling != null) {
            Node node2 = this.removedStylableElementSibling;
            while (node2 != null) {
                this.invalidateProperties(node2, null, null, true);
                node2 = CSSEngine.getCSSNextSibling(node2);
            }
            this.removedStylableElementSibling = null;
        }
    }

    protected void handleCharacterDataModified(Node node) {
        if (CSSEngine.getCSSParentNode(node) instanceof CSSStyleSheetNode) {
            this.styleSheetNodes = null;
            this.invalidateProperties(this.document.getDocumentElement(), null, null, true);
        }
    }

    protected class DOMAttrModifiedListener
    implements EventListener {
        protected DOMAttrModifiedListener() {
        }

        public void handleEvent(Event event) {
            MutationEvent mutationEvent = (MutationEvent)event;
            CSSEngine.this.handleAttrModified((Element)((Object)event.getTarget()), (Attr)mutationEvent.getRelatedNode(), mutationEvent.getAttrChange(), mutationEvent.getPrevValue(), mutationEvent.getNewValue());
        }
    }

    protected class DOMCharacterDataModifiedListener
    implements EventListener {
        protected DOMCharacterDataModifiedListener() {
        }

        public void handleEvent(Event event) {
            CSSEngine.this.handleCharacterDataModified((Node)((Object)event.getTarget()));
        }
    }

    protected class DOMSubtreeModifiedListener
    implements EventListener {
        protected DOMSubtreeModifiedListener() {
        }

        public void handleEvent(Event event) {
            CSSEngine.this.handleSubtreeModified((Node)((Object)event.getTarget()));
        }
    }

    protected class DOMNodeRemovedListener
    implements EventListener {
        protected DOMNodeRemovedListener() {
        }

        public void handleEvent(Event event) {
            CSSEngine.this.handleNodeRemoved((Node)((Object)event.getTarget()));
        }
    }

    protected class DOMNodeInsertedListener
    implements EventListener {
        protected DOMNodeInsertedListener() {
        }

        public void handleEvent(Event event) {
            CSSEngine.this.handleNodeInserted((Node)((Object)event.getTarget()));
        }
    }

    protected class CSSNavigableDocumentHandler
    implements CSSNavigableDocumentListener,
    MainPropertyReceiver {
        protected boolean[] mainPropertiesChanged;
        protected StyleDeclaration declaration;

        protected CSSNavigableDocumentHandler() {
        }

        public void nodeInserted(Node node) {
            CSSEngine.this.handleNodeInserted(node);
        }

        public void nodeToBeRemoved(Node node) {
            CSSEngine.this.handleNodeRemoved(node);
        }

        public void subtreeModified(Node node) {
            CSSEngine.this.handleSubtreeModified(node);
        }

        public void characterDataModified(Node node) {
            CSSEngine.this.handleCharacterDataModified(node);
        }

        public void attrModified(Element element, Attr attr, short s, String string, String string2) {
            CSSEngine.this.handleAttrModified(element, attr, s, string, string2);
        }

        public void overrideStyleTextChanged(CSSStylableElement cSSStylableElement, String string) {
            int n;
            StyleDeclarationProvider styleDeclarationProvider = cSSStylableElement.getOverrideStyleDeclarationProvider();
            StyleDeclaration styleDeclaration = styleDeclarationProvider.getStyleDeclaration();
            int n2 = styleDeclaration.size();
            boolean[] blArray = new boolean[CSSEngine.this.getNumberOfProperties()];
            for (n = 0; n < n2; ++n) {
                blArray[styleDeclaration.getIndex((int)n)] = true;
            }
            styleDeclaration = CSSEngine.this.parseStyleDeclaration(cSSStylableElement, string);
            styleDeclarationProvider.setStyleDeclaration(styleDeclaration);
            n2 = styleDeclaration.size();
            for (n = 0; n < n2; ++n) {
                blArray[styleDeclaration.getIndex((int)n)] = true;
            }
            CSSEngine.this.invalidateProperties(cSSStylableElement, null, blArray, true);
        }

        public void overrideStylePropertyRemoved(CSSStylableElement cSSStylableElement, String string) {
            StyleDeclarationProvider styleDeclarationProvider = cSSStylableElement.getOverrideStyleDeclarationProvider();
            StyleDeclaration styleDeclaration = styleDeclarationProvider.getStyleDeclaration();
            int n = CSSEngine.this.getPropertyIndex(string);
            int n2 = styleDeclaration.size();
            for (int i = 0; i < n2; ++i) {
                if (n != styleDeclaration.getIndex(i)) continue;
                styleDeclaration.remove(i);
                StyleMap styleMap = cSSStylableElement.getComputedStyleMap(null);
                if (styleMap == null || styleMap.getOrigin(n) != -24576) break;
                CSSEngine.this.invalidateProperties(cSSStylableElement, new int[]{n}, null, true);
                break;
            }
        }

        public void overrideStylePropertyChanged(CSSStylableElement cSSStylableElement, String string, String string2, String string3) {
            boolean bl = string3 != null && string3.length() != 0;
            StyleDeclarationProvider styleDeclarationProvider = cSSStylableElement.getOverrideStyleDeclarationProvider();
            this.declaration = styleDeclarationProvider.getStyleDeclaration();
            CSSEngine.this.setMainProperties(cSSStylableElement, this, string, string2, bl);
            this.declaration = null;
            CSSEngine.this.invalidateProperties(cSSStylableElement, null, this.mainPropertiesChanged, true);
        }

        public void setMainProperty(String string, Value value, boolean bl) {
            int n;
            int n2 = CSSEngine.this.getPropertyIndex(string);
            if (n2 == -1) {
                return;
            }
            for (n = 0; n < this.declaration.size() && n2 != this.declaration.getIndex(n); ++n) {
            }
            if (n < this.declaration.size()) {
                this.declaration.put(n, value, n2, bl);
            } else {
                this.declaration.append(value, n2, bl);
            }
        }
    }

    protected class StyleDeclarationUpdateHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleMap styleMap;
        public boolean[] updatedProperties;

        protected StyleDeclarationUpdateHandler() {
            this.updatedProperties = new boolean[CSSEngine.this.getNumberOfProperties()];
        }

        public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
            int n = CSSEngine.this.getPropertyIndex(string);
            if (n == -1) {
                n = CSSEngine.this.getShorthandIndex(string);
                if (n == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
            } else {
                if (this.styleMap.isImportant(n)) {
                    return;
                }
                this.updatedProperties[n] = true;
                Value value = CSSEngine.this.valueManagers[n].createValue(lexicalUnit, CSSEngine.this);
                this.styleMap.putMask(n, (short)0);
                this.styleMap.putValue(n, value);
                this.styleMap.putOrigin(n, (short)Short.MIN_VALUE);
            }
        }
    }

    protected static class DocumentAdapter
    implements DocumentHandler {
        protected DocumentAdapter() {
        }

        public void startDocument(InputSource inputSource) {
            this.throwUnsupportedEx();
        }

        public void endDocument(InputSource inputSource) {
            this.throwUnsupportedEx();
        }

        public void comment(String string) {
        }

        public void ignorableAtRule(String string) {
            this.throwUnsupportedEx();
        }

        public void namespaceDeclaration(String string, String string2) {
            this.throwUnsupportedEx();
        }

        public void importStyle(String string, SACMediaList sACMediaList, String string2) {
            this.throwUnsupportedEx();
        }

        public void startMedia(SACMediaList sACMediaList) {
            this.throwUnsupportedEx();
        }

        public void endMedia(SACMediaList sACMediaList) {
            this.throwUnsupportedEx();
        }

        public void startPage(String string, String string2) {
            this.throwUnsupportedEx();
        }

        public void endPage(String string, String string2) {
            this.throwUnsupportedEx();
        }

        public void startFontFace() {
            this.throwUnsupportedEx();
        }

        public void endFontFace() {
            this.throwUnsupportedEx();
        }

        public void startSelector(SelectorList selectorList) {
            this.throwUnsupportedEx();
        }

        public void endSelector(SelectorList selectorList) {
            this.throwUnsupportedEx();
        }

        public void property(String string, LexicalUnit lexicalUnit, boolean bl) {
            this.throwUnsupportedEx();
        }

        private void throwUnsupportedEx() {
            throw new UnsupportedOperationException("you try to use an empty method in Adapter-class");
        }
    }

    protected class StyleSheetDocumentHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleSheet styleSheet;
        protected StyleRule styleRule;
        protected StyleDeclaration styleDeclaration;

        protected StyleSheetDocumentHandler() {
        }

        public void startDocument(InputSource inputSource) throws CSSException {
        }

        public void endDocument(InputSource inputSource) throws CSSException {
        }

        public void ignorableAtRule(String string) throws CSSException {
        }

        public void importStyle(String string, SACMediaList sACMediaList, String string2) throws CSSException {
            ImportRule importRule = new ImportRule();
            importRule.setMediaList(sACMediaList);
            importRule.setParent(this.styleSheet);
            try {
                URL uRL = CSSEngine.this.getCSSBaseURI();
                URL uRL2 = uRL == null ? new URL(string) : new URL(uRL, string);
                importRule.setURI(uRL2);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            this.styleSheet.append(importRule);
        }

        public void startMedia(SACMediaList sACMediaList) throws CSSException {
            MediaRule mediaRule = new MediaRule();
            mediaRule.setMediaList(sACMediaList);
            mediaRule.setParent(this.styleSheet);
            this.styleSheet.append(mediaRule);
            this.styleSheet = mediaRule;
        }

        public void endMedia(SACMediaList sACMediaList) throws CSSException {
            this.styleSheet = this.styleSheet.getParent();
        }

        public void startPage(String string, String string2) throws CSSException {
        }

        public void endPage(String string, String string2) throws CSSException {
        }

        public void startFontFace() throws CSSException {
            this.styleDeclaration = new StyleDeclaration();
        }

        public void endFontFace() throws CSSException {
            int n;
            StyleMap styleMap = new StyleMap(CSSEngine.this.getNumberOfProperties());
            int n2 = this.styleDeclaration.size();
            for (n = 0; n < n2; ++n) {
                int n3 = this.styleDeclaration.getIndex(n);
                styleMap.putValue(n3, this.styleDeclaration.getValue(n));
                styleMap.putImportant(n3, this.styleDeclaration.getPriority(n));
                styleMap.putOrigin(n3, (short)24576);
            }
            this.styleDeclaration = null;
            n = CSSEngine.this.getPropertyIndex("font-family");
            Value value = styleMap.getValue(n);
            if (value == null) {
                return;
            }
            URL uRL = CSSEngine.this.getCSSBaseURI();
            ParsedURL parsedURL = null;
            if (uRL != null) {
                parsedURL = new ParsedURL(uRL);
            }
            CSSEngine.this.fontFaces.add(new FontFaceRule(styleMap, parsedURL));
        }

        public void startSelector(SelectorList selectorList) throws CSSException {
            this.styleRule = new StyleRule();
            this.styleRule.setSelectorList(selectorList);
            this.styleDeclaration = new StyleDeclaration();
            this.styleRule.setStyleDeclaration(this.styleDeclaration);
            this.styleSheet.append(this.styleRule);
        }

        public void endSelector(SelectorList selectorList) throws CSSException {
            this.styleRule = null;
            this.styleDeclaration = null;
        }

        public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
            int n = CSSEngine.this.getPropertyIndex(string);
            if (n == -1) {
                n = CSSEngine.this.getShorthandIndex(string);
                if (n == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
            } else {
                Value value = CSSEngine.this.valueManagers[n].createValue(lexicalUnit, CSSEngine.this);
                this.styleDeclaration.append(value, n, bl);
            }
        }
    }

    protected class StyleDeclarationBuilder
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleDeclaration styleDeclaration;

        protected StyleDeclarationBuilder() {
        }

        public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
            int n = CSSEngine.this.getPropertyIndex(string);
            if (n == -1) {
                n = CSSEngine.this.getShorthandIndex(string);
                if (n == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
            } else {
                Value value = CSSEngine.this.valueManagers[n].createValue(lexicalUnit, CSSEngine.this);
                this.styleDeclaration.append(value, n, bl);
            }
        }
    }

    protected class StyleDeclarationDocumentHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleMap styleMap;

        protected StyleDeclarationDocumentHandler() {
        }

        public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
            int n = CSSEngine.this.getPropertyIndex(string);
            if (n == -1) {
                n = CSSEngine.this.getShorthandIndex(string);
                if (n == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
            } else {
                Value value = CSSEngine.this.valueManagers[n].createValue(lexicalUnit, CSSEngine.this);
                CSSEngine.this.putAuthorProperty(this.styleMap, n, value, bl, (short)Short.MIN_VALUE);
            }
        }
    }

    public static interface MainPropertyReceiver {
        public void setMainProperty(String var1, Value var2, boolean var3);
    }
}

