/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.ext.awt.geom.Cubic;
import org.apache.batik.ext.awt.geom.Linear;
import org.apache.batik.ext.awt.geom.Quadradic;
import org.apache.batik.ext.awt.geom.Segment;

public class SegmentList {
    List segments = new LinkedList();

    public SegmentList() {
    }

    public SegmentList(Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(null);
        float[] fArray = new float[6];
        Point2D.Double double_ = null;
        Point2D.Double double_2 = null;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    double_2 = double_ = new Point2D.Double(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    Point2D.Double double_3 = new Point2D.Double(fArray[0], fArray[1]);
                    this.segments.add(new Linear(double_, double_3));
                    double_ = double_3;
                    break;
                }
                case 2: {
                    Point2D.Double double_3 = new Point2D.Double(fArray[0], fArray[1]);
                    Point2D.Double double_4 = new Point2D.Double(fArray[2], fArray[3]);
                    this.segments.add(new Quadradic(double_, double_3, double_4));
                    double_ = double_4;
                    break;
                }
                case 3: {
                    Point2D.Double double_3 = new Point2D.Double(fArray[0], fArray[1]);
                    Point2D.Double double_4 = new Point2D.Double(fArray[2], fArray[3]);
                    Point2D.Double double_5 = new Point2D.Double(fArray[4], fArray[5]);
                    this.segments.add(new Cubic(double_, double_3, double_4, double_5));
                    double_ = double_5;
                    break;
                }
                case 4: {
                    this.segments.add(new Linear(double_, double_2));
                    double_ = double_2;
                }
            }
            pathIterator.next();
        }
    }

    public Rectangle2D getBounds2D() {
        Iterator iterator = this.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Rectangle2D rectangle2D = (Rectangle2D)((Segment)iterator.next()).getBounds2D().clone();
        while (iterator.hasNext()) {
            Segment segment = (Segment)iterator.next();
            Rectangle2D rectangle2D2 = segment.getBounds2D();
            Rectangle2D.union(rectangle2D2, rectangle2D, rectangle2D);
        }
        return rectangle2D;
    }

    public void add(Segment segment) {
        this.segments.add(segment);
    }

    public Iterator iterator() {
        return this.segments.iterator();
    }

    public int size() {
        return this.segments.size();
    }

    public SplitResults split(double d) {
        Iterator iterator = this.segments.iterator();
        SegmentList segmentList = null;
        SegmentList segmentList2 = null;
        while (iterator.hasNext()) {
            Segment[] segmentArray;
            Segment segment = (Segment)iterator.next();
            Segment.SplitResults splitResults = segment.split(d);
            if (splitResults == null) {
                segmentArray = segment.getBounds2D();
                if (segmentArray.getY() > d) {
                    if (segmentList2 == null) {
                        segmentList2 = new SegmentList();
                    }
                    segmentList2.add(segment);
                    continue;
                }
                if (segmentArray.getY() == d) {
                    if (segmentArray.getHeight() == 0.0) continue;
                    if (segmentList2 == null) {
                        segmentList2 = new SegmentList();
                    }
                    segmentList2.add(segment);
                    continue;
                }
                if (segmentList == null) {
                    segmentList = new SegmentList();
                }
                segmentList.add(segment);
                continue;
            }
            segmentArray = splitResults.getAbove();
            for (int i = 0; i < segmentArray.length; ++i) {
                if (segmentList == null) {
                    segmentList = new SegmentList();
                }
                segmentList.add(segmentArray[i]);
            }
            Segment[] segmentArray2 = splitResults.getBelow();
            for (int i = 0; i < segmentArray2.length; ++i) {
                if (segmentList2 == null) {
                    segmentList2 = new SegmentList();
                }
                segmentList2.add(segmentArray2[i]);
            }
        }
        return new SplitResults(segmentList, segmentList2);
    }

    public static class SplitResults {
        SegmentList above;
        SegmentList below;

        public SplitResults(SegmentList segmentList, SegmentList segmentList2) {
            this.above = segmentList;
            this.below = segmentList2;
        }

        public SegmentList getAbove() {
            return this.above;
        }

        public SegmentList getBelow() {
            return this.below;
        }
    }
}

