/*
 * Decompiled with CFR 0.152.
 */
package buoy.event;

import buoy.internal.EventLinkRecord;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class EventSource {
    protected ArrayList eventLinks;

    public void addEventLink(Class eventType, Object target) {
        this.addEventLink(eventType, target, "processEvent");
    }

    public void addEventLink(Class eventType, Object target, String method) {
        for (Class<?> cls = target.getClass(); cls != null; cls = cls.getSuperclass()) {
            Method[] m = cls.getDeclaredMethods();
            for (int i = 0; i < m.length; ++i) {
                Class<?>[] param;
                if (!m[i].getName().equals(method) || (param = m[i].getParameterTypes()).length != 0 && (param.length != 1 || !param[0].isAssignableFrom(eventType))) continue;
                this.addEventLink(eventType, target, m[i]);
                return;
            }
        }
        throw new IllegalArgumentException("No method found which matches " + method + "(" + eventType.getName() + ")");
    }

    public void addEventLink(Class eventType, Object target, Method method) {
        if (this.eventLinks == null) {
            this.eventLinks = new ArrayList();
        }
        if (!Modifier.isPublic(method.getDeclaringClass().getModifiers()) || !Modifier.isPublic(method.getModifiers())) {
            method.setAccessible(true);
        }
        for (int i = 0; i < this.eventLinks.size(); ++i) {
            EventLinkRecord rec = (EventLinkRecord)this.eventLinks.get(i);
            if (rec.getEventType() != eventType) continue;
            rec.addLink(target, method);
            return;
        }
        EventLinkRecord rec = new EventLinkRecord(eventType);
        rec.addLink(target, method);
        this.eventLinks.add(rec);
    }

    public void removeEventLink(Class eventType, Object target) {
        if (this.eventLinks == null) {
            return;
        }
        for (int i = 0; i < this.eventLinks.size(); ++i) {
            EventLinkRecord rec = (EventLinkRecord)this.eventLinks.get(i);
            if (rec.getEventType() != eventType) continue;
            rec.removeLink(target);
            return;
        }
    }

    public void dispatchEvent(Object event) {
        if (this.eventLinks == null) {
            return;
        }
        for (int i = 0; i < this.eventLinks.size(); ++i) {
            EventLinkRecord rec = (EventLinkRecord)this.eventLinks.get(i);
            if (!rec.getEventType().isInstance(event)) continue;
            rec.dispatchEvent(event);
        }
    }
}

