/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.internal.WidgetContainerPanel;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.IndexedContainerDelegate;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;

public class RowContainer
extends WidgetContainer {
    private ArrayList child;
    private ArrayList childLayout;
    private LayoutInfo defaultLayout;

    public RowContainer() {
        this.component = new WidgetContainerPanel(this);
        this.child = new ArrayList();
        this.childLayout = new ArrayList();
        this.defaultLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(2, 2, 2, 2), null);
    }

    public int getChildCount() {
        return this.child.size();
    }

    public Widget getChild(int i) {
        return (Widget)this.child.get(i);
    }

    public Collection getChildren() {
        return new ArrayList(this.child);
    }

    public void layoutChildren() {
        Dimension size = this.component.getSize();
        Rectangle cell = new Rectangle(0, 0, 0, size.height);
        for (int i = 0; i < this.child.size(); ++i) {
            Widget w = (Widget)this.child.get(i);
            LayoutInfo layout = (LayoutInfo)this.childLayout.get(i);
            if (layout == null) {
                layout = this.defaultLayout;
            }
            Dimension prefSize = layout.getPreferredSize(w);
            cell.width = prefSize.width;
            w.getComponent().setBounds(layout.getWidgetLayout(w, cell));
            if (w instanceof WidgetContainer) {
                ((WidgetContainer)w).layoutChildren();
            }
            cell.x += prefSize.width;
        }
    }

    public void add(Widget widget) {
        this.add(widget, null);
    }

    public void add(Widget widget, LayoutInfo layout) {
        this.add(widget, widget.getParent() == this ? this.getChildCount() - 1 : this.getChildCount(), layout);
    }

    public void add(Widget widget, int index, LayoutInfo layout) {
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        this.child.add(index, widget);
        this.childLayout.add(index, layout);
        ((JPanel)this.component).add(widget.component, index);
        this.setAsParent(widget);
        this.invalidateSize();
    }

    public LayoutInfo getChildLayout(int index) {
        return (LayoutInfo)this.childLayout.get(index);
    }

    public void setChildLayout(int index, LayoutInfo layout) {
        this.childLayout.set(index, layout);
        this.invalidateSize();
    }

    public LayoutInfo getChildLayout(Widget widget) {
        int index = this.child.indexOf(widget);
        if (index == -1) {
            return null;
        }
        return (LayoutInfo)this.childLayout.get(index);
    }

    public void setChildLayout(Widget widget, LayoutInfo layout) {
        int index = this.child.indexOf(widget);
        if (index == -1) {
            return;
        }
        this.childLayout.set(index, layout);
        this.invalidateSize();
    }

    public LayoutInfo getDefaultLayout() {
        return this.defaultLayout;
    }

    public void setDefaultLayout(LayoutInfo layout) {
        this.defaultLayout = layout;
        this.invalidateSize();
    }

    public void remove(Widget widget) {
        int index = this.child.indexOf(widget);
        if (index > -1) {
            this.remove(index);
        }
    }

    public void remove(int index) {
        Widget w = (Widget)this.child.get(index);
        ((JPanel)this.component).remove(w.component);
        this.child.remove(index);
        this.childLayout.remove(index);
        this.removeAsParent(w);
        this.invalidateSize();
    }

    public void removeAll() {
        ((JPanel)this.component).removeAll();
        for (int i = 0; i < this.child.size(); ++i) {
            this.removeAsParent((Widget)this.child.get(i));
        }
        this.child.clear();
        this.childLayout.clear();
        this.invalidateSize();
    }

    public int getChildIndex(Widget widget) {
        return this.child.indexOf(widget);
    }

    public Dimension getMinimumSize() {
        Dimension minSize = new Dimension(0, 0);
        for (int i = 0; i < this.child.size(); ++i) {
            Dimension dim = ((Widget)this.child.get(i)).getMinimumSize();
            minSize.width += dim.width;
            if (minSize.height >= dim.height) continue;
            minSize.height = dim.height;
        }
        return minSize;
    }

    public Dimension getPreferredSize() {
        Dimension prefSize = new Dimension(0, 0);
        for (int i = 0; i < this.child.size(); ++i) {
            Widget w = (Widget)this.child.get(i);
            LayoutInfo layout = (LayoutInfo)this.childLayout.get(i);
            if (layout == null) {
                layout = this.defaultLayout;
            }
            Dimension dim = layout.getPreferredSize(w);
            prefSize.width += dim.width;
            if (prefSize.height >= dim.height) continue;
            prefSize.height = dim.height;
        }
        return prefSize;
    }

    static {
        WidgetEncoder.setPersistenceDelegate(RowContainer.class, new IndexedContainerDelegate(new String[]{"getChild", "getChildLayout"}));
    }
}

