/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.TypeInfo;
import org.postgresql.util.GT;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class TypeInfoCache
implements TypeInfo {
    private Map _pgNameToSQLType;
    private Map _pgNameToJavaClass;
    private Map _oidToPgName;
    private Map _pgNameToOid;
    private Map _pgNameToPgObject;
    private Map _pgArrayToPgType;
    private Map _arrayOidToDelimiter;
    private BaseConnection _conn;
    private final int _unknownLength;
    private PreparedStatement _getOidStatement;
    private PreparedStatement _getNameStatement;
    private PreparedStatement _getArrayElementOidStatement;
    private PreparedStatement _getArrayDelimiterStatement;
    private PreparedStatement _getTypeInfoStatement;
    private static final Object[][] types = new Object[][]{{"int2", new Integer(21), new Integer(5), "java.lang.Integer", new Integer(1005)}, {"int4", new Integer(23), new Integer(4), "java.lang.Integer", new Integer(1007)}, {"oid", new Integer(26), new Integer(-5), "java.lang.Long", new Integer(1028)}, {"int8", new Integer(20), new Integer(-5), "java.lang.Long", new Integer(1016)}, {"money", new Integer(790), new Integer(8), "java.lang.Double", new Integer(791)}, {"numeric", new Integer(1700), new Integer(2), "java.math.BigDecimal", new Integer(1231)}, {"float4", new Integer(700), new Integer(7), "java.lang.Float", new Integer(1021)}, {"float8", new Integer(701), new Integer(8), "java.lang.Double", new Integer(1022)}, {"char", new Integer(18), new Integer(1), "java.lang.String", new Integer(1002)}, {"bpchar", new Integer(1042), new Integer(1), "java.lang.String", new Integer(1014)}, {"varchar", new Integer(1043), new Integer(12), "java.lang.String", new Integer(1015)}, {"text", new Integer(25), new Integer(12), "java.lang.String", new Integer(1009)}, {"name", new Integer(19), new Integer(12), "java.lang.String", new Integer(1003)}, {"bytea", new Integer(17), new Integer(-2), "[B", new Integer(1001)}, {"bool", new Integer(16), new Integer(-7), "java.lang.Boolean", new Integer(1000)}, {"bit", new Integer(1560), new Integer(-7), "java.lang.Boolean", new Integer(1561)}, {"date", new Integer(1082), new Integer(91), "java.sql.Date", new Integer(1182)}, {"time", new Integer(1083), new Integer(92), "java.sql.Time", new Integer(1183)}, {"timetz", new Integer(1266), new Integer(92), "java.sql.Time", new Integer(1270)}, {"timestamp", new Integer(1114), new Integer(93), "java.sql.Timestamp", new Integer(1115)}, {"timestamptz", new Integer(1184), new Integer(93), "java.sql.Timestamp", new Integer(1185)}};
    private static final HashMap typeAliases = new HashMap();

    public TypeInfoCache(BaseConnection conn, int unknownLength) {
        this._conn = conn;
        this._unknownLength = unknownLength;
        this._oidToPgName = new HashMap();
        this._pgNameToOid = new HashMap();
        this._pgNameToJavaClass = new HashMap();
        this._pgNameToPgObject = new HashMap();
        this._pgArrayToPgType = new HashMap();
        this._arrayOidToDelimiter = new HashMap();
        this._pgNameToSQLType = Collections.synchronizedMap(new HashMap());
        for (int i = 0; i < types.length; ++i) {
            String pgTypeName = (String)types[i][0];
            Integer oid = (Integer)types[i][1];
            Integer sqlType = (Integer)types[i][2];
            String javaClass = (String)types[i][3];
            Integer arrayOid = (Integer)types[i][4];
            this.addCoreType(pgTypeName, oid, sqlType, javaClass, arrayOid);
        }
    }

    public synchronized void addCoreType(String pgTypeName, Integer oid, Integer sqlType, String javaClass, Integer arrayOid) {
        this._pgNameToJavaClass.put(pgTypeName, javaClass);
        this._pgNameToOid.put(pgTypeName, oid);
        this._oidToPgName.put(oid, pgTypeName);
        this._pgArrayToPgType.put(arrayOid, oid);
        this._pgNameToSQLType.put(pgTypeName, sqlType);
        Character delim = new Character(',');
        this._arrayOidToDelimiter.put(oid, delim);
        String pgArrayTypeName = "_" + pgTypeName;
        this._pgNameToJavaClass.put(pgArrayTypeName, "java.sql.Array");
        this._pgNameToSQLType.put(pgArrayTypeName, new Integer(2003));
    }

    public synchronized void addDataType(String type, Class klass) throws SQLException {
        if (!PGobject.class.isAssignableFrom(klass)) {
            throw new PSQLException(GT.tr("The class {0} does not implement org.postgresql.util.PGobject.", klass.toString()), PSQLState.INVALID_PARAMETER_TYPE);
        }
        this._pgNameToPgObject.put(type, klass);
        this._pgNameToJavaClass.put(type, klass.getName());
    }

    public Iterator getPGTypeNamesWithSQLTypes() {
        return this._pgNameToSQLType.keySet().iterator();
    }

    public int getSQLType(int oid) throws SQLException {
        return this.getSQLType(this.getPGType(oid));
    }

    public synchronized int getSQLType(String pgTypeName) throws SQLException {
        Integer i = (Integer)this._pgNameToSQLType.get(pgTypeName);
        if (i != null) {
            return i;
        }
        if (this._getTypeInfoStatement == null) {
            String sql = "SELECT typinput='array_in'::regproc, typtype FROM ";
            if (this._conn.haveMinimumServerVersion("7.3")) {
                sql = sql + "pg_catalog.";
            }
            sql = sql + "pg_type WHERE typname = ?";
            this._getTypeInfoStatement = this._conn.prepareStatement(sql);
        }
        this._getTypeInfoStatement.setString(1, pgTypeName);
        if (!((BaseStatement)((Object)this._getTypeInfoStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getTypeInfoStatement.getResultSet();
        Integer type = null;
        if (rs.next()) {
            boolean isArray = rs.getBoolean(1);
            String typtype = rs.getString(2);
            if (isArray) {
                type = new Integer(2003);
            } else if ("c".equals(typtype)) {
                type = new Integer(2002);
            } else if ("d".equals(typtype)) {
                type = new Integer(2001);
            }
        }
        if (type == null) {
            type = new Integer(1111);
        }
        rs.close();
        this._pgNameToSQLType.put(pgTypeName, type);
        return type;
    }

    public synchronized int getPGType(String pgTypeName) throws SQLException {
        Integer oid = (Integer)this._pgNameToOid.get(pgTypeName);
        if (oid != null) {
            return oid;
        }
        if (this._getOidStatement == null) {
            String sql = this._conn.haveMinimumServerVersion("7.3") ? "SELECT oid FROM pg_catalog.pg_type WHERE typname = ?" : "SELECT oid FROM pg_type WHERE typname = ?";
            this._getOidStatement = this._conn.prepareStatement(sql);
        }
        this._getOidStatement.setString(1, pgTypeName);
        if (!((BaseStatement)((Object)this._getOidStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        oid = new Integer(0);
        ResultSet rs = this._getOidStatement.getResultSet();
        if (rs.next()) {
            oid = new Integer((int)rs.getLong(1));
            this._oidToPgName.put(oid, pgTypeName);
        }
        this._pgNameToOid.put(pgTypeName, oid);
        rs.close();
        return oid;
    }

    public synchronized String getPGType(int oid) throws SQLException {
        if (oid == 0) {
            return null;
        }
        String pgTypeName = (String)this._oidToPgName.get(new Integer(oid));
        if (pgTypeName != null) {
            return pgTypeName;
        }
        if (this._getNameStatement == null) {
            String sql = this._conn.haveMinimumServerVersion("7.3") ? "SELECT typname FROM pg_catalog.pg_type WHERE oid = ?" : "SELECT typname FROM pg_type WHERE oid = ?";
            this._getNameStatement = this._conn.prepareStatement(sql);
        }
        this._getNameStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getNameStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getNameStatement.getResultSet();
        if (rs.next()) {
            pgTypeName = rs.getString(1);
            this._pgNameToOid.put(pgTypeName, new Integer(oid));
            this._oidToPgName.put(new Integer(oid), pgTypeName);
        }
        rs.close();
        return pgTypeName;
    }

    public int getPGArrayType(String elementTypeName) throws SQLException {
        elementTypeName = this.getTypeForAlias(elementTypeName);
        return this.getPGType("_" + elementTypeName);
    }

    protected synchronized int convertArrayToBaseOid(int oid) {
        Integer i = (Integer)this._pgArrayToPgType.get(new Integer(oid));
        if (i == null) {
            return oid;
        }
        return i;
    }

    public synchronized char getArrayDelimiter(int oid) throws SQLException {
        if (oid == 0) {
            return ',';
        }
        Character delim = (Character)this._arrayOidToDelimiter.get(new Integer(oid));
        if (delim != null) {
            return delim.charValue();
        }
        if (this._getArrayDelimiterStatement == null) {
            String sql = this._conn.haveMinimumServerVersion("7.3") ? "SELECT e.typdelim FROM pg_catalog.pg_type t, pg_catalog.pg_type e WHERE t.oid = ? and t.typelem = e.oid" : "SELECT e.typdelim FROM pg_type t, pg_type e WHERE t.oid = ? and t.typelem = e.oid";
            this._getArrayDelimiterStatement = this._conn.prepareStatement(sql);
        }
        this._getArrayDelimiterStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getArrayDelimiterStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getArrayDelimiterStatement.getResultSet();
        if (!rs.next()) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        String s = rs.getString(1);
        delim = new Character(s.charAt(0));
        this._arrayOidToDelimiter.put(new Integer(oid), delim);
        rs.close();
        return delim.charValue();
    }

    public synchronized int getPGArrayElement(int oid) throws SQLException {
        if (oid == 0) {
            return 0;
        }
        Integer pgType = (Integer)this._pgArrayToPgType.get(new Integer(oid));
        if (pgType != null) {
            return pgType;
        }
        if (this._getArrayElementOidStatement == null) {
            String sql = this._conn.haveMinimumServerVersion("7.3") ? "SELECT e.oid, e.typname FROM pg_catalog.pg_type t, pg_catalog.pg_type e WHERE t.oid = ? and t.typelem = e.oid" : "SELECT e.oid, e.typname FROM pg_type t, pg_type e WHERE t.oid = ? and t.typelem = e.oid";
            this._getArrayElementOidStatement = this._conn.prepareStatement(sql);
        }
        this._getArrayElementOidStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getArrayElementOidStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getArrayElementOidStatement.getResultSet();
        if (!rs.next()) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        pgType = new Integer((int)rs.getLong(1));
        this._pgArrayToPgType.put(new Integer(oid), pgType);
        this._pgNameToOid.put(rs.getString(2), pgType);
        this._oidToPgName.put(pgType, rs.getString(2));
        rs.close();
        return pgType;
    }

    public synchronized Class getPGobject(String type) {
        return (Class)this._pgNameToPgObject.get(type);
    }

    public synchronized String getJavaClass(int oid) throws SQLException {
        String pgTypeName = this.getPGType(oid);
        String result = (String)this._pgNameToJavaClass.get(pgTypeName);
        if (result != null) {
            return result;
        }
        if (this.getSQLType(pgTypeName) == 2003) {
            result = "java.sql.Array";
            this._pgNameToJavaClass.put(pgTypeName, result);
        }
        return result;
    }

    public String getTypeForAlias(String alias) {
        String type = (String)typeAliases.get(alias);
        if (type != null) {
            return type;
        }
        return alias;
    }

    public int getPrecision(int oid, int typmod) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 21: {
                return 5;
            }
            case 23: 
            case 26: {
                return 10;
            }
            case 20: {
                return 19;
            }
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (typmod == -1) {
                    return 0;
                }
                return (typmod - 4 & 0xFFFF0000) >> 16;
            }
            case 16: 
            case 18: {
                return 1;
            }
            case 1042: 
            case 1043: {
                if (typmod == -1) {
                    return this._unknownLength;
                }
                return typmod - 4;
            }
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: {
                return this.getDisplaySize(oid, typmod);
            }
            case 1560: {
                return typmod;
            }
            case 1562: {
                if (typmod == -1) {
                    return this._unknownLength;
                }
                return typmod;
            }
        }
        return this._unknownLength;
    }

    public int getScale(int oid, int typmod) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (typmod == -1) {
                    return 0;
                }
                return typmod - 4 & 0xFFFF;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod;
            }
            case 1186: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod & 0xFFFF;
            }
        }
        return 0;
    }

    public boolean isCaseSensitive(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 700: 
            case 701: 
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: 
            case 1560: 
            case 1562: 
            case 1700: {
                return false;
            }
        }
        return true;
    }

    public boolean isSigned(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 20: 
            case 21: 
            case 23: 
            case 700: 
            case 701: 
            case 1700: {
                return true;
            }
        }
        return false;
    }

    public int getDisplaySize(int oid, int typmod) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 21: {
                return 6;
            }
            case 23: {
                return 11;
            }
            case 26: {
                return 10;
            }
            case 20: {
                return 20;
            }
            case 700: {
                return 14;
            }
            case 701: {
                return 24;
            }
            case 18: {
                return 1;
            }
            case 16: {
                return 1;
            }
            case 1082: {
                return 13;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                int secondSize;
                switch (typmod) {
                    case -1: {
                        secondSize = 7;
                        break;
                    }
                    case 0: {
                        secondSize = 0;
                        break;
                    }
                    case 1: {
                        secondSize = 3;
                        break;
                    }
                    default: {
                        secondSize = typmod + 1;
                    }
                }
                switch (oid) {
                    case 1083: {
                        return 8 + secondSize;
                    }
                    case 1266: {
                        return 8 + secondSize + 6;
                    }
                    case 1114: {
                        return 22 + secondSize;
                    }
                    case 1184: {
                        return 22 + secondSize + 6;
                    }
                }
            }
            case 1186: {
                return 49;
            }
            case 1042: 
            case 1043: {
                if (typmod == -1) {
                    return this._unknownLength;
                }
                return typmod - 4;
            }
            case 1700: {
                if (typmod == -1) {
                    return 131089;
                }
                int precision = typmod - 4 >> 16 & 0xFFFF;
                int scale = typmod - 4 & 0xFFFF;
                return 1 + precision + (scale != 0 ? 1 : 0);
            }
            case 1560: {
                return typmod;
            }
            case 1562: {
                if (typmod == -1) {
                    return this._unknownLength;
                }
                return typmod;
            }
            case 17: 
            case 25: {
                return this._unknownLength;
            }
        }
        return this._unknownLength;
    }

    public int getMaximumPrecision(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 1700: {
                return 1000;
            }
            case 1083: 
            case 1266: {
                return 6;
            }
            case 1114: 
            case 1184: 
            case 1186: {
                return 6;
            }
            case 1042: 
            case 1043: {
                return 0xA00000;
            }
            case 1560: 
            case 1562: {
                return 0x5000000;
            }
        }
        return 0;
    }

    public boolean requiresQuoting(int oid) throws SQLException {
        int sqlType = this.getSQLType(oid);
        switch (sqlType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    static {
        typeAliases.put("smallint", "int2");
        typeAliases.put("integer", "int4");
        typeAliases.put("int", "int4");
        typeAliases.put("bigint", "int8");
        typeAliases.put("float", "float8");
        typeAliases.put("boolean", "bool");
        typeAliases.put("decimal", "numeric");
    }
}

