/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump;

import com.vividsolutions.jump.workbench.JUMPWorkbench;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public final class I18N {
    private static final Logger LOG = Logger.getLogger(I18N.class);
    private static final I18N instance = new I18N();
    public static ResourceBundle rb = ResourceBundle.getBundle("language/jump");
    public static Hashtable plugInsResourceBundle = new Hashtable();
    private static Map<String, I18N> instances = new HashMap<String, I18N>();
    private static ClassLoader classLoader;
    private ResourceBundle resourceBundle;

    private I18N() {
        this.resourceBundle = rb;
    }

    private I18N(String resourcePath) {
        this.resourceBundle = ResourceBundle.getBundle(resourcePath, Locale.getDefault(), classLoader);
    }

    public static void setClassLoader(ClassLoader classLoader) {
        I18N.classLoader = classLoader;
    }

    public String getText(String key) {
        try {
            return this.resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            String[] labelpath = key.split("\\.");
            LOG.debug((Object)("No resource bundle or no translation found for the key : " + key));
            return labelpath[labelpath.length - 1];
        }
    }

    public static String getText(String category, String key) {
        I18N i18n = I18N.getInstance(category);
        return i18n.getText(key);
    }

    public static I18N getInstance(String category) {
        I18N instance = instances.get(category);
        if (instance == null) {
            String resourcePath = category.replace('.', '/') + "/language/jump";
            instance = new I18N(resourcePath);
            instances.put(category, instance);
        }
        return instance;
    }

    public static I18N getInstance() {
        return instance == null ? new I18N() : instance;
    }

    public static void loadFile(String langcountry) {
        String[] lc = langcountry.split("_");
        Locale locale = Locale.getDefault();
        if (lc.length > 1) {
            LOG.debug((Object)("lang:" + lc[0] + " " + "country:" + lc[1]));
            locale = new Locale(lc[0], lc[1]);
        } else if (lc.length > 0) {
            LOG.debug((Object)("lang:" + lc[0]));
            locale = new Locale(lc[0]);
        } else {
            LOG.debug((Object)(langcountry + " is an illegal argument to define lang [and country]"));
        }
        rb = ResourceBundle.getBundle("language/jump", locale);
    }

    public static String get(String label) {
        try {
            return rb.getString(label);
        }
        catch (MissingResourceException e) {
            String[] labelpath = label.split("\\.");
            LOG.debug((Object)("No resource bundle or no translation found for the key : " + label));
            return labelpath[labelpath.length - 1];
        }
    }

    public static String getLocale() {
        return rb.getLocale().getLanguage() + "_" + rb.getLocale().getCountry();
    }

    public static String getLanguage() {
        if (JUMPWorkbench.I18N_SETLOCALE == "") {
            return rb.getLocale().getLanguage();
        }
        return JUMPWorkbench.I18N_SETLOCALE.split("_")[0];
    }

    public static String getMessage(String label, Object[] objects) {
        try {
            MessageFormat mformat = new MessageFormat(rb.getString(label));
            return mformat.format(objects);
        }
        catch (MissingResourceException e) {
            String[] labelpath = label.split("\\.");
            LOG.warn((Object)(e.getMessage() + " no default value, the resource key is used: " + labelpath[labelpath.length - 1]));
            MessageFormat mformat = new MessageFormat(labelpath[labelpath.length - 1]);
            return mformat.format(objects);
        }
    }

    public static String getMessage(String category, String label, Object[] objects) {
        I18N i18n = I18N.getInstance(category);
        return I18N.getMessage(label, objects);
    }
}

