/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.postgis;

import com.vividsolutions.jump.datastore.postgis.PostgisResultSetConverter;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.BaseFeatureInputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class PostgisFeatureInputStream
extends BaseFeatureInputStream {
    private FeatureSchema featureSchema;
    private Connection conn;
    private String queryString;
    private boolean initialized = false;
    private Exception savedException;
    private Statement stmt = null;
    private ResultSet rs = null;
    private PostgisResultSetConverter mapper;
    int geometryColIndex = -1;

    public PostgisFeatureInputStream(Connection conn, String queryString) {
        this.conn = conn;
        this.queryString = queryString;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public Statement getStatement() {
        return this.stmt;
    }

    private void init() throws SQLException {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.stmt = this.conn.createStatement();
        String parsedQuery = this.queryString;
        this.rs = this.stmt.executeQuery(parsedQuery);
        this.mapper = new PostgisResultSetConverter(this.conn, this.rs);
        this.featureSchema = this.mapper.getFeatureSchema();
    }

    protected Feature readNext() throws Exception {
        if (this.savedException != null) {
            throw this.savedException;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.rs == null) {
            return null;
        }
        if (!this.rs.next()) {
            return null;
        }
        return this.getFeature();
    }

    private Feature getFeature() throws Exception {
        return this.mapper.getFeature();
    }

    public void close() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.stmt != null) {
            this.stmt.close();
        }
    }

    public FeatureSchema getFeatureSchema() {
        if (this.featureSchema != null) {
            return this.featureSchema;
        }
        try {
            this.init();
        }
        catch (SQLException ex) {
            this.savedException = ex;
        }
        if (this.featureSchema == null) {
            this.featureSchema = new FeatureSchema();
        }
        return this.featureSchema;
    }
}

