/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.feature;

import com.vividsolutions.jts.geom.Geometry;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;

public class AttributeType
implements Serializable {
    private static final long serialVersionUID = -8443945292593638566L;
    private static HashMap nameToAttributeTypeMap = new HashMap();
    public static final AttributeType STRING = new AttributeType("STRING", String.class);
    public static final AttributeType GEOMETRY = new AttributeType("GEOMETRY", Geometry.class);
    public static final AttributeType INTEGER = new AttributeType("INTEGER", Integer.class);
    public static final AttributeType DATE = new AttributeType("DATE", Date.class);
    public static final AttributeType DOUBLE = new AttributeType("DOUBLE", Double.class);
    public static final AttributeType OBJECT = new AttributeType("OBJECT", Object.class);
    private String name;
    private Class javaClass;

    public static Collection allTypes() {
        return nameToAttributeTypeMap.values();
    }

    private Object readResolve() {
        return nameToAttributeTypeMap.get(this.name);
    }

    private AttributeType(String name, Class javaClass) {
        this.name = name;
        this.javaClass = javaClass;
        nameToAttributeTypeMap.put(name, this);
    }

    public String toString() {
        return this.name;
    }

    public static final AttributeType toAttributeType(String name) {
        AttributeType type = (AttributeType)nameToAttributeTypeMap.get(name);
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return type;
    }

    public Class toJavaClass() {
        return this.javaClass;
    }

    public static AttributeType toAttributeType(Class javaClass) {
        for (AttributeType type : AttributeType.allTypes()) {
            if (type.toJavaClass() != javaClass) continue;
            return type;
        }
        return null;
    }
}

