/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.util.MathUtil;
import java.awt.geom.Point2D;
import java.util.Collection;

public class CoordUtil {
    public static Coordinate average(Coordinate c1, Coordinate c2) {
        if (Double.isNaN(c1.z) || Double.isNaN(c2.z)) {
            return new Coordinate(MathUtil.avg(c1.x, c2.x), MathUtil.avg(c1.y, c2.y));
        }
        return new Coordinate(MathUtil.avg(c1.x, c2.x), MathUtil.avg(c1.y, c2.y), MathUtil.avg(c1.z, c2.z));
    }

    public static Coordinate average(Collection coordinates) {
        Assert.isTrue((!coordinates.isEmpty() ? 1 : 0) != 0);
        double xSum = 0.0;
        double ySum = 0.0;
        double zSum = 0.0;
        boolean zNanFound = false;
        for (Coordinate coordinate : coordinates) {
            xSum += coordinate.x;
            ySum += coordinate.y;
            if (!Double.isNaN(coordinate.z)) {
                zSum += coordinate.z;
                continue;
            }
            zNanFound = true;
        }
        if (zNanFound) {
            return new Coordinate(xSum / (double)coordinates.size(), ySum / (double)coordinates.size());
        }
        return new Coordinate(xSum / (double)coordinates.size(), ySum / (double)coordinates.size(), zSum / (double)coordinates.size());
    }

    public static Coordinate closest(Collection coordinates, Coordinate p) {
        Assert.isTrue((!coordinates.isEmpty() ? 1 : 0) != 0);
        Coordinate closest = (Coordinate)coordinates.iterator().next();
        for (Coordinate candidate : coordinates) {
            if (!(p.distance(candidate) < p.distance(closest))) continue;
            closest = candidate;
        }
        return closest;
    }

    public static Coordinate add(Coordinate c1, Coordinate c2) {
        if (Double.isNaN(c1.z) || Double.isNaN(c2.z)) {
            return new Coordinate(c1.x + c2.x, c1.y + c2.y);
        }
        return new Coordinate(c1.x + c2.x, c1.y + c2.y, c1.z + c2.z);
    }

    public static Coordinate subtract(Coordinate c1, Coordinate c2) {
        if (Double.isNaN(c1.z) || Double.isNaN(c2.z)) {
            return new Coordinate(c1.x - c2.x, c1.y - c2.y);
        }
        return new Coordinate(c1.x - c2.x, c1.y - c2.y, c1.z - c2.z);
    }

    public static Coordinate multiply(double d, Coordinate c) {
        if (Double.isNaN(c.z)) {
            return new Coordinate(d * c.x, d * c.y);
        }
        return new Coordinate(d * c.x, d * c.y, d * c.z);
    }

    public static Coordinate divide(Coordinate c, double d) {
        if (Double.isNaN(c.z)) {
            return new Coordinate(c.x / d, c.y / d);
        }
        return new Coordinate(c.x / d, c.y / d, c.z / d);
    }

    public static Coordinate toCoordinate(Point2D point) {
        return new Coordinate(point.getX(), point.getY());
    }

    public static Point2D toPoint2D(Coordinate coordinate) {
        return new Point2D.Double(coordinate.x, coordinate.y);
    }

    public static Point2D add(Point2D a, Point2D b) {
        return new Point2D.Double(a.getX() + b.getX(), a.getY() + b.getY());
    }

    public static Point2D subtract(Point2D a, Point2D b) {
        return new Point2D.Double(a.getX() - b.getX(), a.getY() - b.getY());
    }
}

