/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.EndianDataOutputStream;
import com.vividsolutions.jump.io.IllegalParametersException;
import com.vividsolutions.jump.io.JUMPWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.geotools.dbffile.DbfFieldDef;
import org.geotools.dbffile.DbfFile;
import org.geotools.dbffile.DbfFileWriter;
import org.geotools.shapefile.Shapefile;

public class ShapefileWriter
implements JUMPWriter {
    public static final String FILE_PROPERTY_KEY = "File";
    public static final String DEFAULT_VALUE_PROPERTY_KEY = "DefaultValue";
    public static final String SHAPE_TYPE_PROPERTY_KEY = "ShapeType";
    protected static CGAlgorithms cga = new RobustCGAlgorithms();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(FeatureCollection featureCollection, DriverProperties dp) throws IllegalParametersException, Exception {
        this.checkIfGeomsAreMixed(featureCollection);
        String shpfileName = dp.getProperty(FILE_PROPERTY_KEY);
        if (shpfileName == null) {
            shpfileName = dp.getProperty(DEFAULT_VALUE_PROPERTY_KEY);
        }
        if (shpfileName == null) {
            throw new IllegalParametersException("no output filename specified");
        }
        int loc = shpfileName.lastIndexOf(File.separatorChar);
        if (loc == -1) {
            throw new Exception("couldn't find the path separator character '" + File.separatorChar + "' in your shape file name. This means you're probably using the unix (or dos) one.");
        }
        String path = shpfileName.substring(0, loc + 1);
        String fname = shpfileName.substring(loc + 1);
        if ((loc = fname.lastIndexOf(".")) == -1) {
            throw new IllegalParametersException("Filename must end in '.shp'");
        }
        String fname_withoutextention = fname.substring(0, loc);
        String dbffname = path + fname_withoutextention + ".dbf";
        String charsetName = dp.getProperty("charset");
        if (charsetName == null) {
            charsetName = Charset.defaultCharset().name();
        }
        this.writeDbf(featureCollection, dbffname, Charset.forName(charsetName));
        GeometryCollection gc = this.makeSHAPEGeometryCollection(featureCollection);
        int shapeType = 2;
        if (dp.getProperty(SHAPE_TYPE_PROPERTY_KEY) != null) {
            String st = dp.getProperty(SHAPE_TYPE_PROPERTY_KEY);
            if (st.equalsIgnoreCase("xy")) {
                shapeType = 2;
            } else if (st.equalsIgnoreCase("xym")) {
                shapeType = 3;
            } else if (st.equalsIgnoreCase("xymz")) {
                shapeType = 4;
            } else if (st.equalsIgnoreCase("xyzm")) {
                shapeType = 4;
            } else {
                if (!st.equalsIgnoreCase("xyz")) throw new IllegalParametersException("ShapefileWriter.write() - dataproperties has a 'ShapeType' that isn't 'xy', 'xym', or 'xymz'");
                shapeType = 4;
            }
        } else if (gc.getNumGeometries() > 0) {
            shapeType = this.guessCoordinateDims(gc.getGeometryN(0));
        }
        URL url = new URL("file", "localhost", shpfileName);
        Shapefile myshape = new Shapefile(url);
        myshape.write(gc, shapeType);
        String shxfname = path + fname_withoutextention + ".shx";
        BufferedOutputStream in = new BufferedOutputStream(new FileOutputStream(shxfname));
        EndianDataOutputStream sfile = new EndianDataOutputStream(in);
        myshape.writeIndex(gc, sfile, shapeType);
    }

    public int guessCoordinateDims(Geometry g) {
        Coordinate[] cs = g.getCoordinates();
        for (int t = 0; t < cs.length; ++t) {
            if (Double.isNaN(cs[t].z)) continue;
            return 4;
        }
        return 2;
    }

    void writeDbf(FeatureCollection featureCollection, String fname) throws Exception {
        this.writeDbf(featureCollection, fname, Charset.defaultCharset());
    }

    void writeDbf(FeatureCollection featureCollection, String fname, Charset charset) throws Exception {
        int t;
        HashMap<String, DbfFieldDef> fieldMap = null;
        if (new File(fname).exists()) {
            DbfFile dbfFile = new DbfFile(fname);
            int numFields = dbfFile.getNumFields();
            fieldMap = new HashMap<String, DbfFieldDef>(numFields);
            for (int i = 0; i < numFields; ++i) {
                String fieldName = dbfFile.getFieldName(i);
                fieldMap.put(fieldName, dbfFile.fielddef[i]);
            }
            dbfFile.close();
        }
        FeatureSchema fs = featureCollection.getFeatureSchema();
        DbfFieldDef[] fields = new DbfFieldDef[fs.getAttributeCount() - 1];
        int f = 0;
        for (t = 0; t < fs.getAttributeCount(); ++t) {
            AttributeType columnType = fs.getAttributeType(t);
            String columnName = fs.getAttributeName(t);
            if (columnType == AttributeType.INTEGER) {
                fields[f] = new DbfFieldDef(columnName, 'N', 11, 0);
                fields[f] = this.overrideWithExistingCompatibleDbfFieldDef(fields[f], fieldMap);
                ++f;
                continue;
            }
            if (columnType == AttributeType.DOUBLE) {
                fields[f] = new DbfFieldDef(columnName, 'N', 33, 16);
                fields[f] = this.overrideWithExistingCompatibleDbfFieldDef(fields[f], fieldMap);
                ++f;
                continue;
            }
            if (columnType == AttributeType.STRING) {
                int maxlength = this.findMaxStringLength(featureCollection, t);
                if (maxlength > 255) {
                    throw new Exception("ShapefileWriter does not support strings longer than 255 characters");
                }
                fields[f] = new DbfFieldDef(columnName, 'C', maxlength, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.DATE) {
                fields[f] = new DbfFieldDef(columnName, 'D', 8, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.GEOMETRY) continue;
            throw new Exception("Shapewriter: unsupported AttributeType found in featurecollection.");
        }
        DbfFileWriter dbf = new DbfFileWriter(fname);
        dbf.setCharset(charset);
        dbf.writeHeader(fields, featureCollection.size());
        int num = featureCollection.size();
        List features = featureCollection.getFeatures();
        for (t = 0; t < num; ++t) {
            Feature feature = (Feature)features.get(t);
            Vector<Object> DBFrow = new Vector<Object>();
            for (int u = 0; u < fs.getAttributeCount(); ++u) {
                Object a;
                AttributeType columnType = fs.getAttributeType(u);
                if (columnType == AttributeType.INTEGER) {
                    a = feature.getAttribute(u);
                    if (a == null) {
                        DBFrow.add(new Integer(0));
                        continue;
                    }
                    DBFrow.add((Integer)a);
                    continue;
                }
                if (columnType == AttributeType.DOUBLE) {
                    a = feature.getAttribute(u);
                    if (a == null) {
                        DBFrow.add(new Double(0.0));
                        continue;
                    }
                    DBFrow.add((Double)a);
                    continue;
                }
                if (columnType == AttributeType.DATE) {
                    a = feature.getAttribute(u);
                    if (a == null) {
                        DBFrow.add("");
                        continue;
                    }
                    DBFrow.add(DbfFile.DATE_PARSER.format((Date)a));
                    continue;
                }
                if (columnType != AttributeType.STRING) continue;
                a = feature.getAttribute(u);
                if (a == null) {
                    DBFrow.add(new String(""));
                    continue;
                }
                if (a instanceof String) {
                    DBFrow.add(a);
                    continue;
                }
                DBFrow.add(a.toString());
            }
            dbf.writeRecord(DBFrow);
        }
        dbf.close();
    }

    private DbfFieldDef overrideWithExistingCompatibleDbfFieldDef(DbfFieldDef field, Map columnMap) {
        String fieldname = field.fieldname.toString().trim();
        if (columnMap != null && columnMap.containsKey(fieldname)) {
            DbfFieldDef dbfFieldDef = (DbfFieldDef)columnMap.get(fieldname);
            dbfFieldDef.fieldname = field.fieldname;
            switch (dbfFieldDef.fieldtype) {
                case 'C': 
                case 'c': {
                    if (field.fieldtype != 'C') break;
                    if (field.fieldlen > dbfFieldDef.fieldlen) {
                        return field;
                    }
                    dbfFieldDef.fieldtype = field.fieldtype;
                    return dbfFieldDef;
                }
                case 'F': 
                case 'N': 
                case 'f': 
                case 'n': {
                    if (field.fieldtype != 'N') break;
                    dbfFieldDef.fieldtype = field.fieldtype;
                    return dbfFieldDef;
                }
            }
        }
        return field;
    }

    int findMaxStringLength(FeatureCollection fc, int attributeNumber) {
        int maxlen = 0;
        Iterator i = fc.iterator();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            int l = f.getString(attributeNumber).getBytes().length;
            if (l <= maxlen) continue;
            maxlen = l;
        }
        return Math.max(1, maxlen);
    }

    int findBestGeometryType(FeatureCollection fc) {
        boolean onlyPoints = true;
        boolean onlyEmptyGeometryCollection = true;
        Iterator i = fc.iterator();
        while (i.hasNext()) {
            Geometry geom = ((Feature)i.next()).getGeometry();
            if (onlyPoints && !(geom instanceof Point)) {
                onlyPoints = false;
            }
            if (onlyEmptyGeometryCollection && !geom.isEmpty()) {
                onlyEmptyGeometryCollection = false;
            }
            if (geom instanceof MultiPoint) {
                return 8;
            }
            if (geom instanceof Polygon) {
                return 5;
            }
            if (geom instanceof MultiPolygon) {
                return 5;
            }
            if (geom instanceof LineString) {
                return 3;
            }
            if (!(geom instanceof MultiLineString)) continue;
            return 3;
        }
        if (onlyPoints) {
            return 1;
        }
        if (onlyEmptyGeometryCollection) {
            return 0;
        }
        return 31;
    }

    public void checkIfGeomsAreMixed(FeatureCollection featureCollection) throws IllegalParametersException, Exception {
        int i = 0;
        Class<?> firstClass = null;
        Geometry firstGeom = null;
        Iterator iter = featureCollection.iterator();
        while (iter.hasNext()) {
            Feature myf = (Feature)iter.next();
            if (i == 0) {
                firstClass = myf.getGeometry().getClass();
                firstGeom = myf.getGeometry();
            } else if (!(firstClass == myf.getGeometry().getClass() || firstGeom instanceof Polygon && myf.getGeometry() instanceof MultiPolygon || firstGeom instanceof MultiPolygon && myf.getGeometry() instanceof Polygon || firstGeom instanceof Point && myf.getGeometry() instanceof MultiPoint || firstGeom instanceof MultiPoint && myf.getGeometry() instanceof Point || firstGeom instanceof LineString && myf.getGeometry() instanceof MultiLineString || firstGeom instanceof MultiLineString && myf.getGeometry() instanceof LineString)) {
                System.out.println("test completely failed - throw exception");
                throw new IllegalParametersException("mixed geometry types found, please separate Polygons from Lines and Points when saving to *.shp");
            }
            ++i;
        }
    }

    LinearRing reverseRing(LinearRing lr) {
        int numPoints = lr.getNumPoints();
        Coordinate[] newCoords = new Coordinate[numPoints];
        for (int t = 0; t < numPoints; ++t) {
            newCoords[t] = lr.getCoordinateN(numPoints - t - 1);
        }
        return new LinearRing(newCoords, new PrecisionModel(), 0);
    }

    Polygon makeGoodSHAPEPolygon(Polygon p) {
        if (p.isEmpty()) {
            return p;
        }
        LinearRing[] holes = new LinearRing[p.getNumInteriorRing()];
        Coordinate[] coords = p.getExteriorRing().getCoordinates();
        LinearRing outer = CGAlgorithms.isCCW((Coordinate[])coords) ? this.reverseRing((LinearRing)p.getExteriorRing()) : (LinearRing)p.getExteriorRing();
        for (int t = 0; t < p.getNumInteriorRing(); ++t) {
            coords = p.getInteriorRingN(t).getCoordinates();
            holes[t] = !CGAlgorithms.isCCW((Coordinate[])coords) ? this.reverseRing((LinearRing)p.getInteriorRingN(t)) : (LinearRing)p.getInteriorRingN(t);
        }
        return new Polygon(outer, holes, new PrecisionModel(), 0);
    }

    MultiPolygon makeGoodSHAPEMultiPolygon(MultiPolygon mp) {
        Polygon[] ps = new Polygon[mp.getNumGeometries()];
        for (int t = 0; t < mp.getNumGeometries(); ++t) {
            ps[t] = this.makeGoodSHAPEPolygon((Polygon)mp.getGeometryN(t));
        }
        MultiPolygon result = new MultiPolygon(ps, new PrecisionModel(), 0);
        return result;
    }

    public GeometryCollection makeSHAPEGeometryCollection(FeatureCollection fc) throws Exception {
        Geometry[] allGeoms = new Geometry[fc.size()];
        int geomtype = this.findBestGeometryType(fc);
        if (geomtype == 31) {
            throw new Exception("Could not determine shapefile type - data is all GeometryCollections");
        }
        List features = fc.getFeatures();
        block7: for (int t = 0; t < features.size(); ++t) {
            Geometry geom = ((Feature)features.get(t)).getGeometry();
            switch (geomtype) {
                case 0: {
                    allGeoms[t] = geom.getFactory().createGeometryCollection(new Geometry[0]);
                    continue block7;
                }
                case 1: {
                    if (geom instanceof Point) {
                        allGeoms[t] = (Point)geom;
                        continue block7;
                    }
                    allGeoms[t] = new Point(null, new PrecisionModel(), 0);
                    continue block7;
                }
                case 8: {
                    Point[] p;
                    if (geom instanceof Point) {
                        p = new Point[]{(Point)geom};
                        allGeoms[t] = new MultiPoint(p, new PrecisionModel(), 0);
                        continue block7;
                    }
                    if (geom instanceof MultiPoint) {
                        allGeoms[t] = geom;
                        continue block7;
                    }
                    allGeoms[t] = new MultiPoint(null, new PrecisionModel(), 0);
                    continue block7;
                }
                case 3: {
                    if (geom instanceof LineString) {
                        LineString[] l = new LineString[]{(LineString)geom};
                        allGeoms[t] = new MultiLineString(l, new PrecisionModel(), 0);
                        continue block7;
                    }
                    if (geom instanceof MultiLineString) {
                        allGeoms[t] = geom;
                        continue block7;
                    }
                    allGeoms[t] = new MultiLineString(null, new PrecisionModel(), 0);
                    continue block7;
                }
                case 5: {
                    Point[] p;
                    if (geom instanceof Polygon) {
                        p = new Polygon[]{(Polygon)geom};
                        allGeoms[t] = this.makeGoodSHAPEMultiPolygon(new MultiPolygon((Polygon[])p, new PrecisionModel(), 0));
                        continue block7;
                    }
                    allGeoms[t] = geom instanceof MultiPolygon ? this.makeGoodSHAPEMultiPolygon((MultiPolygon)geom) : new MultiPolygon(null, new PrecisionModel(), 0);
                }
            }
        }
        GeometryCollection result = new GeometryCollection(allGeoms, new PrecisionModel(), 0);
        return result;
    }
}

