/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io.datasource;

import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.coordsys.CoordinateSystemRegistry;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.datasource.Connection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class DataSource {
    private static Logger LOG = Logger.getLogger(DataSource.class);
    private HashMap properties;
    public static final String FILE_KEY = "File";
    public static final String COORDINATE_SYSTEM_KEY = "Coordinate System";

    public void setProperties(Map properties) {
        this.properties = new HashMap(properties);
    }

    public Map getProperties() {
        return this.properties;
    }

    public abstract Connection getConnection();

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable() {
        return true;
    }

    public FeatureCollection installCoordinateSystem(FeatureCollection queryResult, CoordinateSystemRegistry registry) {
        if (queryResult == null) {
            return queryResult;
        }
        String coordinateSystemName = null;
        try {
            coordinateSystemName = (String)this.getProperties().get(COORDINATE_SYSTEM_KEY);
        }
        catch (NullPointerException e) {
            return queryResult;
        }
        if (coordinateSystemName == null) {
            return queryResult;
        }
        CoordinateSystem coordinateSystem = registry.get(coordinateSystemName);
        if (coordinateSystem == null) {
            return queryResult;
        }
        queryResult.getFeatureSchema().setCoordinateSystem(coordinateSystem);
        return queryResult;
    }
}

