/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.edit;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.CoordinateArrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class SegmentsExtracter {
    private static final GeometryFactory factory = new GeometryFactory();
    private Set segmentSet = new TreeSet();
    private Map segmentMap = new TreeMap();
    private boolean countZeroLengthSegments = true;
    private TaskMonitor monitor;
    private Geometry fence = null;

    public SegmentsExtracter() {
    }

    public SegmentsExtracter(TaskMonitor monitor) {
        this.monitor = monitor;
    }

    public void add(FeatureCollection fc) {
        this.monitor.allowCancellationRequests();
        int totalFeatures = fc.size();
        int j = 0;
        Iterator i = fc.iterator();
        while (i.hasNext() && !this.monitor.isCancelRequested()) {
            Feature feature = (Feature)i.next();
            this.monitor.report(++j, totalFeatures, "features");
            this.add(feature);
        }
    }

    public void add(Feature f) {
        Geometry g = f.getGeometry();
        if (this.fence != null && !g.intersects(this.fence)) {
            return;
        }
        List coordArrays = CoordinateArrays.toCoordinateArrays(g, true);
        for (Coordinate[] coord : coordArrays) {
            for (int j = 0; j < coord.length - 1; ++j) {
                this.add(coord[j], coord[j + 1]);
            }
        }
    }

    public void add(Coordinate p0, Coordinate p1) {
        boolean isZeroLength = p0.equals((Object)p1);
        if (!this.countZeroLengthSegments && isZeroLength) {
            return;
        }
        LineSegment lineseg = new LineSegment(p0, p1);
        lineseg.normalize();
        SegmentCount count = (SegmentCount)this.segmentMap.get(lineseg);
        if (count == null) {
            this.segmentMap.put(lineseg, new SegmentCount(1));
        } else {
            count.increment();
        }
    }

    public Collection getSegments() {
        return this.segmentMap.keySet();
    }

    public Collection getSegments(int minOccurs, int maxOccurs) {
        ArrayList<LineSegment> segmentList = new ArrayList<LineSegment>();
        for (Map.Entry entry : this.segmentMap.entrySet()) {
            LineSegment ls = (LineSegment)entry.getKey();
            int count = ((SegmentCount)entry.getValue()).getCount();
            if (count < minOccurs || count > maxOccurs) continue;
            segmentList.add(ls);
        }
        return segmentList;
    }

    public class SegmentCount {
        private int count = 0;

        public SegmentCount(int value) {
            this.count = value;
        }

        public int getCount() {
            return this.count;
        }

        public void increment() {
            ++this.count;
        }
    }
}

