/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.warp;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.warp.CoordinateTransform;
import com.vividsolutions.jump.warp.Triangle;
import java.util.Map;

public class BilinearInterpolatedTransform
extends CoordinateTransform {
    private Map triangleMap;
    private TaskMonitor monitor;
    private int coordinatesTransformed = 0;

    public BilinearInterpolatedTransform(Map triangleMap, TaskMonitor monitor) {
        this.triangleMap = triangleMap;
        this.monitor = monitor;
        monitor.report("Transforming...");
    }

    public Coordinate transform(Coordinate c) {
        this.monitor.report(++this.coordinatesTransformed, -1, "coordinates");
        Triangle sourceTriangle = this.sourceTriangle(c);
        Assert.isTrue((sourceTriangle != null ? 1 : 0) != 0, (String)("Unable to determine source triangle for " + c));
        Triangle destTriangle = this.destTriangle(sourceTriangle);
        return destTriangle.toEuclideanCoordinate(sourceTriangle.toSimplicialCoordinate(c));
    }

    private Triangle sourceTriangle(Coordinate c) {
        for (Triangle triangle : this.triangleMap.keySet()) {
            if (!triangle.getEnvelope().contains(c) || !triangle.contains(c)) continue;
            return triangle;
        }
        return null;
    }

    private Triangle destTriangle(Triangle sourceTriangle) {
        return (Triangle)this.triangleMap.get(sourceTriangle);
    }
}

