/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.util.commandline.CommandLine;
import com.vividsolutions.jump.util.commandline.OptionSpec;
import com.vividsolutions.jump.util.commandline.ParseException;
import com.vividsolutions.jump.workbench.JUMPConfiguration;
import com.vividsolutions.jump.workbench.JUMPWorkbenchContext;
import com.vividsolutions.jump.workbench.Setup;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.WorkbenchException;
import com.vividsolutions.jump.workbench.WorkbenchProperties;
import com.vividsolutions.jump.workbench.WorkbenchPropertiesFile;
import com.vividsolutions.jump.workbench.driver.DriverManager;
import com.vividsolutions.jump.workbench.plugin.PlugInManager;
import com.vividsolutions.jump.workbench.ui.SplashPanel;
import com.vividsolutions.jump.workbench.ui.SplashWindow;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.TextAttribute;
import java.io.File;
import java.lang.reflect.Method;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.openjump.OpenJumpConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUMPWorkbench {
    private static ImageIcon splashImage;
    public static final ImageIcon APP_ICON;
    public static final ArrayList APP_ICONS;
    public static final String VERSION_TEXT;
    public static final String PROPERTIES_OPTION = "properties";
    public static final String DEFAULT_PLUGINS = "default-plugins";
    public static final String PLUG_IN_DIRECTORY_OPTION = "plug-in-directory";
    public static final String I18N_FILE = "i18n";
    public static final String INITIAL_PROJECT_FILE = "project";
    public static final String STATE_OPTION = "state";
    public static String I18N_SETLOCALE;
    private static Class progressMonitorClass;
    private static CommandLine commandLine;
    private WorkbenchContext context = new JUMPWorkbenchContext(this);
    private WorkbenchFrame frame;
    private DriverManager driverManager = new DriverManager(this.frame);
    private WorkbenchProperties dummyProperties;
    private WorkbenchProperties properties = this.dummyProperties = new WorkbenchProperties(){

        public List getPlugInClasses() {
            return new ArrayList();
        }

        public List getPlugInClasses(ClassLoader classLoader) {
            return new ArrayList();
        }

        public List getInputDriverClasses() {
            return new ArrayList();
        }

        public List getOutputDriverClasses() {
            return new ArrayList();
        }

        public List getConfigurationClasses() {
            return new ArrayList();
        }
    };
    private PlugInManager plugInManager;
    private Blackboard blackboard = new Blackboard();
    private static ImageIcon icon;

    public static ImageIcon splashImage() {
        if (splashImage == null) {
            splashImage = IconLoader.icon("splash.png");
        }
        return splashImage;
    }

    private static ArrayList<Image> appIcons() {
        ArrayList<Image> iconlist = new ArrayList<Image>();
        iconlist.add(IconLoader.image("oj_16_Kplain2oj.png"));
        iconlist.add(IconLoader.image("oj_24.png"));
        iconlist.add(IconLoader.image("oj_32.png"));
        iconlist.add(IconLoader.image("oj_48.png"));
        iconlist.add(IconLoader.image("oj_256.png"));
        return iconlist;
    }

    public static void setIcon(Object o) {
        if (o instanceof JFrame) {
            JFrame f = (JFrame)o;
            try {
                Class[] types = new Class[]{List.class};
                Method method = JFrame.class.getMethod("setIconImages", types);
                Object[] params = new Object[]{APP_ICONS};
                method.invoke((Object)f, params);
            }
            catch (Exception e) {
                f.setIconImage(APP_ICON.getImage());
            }
        } else if (o instanceof JInternalFrame) {
            JInternalFrame f = (JInternalFrame)o;
            f.setFrameIcon(JUMPWorkbench.getIcon());
        }
    }

    public static ImageIcon getIcon() {
        if (!(icon instanceof ImageIcon)) {
            Double jre_version = Double.parseDouble(System.getProperty("java.version").substring(0, 3));
            if (jre_version < 1.6) {
                icon = APP_ICON;
            } else {
                icon = new ImageIcon();
                icon.setImage((Image)APP_ICONS.get(0));
            }
        }
        return icon;
    }

    public JUMPWorkbench(String title, String[] args, final JWindow s, TaskMonitor monitor) throws Exception {
        this.frame = new WorkbenchFrame(title, this.context);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                s.setVisible(false);
            }
        });
        boolean defaultFileExists = false;
        File defaultFile = null;
        if (commandLine.hasOption(DEFAULT_PLUGINS)) {
            defaultFile = new File(commandLine.getOption(DEFAULT_PLUGINS).getArg(0));
            if (defaultFile.exists()) {
                defaultFileExists = true;
            } else {
                System.out.println("JUMP: Warning: Default plugins file does not exist: " + defaultFile);
            }
        }
        boolean propertiesFileExists = false;
        File propertiesFile = null;
        if (commandLine.hasOption(PROPERTIES_OPTION)) {
            propertiesFile = new File(commandLine.getOption(PROPERTIES_OPTION).getArg(0));
            if (propertiesFile.exists()) {
                propertiesFileExists = true;
            } else {
                System.out.println("JUMP: Warning: Properties file does not exist: " + propertiesFile);
            }
        }
        if (defaultFileExists && propertiesFileExists) {
            this.properties = new WorkbenchPropertiesFile(defaultFile, propertiesFile, this.frame);
        } else if (defaultFileExists) {
            this.properties = new WorkbenchPropertiesFile(defaultFile, this.frame);
        } else if (propertiesFileExists) {
            this.properties = new WorkbenchPropertiesFile(propertiesFile, this.frame);
        }
        File extensionsDirectory = null;
        if (commandLine.hasOption(PLUG_IN_DIRECTORY_OPTION)) {
            extensionsDirectory = new File(commandLine.getOption(PLUG_IN_DIRECTORY_OPTION).getArg(0));
            if (!extensionsDirectory.exists()) {
                System.out.println("JUMP: Warning: Extensions directory does not exist: " + extensionsDirectory);
                extensionsDirectory = null;
            }
        } else {
            extensionsDirectory = new File("../lib/ext");
            if (!extensionsDirectory.exists()) {
                System.out.println("JUMP: Warning: Extensions directory does not exist: " + extensionsDirectory + " where homedir = [" + System.getProperty("user.dir") + "]");
                extensionsDirectory = null;
            }
        }
        if (commandLine.hasOption(INITIAL_PROJECT_FILE)) {
            String task = commandLine.getOption(INITIAL_PROJECT_FILE).getArg(0);
            this.getBlackboard().put(INITIAL_PROJECT_FILE, task);
        }
        if (commandLine.hasOption(STATE_OPTION)) {
            File option = new File(commandLine.getOption(STATE_OPTION).getArg(0));
            if (option.isDirectory()) {
                PersistentBlackboardPlugIn.setPersistenceDirectory(option.getPath());
            }
            if (option.isFile()) {
                PersistentBlackboardPlugIn.setFileName(option.getName());
                PersistentBlackboardPlugIn.setPersistenceDirectory(option.getAbsoluteFile().getParent());
            }
        }
        this.plugInManager = new PlugInManager(this.context, extensionsDirectory, monitor);
        this.driverManager.loadDrivers(this.properties);
    }

    public static void main(String[] args) {
        try {
            JUMPWorkbench.parseCommandLine(args);
            if (commandLine.hasOption(I18N_FILE)) {
                I18N.loadFile(commandLine.getOption(I18N_FILE).getArg(0));
                I18N_SETLOCALE = commandLine.getOption(I18N_FILE).getArg(0);
            }
            JUMPWorkbench.initLookAndFeel();
            JUMPWorkbench.setFont();
            ProgressMonitor progressMonitor = (ProgressMonitor)progressMonitorClass.newInstance();
            SplashPanel splashPanel = new SplashPanel(JUMPWorkbench.splashImage(), I18N.get("JUMPWorkbench.version") + " " + VERSION_TEXT);
            splashPanel.add((Component)progressMonitor, new GridBagConstraints(0, 10, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 10), 0, 0));
            JUMPWorkbench.main(args, I18N.get("JUMPWorkbench.jump"), new JUMPConfiguration(), splashPanel, progressMonitor);
        }
        catch (Throwable t) {
            WorkbenchFrame.handleThrowable(t, null);
        }
    }

    public static void main(String[] args, String title, Setup setup, JComponent splashComponent, TaskMonitor taskMonitor) {
        try {
            SplashWindow splashWindow = new SplashWindow(splashComponent);
            splashWindow.setVisible(true);
            JUMPWorkbench workbench = new JUMPWorkbench(title, args, splashWindow, taskMonitor);
            setup.setup(workbench.context);
            WorkbenchFrame frame = workbench.getFrame();
            frame.setLocation(frame.recallWindowLocation());
            frame.setSize(frame.recallWindowSize());
            if (frame.recallMaximizedState()) {
                frame.setExtendedState(6);
            }
            workbench.context.getWorkbench().getPlugInManager().load();
            OpenJumpConfiguration.postExtensionInitialization(workbench.context);
            workbench.getFrame().setVisible(true);
        }
        catch (Throwable t) {
            WorkbenchFrame.handleThrowable(t, null);
        }
    }

    private static void initLookAndFeel() throws Exception {
        if (LangUtil.ifNull(System.getProperty("initLookAndFeel"), "true").toString().equalsIgnoreCase("false")) {
            return;
        }
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("apple.awt.showGrowBox", "true");
        if (UIManager.getLookAndFeel() != null && UIManager.getLookAndFeel().getClass().getName().equals(UIManager.getSystemLookAndFeelClassName())) {
            return;
        }
        String laf = System.getProperty("swing.defaultlaf");
        if (laf == null) {
            laf = UIManager.getSystemLookAndFeelClassName();
        }
        UIManager.setLookAndFeel(laf);
    }

    private static Font[] loadFonts() throws Exception {
        Font font = Font.createFont(0, Class.class.getClass().getResource("/language/fonts/code2000.ttf").openStream());
        return new Font[]{font};
    }

    private static boolean setFont() throws Exception {
        String test = I18N.get("ui.MenuNames.FILE");
        boolean replaced = false;
        Font font = null;
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            FontUIResource fnew;
            FontUIResource fold;
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource) || (fold = (FontUIResource)value).canDisplayUpTo(test) == -1) continue;
            if (font == null) {
                font = JUMPWorkbench.loadFonts()[0];
            }
            Map<TextAttribute, ?> attrs = fold.getAttributes();
            AttributedCharacterIterator.Attribute fam = null;
            Iterator<TextAttribute> iterator = attrs.keySet().iterator();
            while (iterator.hasNext() && !(fam = (AttributedCharacterIterator.Attribute)iterator.next()).toString().equals("java.awt.font.TextAttribute(family)")) {
            }
            if (fam != null) {
                attrs.remove(fam);
            }
            if ((fnew = new FontUIResource(font.deriveFont(attrs))).canDisplayUpTo(test) != -1) continue;
            UIManager.put(key, fnew);
            replaced = true;
        }
        return replaced;
    }

    public DriverManager getDriverManager() {
        return this.driverManager;
    }

    public WorkbenchProperties getProperties() {
        return this.properties;
    }

    public WorkbenchFrame getFrame() {
        return this.frame;
    }

    public WorkbenchContext getContext() {
        return this.context;
    }

    private static void parseCommandLine(String[] args) throws WorkbenchException {
        commandLine = new CommandLine('-');
        commandLine.addOptionSpec(new OptionSpec(PROPERTIES_OPTION, 1));
        commandLine.addOptionSpec(new OptionSpec(DEFAULT_PLUGINS, 1));
        commandLine.addOptionSpec(new OptionSpec(PLUG_IN_DIRECTORY_OPTION, 1));
        commandLine.addOptionSpec(new OptionSpec(I18N_FILE, 1));
        commandLine.addOptionSpec(new OptionSpec(INITIAL_PROJECT_FILE, 1));
        commandLine.addOptionSpec(new OptionSpec(STATE_OPTION, 1));
        try {
            commandLine.parse(args);
        }
        catch (ParseException e) {
            throw new WorkbenchException("A problem occurred parsing the command line: " + e.toString());
        }
    }

    private static void addProperties(WorkbenchProperties oldProperties, WorkbenchProperties newProperties) throws Exception {
        oldProperties.getPlugInClasses().addAll(newProperties.getPlugInClasses());
        oldProperties.getInputDriverClasses().addAll(newProperties.getInputDriverClasses());
        oldProperties.getOutputDriverClasses().addAll(newProperties.getOutputDriverClasses());
        oldProperties.getConfigurationClasses().addAll(newProperties.getConfigurationClasses());
    }

    public PlugInManager getPlugInManager() {
        return this.plugInManager;
    }

    public Blackboard getBlackboard() {
        return this.blackboard;
    }

    static {
        APP_ICON = IconLoader.icon("app-icon.gif");
        APP_ICONS = JUMPWorkbench.appIcons();
        VERSION_TEXT = I18N.get("JUMPWorkbench.version.number");
        I18N_SETLOCALE = "";
        progressMonitorClass = SingleLineProgressMonitor.class;
    }

    private static class HorizontallyScrollingProgressMonitor
    extends ProgressMonitor {
        private static final String BUFFER = "   ";

        public HorizontallyScrollingProgressMonitor() {
            super(new JLabel(" "));
            ((JLabel)this.getComponent()).setFont(((JLabel)this.getComponent()).getFont().deriveFont(1));
            ((JLabel)this.getComponent()).setHorizontalAlignment(4);
        }

        protected void addText(String s) {
            ((JLabel)this.getComponent()).setText(BUFFER + s + ((JLabel)this.getComponent()).getText());
        }
    }

    private static class SingleLineProgressMonitor
    extends ProgressMonitor {
        public SingleLineProgressMonitor() {
            super(new JLabel(" "));
            ((JLabel)this.getComponent()).setFont(((JLabel)this.getComponent()).getFont().deriveFont(1));
            ((JLabel)this.getComponent()).setHorizontalAlignment(2);
        }

        protected void addText(String s) {
            ((JLabel)this.getComponent()).setText(s);
        }
    }

    private static class VerticallyScrollingProgressMonitor
    extends ProgressMonitor {
        private static int ROWS = 3;
        private JLabel[] labels;

        public VerticallyScrollingProgressMonitor() {
            super(new JPanel(new GridLayout(ROWS, 1)));
            JPanel panel = (JPanel)this.getComponent();
            panel.setOpaque(false);
            this.labels = new JLabel[ROWS];
            for (int i = 0; i < ROWS; ++i) {
                this.labels[i] = new JLabel(" ");
                this.labels[i].setFont(this.labels[i].getFont().deriveFont(1));
                panel.add(this.labels[i]);
            }
        }

        protected void addText(String s) {
            for (int i = 0; i < ROWS - 1; ++i) {
                this.labels[i].setText(this.labels[i + 1].getText());
            }
            this.labels[ROWS - 1].setText(s);
        }
    }

    private static abstract class ProgressMonitor
    extends JPanel
    implements TaskMonitor {
        private Component component;

        public ProgressMonitor(Component component) {
            this.component = component;
            this.setLayout(new BorderLayout());
            this.add(component, "Center");
            this.setOpaque(false);
        }

        protected Component getComponent() {
            return this.component;
        }

        protected abstract void addText(String var1);

        public void report(String description) {
            this.addText(description);
        }

        public void report(int itemsDone, int totalItems, String itemDescription) {
            this.addText(itemsDone + " / " + totalItems + " " + itemDescription);
        }

        public void report(Exception exception) {
            this.addText(StringUtil.toFriendlyName(exception.getClass().getName()));
        }

        public void allowCancellationRequests() {
        }

        public boolean isCancelRequested() {
            return false;
        }
    }
}

