/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.datastore;

import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.DataStoreDriver;
import com.vividsolutions.jump.parameter.ParameterList;
import com.vividsolutions.jump.parameter.ParameterListSchema;
import com.vividsolutions.jump.util.Block;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.SimpleStringEncrypter;
import com.vividsolutions.jump.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConnectionDescriptor {
    private String name = null;
    private ParameterList parameterList;
    private String dataStoreDriverClassName;

    private static String getBasicClassName(String fullClassName) {
        int dotPos = fullClassName.lastIndexOf(46);
        String name = fullClassName;
        if (dotPos > 0) {
            name = fullClassName.substring(dotPos + 1);
        }
        return name;
    }

    private static String getDataStoreDriverClassName(String fullClassName) {
        String className = ConnectionDescriptor.getBasicClassName(fullClassName);
        int dsdSuffixIndex = className.indexOf("DataStoreDriver");
        if (dsdSuffixIndex < 1) {
            return className;
        }
        return className.substring(0, dsdSuffixIndex);
    }

    public ConnectionDescriptor() {
    }

    public ConnectionDescriptor(Class dataStoreDriverClass, ParameterList parameterList) {
        this(null, dataStoreDriverClass, parameterList);
    }

    public ConnectionDescriptor(String name, Class dataStoreDriverClass, ParameterList parameterList) {
        this.name = name;
        this.setDataStoreDriverClassName(dataStoreDriverClass.getName());
        this.setParameterList(parameterList);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DataStoreConnection createConnection(DataStoreDriver driver) throws Exception {
        return driver.createConnection(this.parameterList);
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object other) {
        return this.equals((ConnectionDescriptor)other);
    }

    private boolean equals(ConnectionDescriptor other) {
        if (!(other instanceof ConnectionDescriptor)) {
            return false;
        }
        return this.getDataStoreDriverClassName().equals(other.getDataStoreDriverClassName()) && this.getParameterListWithoutPassword().equals((Object)other.getParameterListWithoutPassword());
    }

    public ParameterList getParameterList() {
        return this.parameterList;
    }

    public String toString() {
        if (this.name != null) {
            return this.name + "   (" + this.getParametersString() + ")";
        }
        return this.getParametersString();
    }

    public String getParametersString() {
        return ConnectionDescriptor.getDataStoreDriverClassName(this.dataStoreDriverClassName) + ":" + StringUtil.toCommaDelimitedString(CollectionUtil.select(this.parameterValues(this.getParameterListWithoutPassword()), new Block(){

            public Object yield(Object name) {
                return name != null;
            }
        })).replaceAll(", ", ":");
    }

    private List parameterValues(ParameterList parameterList) {
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        for (String name : Arrays.asList(parameterList.getSchema().getNames())) {
            parameterValues.add(parameterList.getParameter(name));
        }
        return parameterValues;
    }

    public ParameterList getParameterListWithoutPassword() {
        ParameterList parameterListWithoutPassword = new ParameterList(this.parameterList);
        if (ConnectionDescriptor.passwordParameterName(this.parameterList.getSchema()) != null) {
            parameterListWithoutPassword.setParameter(ConnectionDescriptor.passwordParameterName(this.parameterList.getSchema()), null);
        }
        return parameterListWithoutPassword;
    }

    public void setParameterListWithObfuscatedPassword(PersistentParameterList parameterListWithObfuscatedPassword) {
        ParameterList parameterList = new ParameterList(parameterListWithObfuscatedPassword);
        if (ConnectionDescriptor.passwordParameterName(parameterList.getSchema()) != null) {
            parameterList.setParameter(ConnectionDescriptor.passwordParameterName(parameterList.getSchema()), this.unobfuscate(parameterList.getParameterString(ConnectionDescriptor.passwordParameterName(parameterList.getSchema()))));
        }
        this.setParameterList(parameterList);
    }

    public PersistentParameterList getParameterListWithObfuscatedPassword() {
        ParameterList parameterListWithObfuscatedPassword = new ParameterList(this.parameterList);
        if (ConnectionDescriptor.passwordParameterName(this.parameterList.getSchema()) != null) {
            parameterListWithObfuscatedPassword.setParameter(ConnectionDescriptor.passwordParameterName(this.parameterList.getSchema()), this.obfuscate(this.parameterList.getParameterString(ConnectionDescriptor.passwordParameterName(this.parameterList.getSchema()))));
        }
        return new PersistentParameterList(parameterListWithObfuscatedPassword);
    }

    private String obfuscate(String s) {
        return s != null ? new SimpleStringEncrypter().encrypt(s) : null;
    }

    private String unobfuscate(String s) {
        return s != null ? new SimpleStringEncrypter().decrypt(s) : null;
    }

    public void setDataStoreDriverClassName(String dataStoreDriverClassName) {
        this.dataStoreDriverClassName = dataStoreDriverClassName;
    }

    public String getDataStoreDriverClassName() {
        return this.dataStoreDriverClassName;
    }

    public void setParameterList(ParameterList parameterList) {
        this.parameterList = parameterList;
    }

    public static String passwordParameterName(ParameterListSchema schema) {
        for (String name : Arrays.asList(schema.getNames())) {
            if (!name.equalsIgnoreCase("password")) continue;
            return name;
        }
        return null;
    }

    public static class PersistentParameterListSchema
    extends ParameterListSchema {
        public PersistentParameterListSchema() {
            super(new String[0], new Class[0]);
        }

        public PersistentParameterListSchema(ParameterListSchema schema) {
            this();
            this.initialize(schema.getNames(), schema.getClasses());
        }

        public List getPersistentNames() {
            return Arrays.asList(this.getNames());
        }

        public void addPersistentName(String name) {
            String[] newNames = new String[this.getNames().length + 1];
            System.arraycopy(this.getNames(), 0, newNames, 0, this.getNames().length);
            newNames[this.getNames().length] = name;
            this.initialize(newNames, this.getClasses());
        }

        public List getPersistentClasses() {
            return Arrays.asList(this.getClasses());
        }

        public void addPersistentClass(Class c) {
            Class[] newClasses = new Class[this.getClasses().length + 1];
            System.arraycopy(this.getClasses(), 0, newClasses, 0, this.getClasses().length);
            newClasses[this.getClasses().length] = c;
            this.initialize(this.getNames(), newClasses);
        }
    }

    public static class PersistentParameterList
    extends ParameterList {
        public PersistentParameterList() {
            super(new ParameterListSchema(new String[0], new Class[0]));
        }

        public PersistentParameterList(ParameterList parameterList) {
            this();
            this.setSchema(new PersistentParameterListSchema(parameterList.getSchema()));
            this.setNameToValueMap(PersistentParameterList.nameToValueMap(parameterList));
        }

        private static Map nameToValueMap(ParameterList parameterList) {
            HashMap<String, Object> nameToValueMap = new HashMap<String, Object>();
            for (String name : Arrays.asList(parameterList.getSchema().getNames())) {
                nameToValueMap.put(name, parameterList.getParameter(name));
            }
            return nameToValueMap;
        }

        public Map getNameToValueMap() {
            return PersistentParameterList.nameToValueMap(this);
        }

        public void setNameToValueMap(Map nameToValueMap) {
            for (String name : nameToValueMap.keySet()) {
                this.setParameter(name, nameToValueMap.get(name));
            }
        }

        public void setSchema(PersistentParameterListSchema schema) {
            this.initialize(schema);
        }
    }
}

