/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageFactory;
import java.util.Map;
import java.util.WeakHashMap;

public class ImageryLayerDataset {
    public static final String ATTR_GEOMETRY = "GEOMETRY";
    public static final String ATTR_FILE = "IMAGEFILE";
    public static final String ATTR_FORMAT = "IMAGEFORMAT";
    public static final String ATTR_ERROR = "IMAGEERROR";
    public static final String ATTR_TYPE = "IMAGETYPE";
    public static final String ATTR_FACTORY = "IMAGEFACT";
    public static FeatureSchema SCHEMA = new FeatureSchema(){
        {
            this.addAttribute(ImageryLayerDataset.ATTR_GEOMETRY, AttributeType.GEOMETRY);
            this.addAttribute(ImageryLayerDataset.ATTR_FILE, AttributeType.STRING);
            this.addAttribute(ImageryLayerDataset.ATTR_FORMAT, AttributeType.STRING);
            this.addAttribute(ImageryLayerDataset.ATTR_FACTORY, AttributeType.STRING);
            this.addAttribute(ImageryLayerDataset.ATTR_ERROR, AttributeType.STRING);
            this.addAttribute(ImageryLayerDataset.ATTR_TYPE, AttributeType.STRING);
        }
    };
    private Map featureToReferencedImageMap = new WeakHashMap();

    public static FeatureSchema getSchema() {
        return SCHEMA;
    }

    public void createImage(Feature feature) {
        String factoryClassPath = feature.getString(ATTR_FACTORY);
        String imageFilePath = feature.getString(ATTR_FILE);
        GeometryFactory geometryFactory = new GeometryFactory();
        try {
            ReferencedImageFactory imageFactory = (ReferencedImageFactory)Class.forName(factoryClassPath).newInstance();
            ReferencedImage referencedImage = imageFactory.createImage(imageFilePath);
            this.featureToReferencedImageMap.put(feature, referencedImage);
            Envelope env = referencedImage.getEnvelope();
            Geometry boundingBox = geometryFactory.toGeometry(env);
            feature.setGeometry(boundingBox);
            feature.setAttribute(ATTR_TYPE, (Object)referencedImage.getType());
        }
        catch (Exception e) {
            feature.setAttribute(ATTR_ERROR, (Object)e.toString());
            e.printStackTrace();
        }
    }

    public ReferencedImage referencedImage(Feature feature) {
        if (feature.getString(ATTR_ERROR) != null && !feature.getString(ATTR_ERROR).equals("")) {
            return null;
        }
        if (!this.featureToReferencedImageMap.containsKey(feature)) {
            this.createImage(feature);
        }
        return (ReferencedImage)this.featureToReferencedImageMap.get(feature);
    }
}

