/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.ecw;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.JUMPException;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.ecw.JNCSRendererProxy;
import com.vividsolutions.jump.workbench.ui.Viewport;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class ECWImage
implements ReferencedImage {
    private Envelope imageEnv = new Envelope();
    private JNCSRendererProxy renderer;
    private int[] bandlist;
    private boolean validSetView = false;
    private Envelope lastViewportEnv = new Envelope();

    public ECWImage(String location) throws JUMPException {
        this.init(location);
    }

    private void init(String location) throws JUMPException {
        try {
            this.renderer = new JNCSRendererProxy(location, false);
            double xm = this.renderer.getOriginX();
            double yM = this.renderer.getOriginY();
            double xM = xm + (double)this.renderer.getWidth() * this.renderer.getCellIncrementX();
            double ym = yM + (double)this.renderer.getHeight() * this.renderer.getCellIncrementY();
            this.imageEnv = new Envelope(xm, xM, ym, yM);
            this.bandlist = new int[this.renderer.getNumBands()];
            for (int i = 0; i < this.bandlist.length; ++i) {
                this.bandlist[i] = i;
            }
        }
        catch (Exception e) {
            throw new JUMPException(e.getMessage());
        }
    }

    public Envelope getEnvelope() {
        return this.imageEnv;
    }

    public void paint(Feature f, Graphics2D g, Viewport viewport) throws JUMPException {
        block7: {
            Envelope viewportEnv = viewport.getEnvelopeInModelCoordinates();
            if (!this.imageEnv.intersects(viewportEnv)) {
                return;
            }
            if (!viewportEnv.equals((Object)this.lastViewportEnv)) {
                this.validSetView = false;
                this.lastViewportEnv = viewportEnv;
            }
            try {
                int width = viewport.getPanel().getWidth();
                int height = viewport.getPanel().getHeight();
                double dWorldTLX = viewportEnv.getMinX();
                double dWorldTLY = viewportEnv.getMaxY();
                double dWorldBRX = viewportEnv.getMaxX();
                double dWorldBRY = viewportEnv.getMinY();
                if (this.validSetView) break block7;
                Point firstCell = this.renderer.convertWorldToDataset(dWorldTLX - this.renderer.getCellIncrementX() / 2.0, dWorldTLY - this.renderer.getCellIncrementY() / 2.0);
                int firstColumn = Math.max(0, firstCell.x);
                int firstLine = Math.max(0, firstCell.y);
                Point2D.Double tlCorner = this.renderer.convertDatasetToWorld(firstColumn, firstLine);
                Point lastCell = this.renderer.convertWorldToDataset(dWorldBRX - this.renderer.getCellIncrementX() / 2.0, dWorldBRY - this.renderer.getCellIncrementY() / 2.0);
                int lastColumn = Math.min(this.renderer.getWidth() - 1, lastCell.x + 1);
                int lastLine = Math.min(this.renderer.getHeight() - 1, lastCell.y + 1);
                Point2D.Double brCorner = this.renderer.convertDatasetToWorld(lastColumn + 1, lastLine + 1);
                Envelope finalEnvelope = new Envelope(tlCorner.x, brCorner.x, brCorner.y, tlCorner.y);
                int nbColumns = lastColumn - firstColumn + 1;
                int nbLines = lastLine - firstLine + 1;
                width = width <= nbColumns ? width : nbColumns;
                height = height <= nbLines ? height : nbLines;
                BufferedImage ecwImage = new BufferedImage(width, height, 1);
                int[] pRGBArray = new int[width];
                try {
                    this.renderer.setView(this.renderer.getNumBands(), this.bandlist, firstColumn, firstLine, lastColumn, lastLine, width, height);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                for (int line = 0; line < height; ++line) {
                    this.renderer.readLineRGBA(pRGBArray);
                    ecwImage.setRGB(0, line, width, 1, pRGBArray, 0, width);
                }
                Rectangle2D finalRect = viewport.toViewRectangle(finalEnvelope);
                g.drawImage(ecwImage, (int)finalRect.getMinX(), (int)finalRect.getMinY(), (int)finalRect.getMaxX(), (int)finalRect.getMaxY(), 0, 0, ecwImage.getWidth(), ecwImage.getHeight(), Color.WHITE, viewport.getPanel());
            }
            catch (Exception e) {
                this.validSetView = false;
                throw new JUMPException(e.getMessage());
            }
        }
    }

    public void close() {
        this.renderer.close(true);
    }

    public String getType() {
        return "ECW";
    }
}

