/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.geotiff;

import com.vividsolutions.jump.JUMPException;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageFactory;
import com.vividsolutions.jump.workbench.imagery.geotiff.GeoTIFFImage;

public class GeoTIFFImageFactory
implements ReferencedImageFactory {
    public static final String TYPE_NAME = "GeoTIFF";

    public String getTypeName() {
        return TYPE_NAME;
    }

    public ReferencedImage createImage(String location) throws JUMPException {
        return new GeoTIFFImage(location);
    }

    public String getDescription() {
        return "Geographically Registered Tagged Image File Format";
    }

    public String[] getExtensions() {
        return new String[]{"tif", "tiff"};
    }

    public boolean isEditableImage(String location) {
        return false;
    }

    public boolean isAvailable(WorkbenchContext context) {
        Class<?> c = null;
        try {
            c = this.getClass().getClassLoader().loadClass("javax.media.jai.JAI");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return c != null;
    }
}

