/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.geotiff;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.imagery.geotiff.GeoReferencedRaster;
import java.awt.geom.AffineTransform;
import java.util.List;
import org.geotiff.image.jai.GeoTIFFDescriptor;
import org.geotiff.image.jai.GeoTIFFDirectory;
import org.libtiff.jai.codec.XTIFFField;

public class GeoTIFFRaster
extends GeoReferencedRaster {
    private final String MSG_GENERAL = "This is not a valid GeoTIFF file.";
    String fileName;
    boolean hoPatch = false;

    public GeoTIFFRaster(String imageFileLocation) throws Exception {
        super(imageFileLocation);
        this.fileName = imageFileLocation;
        this.registerWithJAI();
        this.readRasterfile();
    }

    private void registerWithJAI() {
        GeoTIFFDescriptor.register();
    }

    private void parseGeoTIFFDirectory(GeoTIFFDirectory dir) throws Exception {
        XTIFFField fieldModelTiePoints = dir.getField(33922);
        if (fieldModelTiePoints == null) {
            throw new Exception("Missing tiepoints-tag in file.\nThis is not a valid GeoTIFF file.");
        }
        this.setCoorRasterTiff_tiepointLT(new Coordinate(fieldModelTiePoints.getAsDouble(0), fieldModelTiePoints.getAsDouble(1), 0.0));
        this.setCoorModel_tiepointLT(new Coordinate(fieldModelTiePoints.getAsDouble(3), fieldModelTiePoints.getAsDouble(4), 0.0));
        this.setEnvelope();
        XTIFFField fieldModelPixelScale = dir.getField(33550);
        if (fieldModelPixelScale == null) {
            throw new Exception("Missing pixelscale-tag in file.\nThis is not a valid GeoTIFF file.");
        }
        this.setDblModelUnitsPerRasterUnit_X(fieldModelPixelScale.getAsDouble(0));
        this.setDblModelUnitsPerRasterUnit_Y(fieldModelPixelScale.getAsDouble(1));
    }

    private String worldFileName() {
        int posDot = this.fileName.lastIndexOf(46);
        if (posDot == -1) {
            posDot = this.fileName.length();
        }
        return this.fileName.substring(0, posDot) + ".tfw";
    }

    private void parseWorldFile() throws Exception {
        String name = this.worldFileName();
        List lines = FileUtil.getContents(name);
        double[] tags = new double[6];
        for (int i = 0; i < 6; ++i) {
            String line = (String)lines.get(i);
            tags[i] = Double.parseDouble(line);
        }
        this.setCoorRasterTiff_tiepointLT(new Coordinate(0.0, 0.0));
        this.setCoorModel_tiepointLT(new Coordinate(0.0, 0.0));
        this.setAffineTransformation(new AffineTransform(tags));
    }

    protected void readRasterfile() throws Exception {
        super.readRasterfile();
        GeoTIFFDirectory dir = (GeoTIFFDirectory)this.src.getProperty("tiff.directory");
        if (dir == null) {
            throw new Exception("This is not a (geo)tiff file.");
        }
        try {
            this.parseGeoTIFFDirectory(dir);
        }
        catch (Exception E) {
            try {
                this.parseWorldFile();
            }
            catch (Exception e) {
                throw new Exception("Neither geotiff tags nor valid worldfile found.\nThis is not a valid GeoTIFF file.");
            }
        }
    }
}

