/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.graphic;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.graphic.WorldFile;
import com.vividsolutions.jump.workbench.ui.Viewport;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.File;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.FileLoadDescriptor;

public class GraphicImage
implements ReferencedImage {
    private File file;
    private WorldFile wf;
    private boolean initialload;
    private Envelope env;
    private String type = null;

    public GraphicImage(File file, WorldFile wf) {
        int i;
        this.wf = wf;
        this.file = file;
        this.initialload = true;
        if (wf == null) {
            this.wf = WorldFile.DEFAULT;
        }
        this.type = (i = file.getName().lastIndexOf(".")) > -1 && i < file.getName().length() ? file.getName().substring(i + 1).toUpperCase() : file.getName();
    }

    public Envelope getEnvelope() {
        if (this.env == null) {
            this.env = this.computeEnvelope();
        }
        return this.env;
    }

    private Envelope computeEnvelope() {
        RenderedOp image = null;
        if (!(this.file.exists() && this.file.isFile() && this.file.canRead())) {
            return new Envelope();
        }
        image = FileLoadDescriptor.create((String)this.file.getPath(), null, null, null);
        double xm = 0.0;
        double xM = (float)image.getWidth() * this.wf.getXSize();
        double ym = 0.0;
        double yM = (float)image.getHeight() * this.wf.getYSize();
        return new Envelope(xm += this.wf.getXUpperLeft(), xM += this.wf.getXUpperLeft(), ym += this.wf.getYUpperLeft(), yM += this.wf.getYUpperLeft());
    }

    public void paint(Feature f, Graphics2D g, Viewport viewport) {
        RenderedOp image = null;
        if (!(this.file.exists() && this.file.isFile() && this.file.canRead())) {
            return;
        }
        image = FileLoadDescriptor.create((String)this.file.getPath(), null, null, null);
        int jpgPixelWidth = image.getWidth();
        int jpgPixelHeight = image.getHeight();
        double jpg_xres = this.wf.getXSize();
        double jpg_ulx = f.getGeometry().getEnvelopeInternal().getMinX();
        double jpg_uly = f.getGeometry().getEnvelopeInternal().getMaxY();
        if (this.initialload) {
            if (this.wf.getFilename() != null) {
                jpg_xres = this.wf.getXSize();
                jpg_ulx = this.wf.getXUpperLeft();
                jpg_uly = this.wf.getYUpperLeft();
            }
            this.initialload = false;
        }
        int image_x = 0;
        int image_y = 0;
        int image_w = viewport.getPanel().getWidth();
        int image_h = viewport.getPanel().getHeight();
        Envelope vpEnvelope = viewport.getEnvelopeInModelCoordinates();
        double view_res = 1.0 / viewport.getScale();
        double rwViewLeft = vpEnvelope.getMinX();
        double rwViewRight = vpEnvelope.getMaxX();
        double rwViewTop = vpEnvelope.getMaxY();
        double rwViewBot = vpEnvelope.getMinY();
        double halfPixel = 0.5 * jpg_xres;
        double rwJpgFileLeftEdge = jpg_ulx - halfPixel;
        double rwJpgFileRightEdge = rwJpgFileLeftEdge + (double)jpgPixelWidth * jpg_xres;
        double rwJpgFileTopEdge = jpg_uly + halfPixel;
        double rwJpgFileBotEdge = rwJpgFileTopEdge - (double)jpgPixelHeight * jpg_xres;
        double rwRasterLeft = Math.max(rwViewLeft, rwJpgFileLeftEdge);
        double rwRasterRight = Math.min(rwViewRight, rwJpgFileRightEdge);
        double rwRasterTop = Math.min(rwViewTop, rwJpgFileTopEdge);
        double rwRasterBot = Math.max(rwViewBot, rwJpgFileBotEdge);
        if (!(rwJpgFileRightEdge <= rwViewLeft || rwJpgFileLeftEdge >= rwViewRight || rwJpgFileTopEdge <= rwViewBot || rwJpgFileBotEdge >= rwViewTop)) {
            int jpgLeftPixel = (int)((rwRasterLeft - rwJpgFileLeftEdge) / jpg_xres);
            int jpgRightPixel = (int)((rwRasterRight - rwJpgFileLeftEdge) / jpg_xres);
            if (jpgRightPixel == jpgPixelWidth) {
                jpgRightPixel = jpgPixelWidth - 1;
            }
            int jpgTopPixel = (int)((rwJpgFileTopEdge - rwRasterTop) / jpg_xres);
            int jpgBotPixel = (int)((rwJpgFileTopEdge - rwRasterBot) / jpg_xres);
            if (jpgBotPixel == jpgPixelHeight) {
                jpgBotPixel = jpgPixelHeight - 1;
            }
            double rwJpgLeft = rwJpgFileLeftEdge + (double)jpgLeftPixel * jpg_xres;
            double rwJpgRight = rwJpgFileLeftEdge + (double)jpgRightPixel * jpg_xres + jpg_xres;
            double rwJpgTop = rwJpgFileTopEdge - (double)jpgTopPixel * jpg_xres;
            double rwJpgBot = rwJpgFileTopEdge - (double)jpgBotPixel * jpg_xres - jpg_xres;
            int leftOffset = this.round((rwRasterLeft - rwJpgLeft) / view_res);
            int rightOffset = this.round((rwJpgRight - rwRasterRight) / view_res);
            int topOffset = this.round((rwJpgTop - rwRasterTop) / view_res);
            int botOffset = this.round((rwRasterBot - rwJpgBot) / view_res);
            image_x = this.round(rwRasterLeft / view_res) - this.round(rwViewLeft / view_res);
            image_w = this.round(rwRasterRight / view_res) - this.round(rwRasterLeft / view_res);
            if (image_w <= 0) {
                image_w = 1;
            }
            image_y = this.round(rwViewTop / view_res) - this.round(rwRasterTop / view_res);
            image_h = this.round(rwRasterTop / view_res) - this.round(rwRasterBot / view_res);
            if (image_h <= 0) {
                image_h = 1;
            }
            RenderingHints rh = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.setRenderingHints(rh);
            Composite composite = g.getComposite();
            g.setComposite(AlphaComposite.Src);
            g.drawImage(image.getAsBufferedImage(), image_x -= leftOffset, image_y, image_x + (image_w += leftOffset + rightOffset), (image_y -= topOffset) + (image_h += topOffset + botOffset), jpgLeftPixel, jpgTopPixel, jpgRightPixel + 1, jpgBotPixel + 1, viewport.getPanel());
            g.setComposite(composite);
        }
    }

    private int round(double num) {
        return (int)Math.round(num);
    }

    public String getType() {
        return this.type;
    }
}

