/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.graphic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class WorldFile {
    public static final WorldFile DEFAULT = new WorldFile();
    private String filename;
    private float xSize = 1.0f;
    private float ySize = -1.0f;
    private float rowRotation = 0.0f;
    private float colRotation = 0.0f;
    private double xUpperLeft = 0.0;
    private double yUpperLeft = 0.0;

    private WorldFile() {
    }

    public static WorldFile read(File file) throws IOException {
        FileReader fin = new FileReader(file);
        BufferedReader in = new BufferedReader(fin);
        String lineIn = in.readLine();
        WorldFile wf = new WorldFile();
        wf.filename = file.getPath();
        for (int line = 0; (in.ready() || lineIn != null) && line < 6; ++line) {
            if (lineIn != null && !"".equals(lineIn)) {
                switch (line) {
                    case 0: {
                        wf.xSize = Float.valueOf(lineIn.trim()).floatValue();
                        break;
                    }
                    case 1: {
                        wf.rowRotation = Float.valueOf(lineIn.trim()).floatValue();
                        break;
                    }
                    case 2: {
                        wf.colRotation = Float.valueOf(lineIn.trim()).floatValue();
                        break;
                    }
                    case 3: {
                        wf.ySize = Float.valueOf(lineIn.trim()).floatValue();
                        break;
                    }
                    case 4: {
                        wf.xUpperLeft = Double.valueOf(lineIn.trim());
                        break;
                    }
                    case 5: {
                        wf.yUpperLeft = Double.valueOf(lineIn.trim());
                    }
                }
            }
            lineIn = null;
            if (!in.ready()) continue;
            lineIn = in.readLine();
        }
        return wf;
    }

    public float getColRotation() {
        return this.colRotation;
    }

    public String getFilename() {
        return this.filename;
    }

    public float getRowRotation() {
        return this.rowRotation;
    }

    public float getXSize() {
        return this.xSize;
    }

    public double getXUpperLeft() {
        return this.xUpperLeft;
    }

    public float getYSize() {
        return this.ySize;
    }

    public double getYUpperLeft() {
        return this.yUpperLeft;
    }
}

