/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.Task;

public abstract class AbstractLayerable
implements Layerable {
    private LayerManager layerManager;
    private String name;
    private boolean visible = true;
    private boolean scaleDependentRenderingEnabled = false;
    private Double minScale = null;
    private Double maxScale = null;

    public AbstractLayerable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractLayerable(String name, LayerManager layerManager) {
        Assert.isTrue((name != null ? 1 : 0) != 0);
        Assert.isTrue((layerManager != null ? 1 : 0) != 0);
        this.setLayerManager(layerManager);
        boolean firingEvents = layerManager.isFiringEvents();
        layerManager.setFiringEvents(false);
        try {
            this.setName(layerManager.uniqueLayerName(name));
        }
        finally {
            layerManager.setFiringEvents(firingEvents);
        }
    }

    public void setLayerManager(LayerManager layerManager) {
        this.layerManager = layerManager;
    }

    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    public void fireLayerChanged(LayerEventType type) {
        if (this.getLayerManager() == null) {
            return;
        }
        this.getLayerManager().fireLayerChanged(this, type);
    }

    public void fireAppearanceChanged() {
        this.fireLayerChanged(LayerEventType.APPEARANCE_CHANGED);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fireLayerChanged(LayerEventType.METADATA_CHANGED);
    }

    public Task getTask() {
        if (this.layerManager != null) {
            return this.layerManager.getTask();
        }
        return null;
    }

    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.visible = visible;
        this.fireLayerChanged(LayerEventType.VISIBILITY_CHANGED);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String toString() {
        return this.getName();
    }

    public Double getMaxScale() {
        return this.maxScale;
    }

    public Layerable setMaxScale(Double maxScale) {
        if (LangUtil.bothNullOrEqual(this.maxScale, maxScale)) {
            return this;
        }
        this.maxScale = maxScale;
        this.fireAppearanceChanged();
        return this;
    }

    public Double getMinScale() {
        return this.minScale;
    }

    public Layerable setMinScale(Double minScale) {
        if (LangUtil.bothNullOrEqual(this.minScale, minScale)) {
            return this;
        }
        this.minScale = minScale;
        this.fireAppearanceChanged();
        return this;
    }

    public boolean isScaleDependentRenderingEnabled() {
        return this.scaleDependentRenderingEnabled;
    }

    public Layerable setScaleDependentRenderingEnabled(boolean scaleDependentRenderingEnabled) {
        if (this.scaleDependentRenderingEnabled == scaleDependentRenderingEnabled) {
            return this;
        }
        this.scaleDependentRenderingEnabled = scaleDependentRenderingEnabled;
        this.fireAppearanceChanged();
        return this;
    }
}

