/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Task
implements LayerManagerProxy {
    private String name = "";
    private Point taskWindowLocation = null;
    private Dimension taskWindowSize = null;
    private boolean maximized = false;
    private Envelope savedViewEnvelope = null;
    private LayerManager layerManager;
    private List<NameListener> nameListeners = new ArrayList<NameListener>();
    private File projectFile = null;
    private Map<QName, Object> properties = new HashMap<QName, Object>();
    private double left = 0.0;
    private double right = 0.0;
    private double bottom = 0.0;
    private double top = 0.0;

    public Task() {
        this.layerManager = new LayerManager(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fireNameChanged(name);
    }

    public void add(NameListener nameListener) {
        this.nameListeners.add(nameListener);
    }

    private void fireNameChanged(String name) {
        for (NameListener nameListener : this.nameListeners) {
            nameListener.taskNameChanged(name);
        }
    }

    public File getProjectFile() {
        return this.projectFile;
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    @Override
    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    public Collection<Category> getCategories() {
        return this.getLayerManager().getCategories();
    }

    public void addCategory(Category category) {
        this.getLayerManager().addCategory(category.getName());
        Category actual = this.getLayerManager().getCategory(category.getName());
        for (Layerable layerable : category.getLayerables()) {
            actual.addPersistentLayerable(layerable);
        }
    }

    public void setProperty(QName name, Object value) {
        this.properties.put(name, value);
    }

    public <T> T getProperty(QName name) {
        return (T)this.properties.get(name);
    }

    public Map<QName, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<QName, Object> properties) {
        this.properties.putAll(properties);
    }

    public String toString() {
        return this.getName();
    }

    public Point getTaskWindowLocation() {
        return this.taskWindowLocation;
    }

    public int getTaskWindowLocationX() {
        return this.taskWindowLocation.x;
    }

    public int getTaskWindowLocationY() {
        return this.taskWindowLocation.y;
    }

    public void setTaskWindowLocation(Point taskWindowLocation) {
        this.taskWindowLocation = taskWindowLocation;
    }

    public void setTaskWindowLocationX(String x) {
        if (this.taskWindowLocation == null) {
            this.taskWindowLocation = new Point();
        }
        this.taskWindowLocation.x = Integer.valueOf(x);
    }

    public void setTaskWindowLocationY(String y) {
        if (this.taskWindowLocation == null) {
            this.taskWindowLocation = new Point();
        }
        this.taskWindowLocation.y = Integer.valueOf(y);
    }

    public Dimension getTaskWindowSize() {
        return this.taskWindowSize;
    }

    public int getTaskWindowSizeWidth() {
        return this.taskWindowSize.width;
    }

    public int getTaskWindowSizeHeight() {
        return this.taskWindowSize.height;
    }

    public void setTaskWindowSize(Dimension taskWindowSize) {
        this.taskWindowSize = taskWindowSize;
    }

    public void setTaskWindowSizeWidth(String width) {
        if (this.taskWindowSize == null) {
            this.taskWindowSize = new Dimension();
        }
        this.taskWindowSize.width = Integer.valueOf(width);
    }

    public void setTaskWindowSizeHeight(String height) {
        if (this.taskWindowSize == null) {
            this.taskWindowSize = new Dimension();
        }
        this.taskWindowSize.height = Integer.valueOf(height);
    }

    public boolean getMaximized() {
        return this.maximized;
    }

    public void setMaximized(boolean isMaximized) {
        this.maximized = isMaximized;
    }

    public Envelope getSavedViewEnvelope() {
        return this.savedViewEnvelope;
    }

    public double getTaskWindowZoomLeft() {
        return this.savedViewEnvelope.getMinX();
    }

    public double getTaskWindowZoomRight() {
        return this.savedViewEnvelope.getMaxX();
    }

    public double getTaskWindowZoomBottom() {
        return this.savedViewEnvelope.getMinY();
    }

    public double getTaskWindowZoomTop() {
        return this.savedViewEnvelope.getMaxY();
    }

    public void setSavedViewEnvelope(Envelope savedViewEnvelope) {
        this.savedViewEnvelope = savedViewEnvelope;
    }

    public void setTaskWindowZoomLeft(String left) {
        this.left = Double.valueOf(left);
    }

    public void setTaskWindowZoomRight(String right) {
        this.right = Double.valueOf(right);
    }

    public void setTaskWindowZoomBottom(String bottom) {
        this.bottom = Double.valueOf(bottom);
    }

    public void setTaskWindowZoomTop(String top) {
        this.top = Double.valueOf(top);
        this.savedViewEnvelope = new Envelope(this.left, this.right, this.top, this.bottom);
    }

    public static interface NameListener {
        public void taskNameChanged(String var1);
    }
}

