/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.LayerNameRenderer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import com.vividsolutions.wms.BoundingBox;
import com.vividsolutions.wms.MapRequest;
import com.vividsolutions.wms.WMService;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSLayer
extends AbstractLayerable
implements Cloneable {
    private String format;
    private List<String> layerNames = new ArrayList<String>();
    private String srs;
    private int alpha = 255;
    private WMService service;
    protected Envelope totalBounds = new Envelope();
    private String wmsVersion = "1.0.0";
    protected Reference oldImage;
    protected URL oldURL;
    private Blackboard blackboard = new Blackboard();
    private String serverURL;

    public WMSLayer() {
        this.init();
    }

    public WMSLayer(LayerManager layerManager, String serverURL, String srs, List layerNames, String format, String version) throws IOException {
        this(layerManager, WMSLayer.initializedService(serverURL, version), srs, layerNames, format);
    }

    private static WMService initializedService(String serverURL, String version) throws IOException {
        WMService initializedService = new WMService(serverURL, version);
        initializedService.initialize();
        return initializedService;
    }

    public WMSLayer(LayerManager layerManager, WMService initializedService, String srs, List layerNames, String format) throws IOException {
        this(layerManager, initializedService, srs, (List<String>)layerNames, format, initializedService.getVersion());
    }

    public WMSLayer(String title, LayerManager layerManager, WMService initializedService, String srs, List<String> layerNames, String format) throws IOException {
        this(title, layerManager, initializedService, srs, layerNames, format, initializedService.getVersion());
    }

    public WMSLayer(String title, LayerManager layerManager, WMService initializedService, String srs, List<String> layerNames, String format, String version) {
        super(title, layerManager);
        this.setService(initializedService);
        this.setSRS(srs);
        this.layerNames = new ArrayList<String>(layerNames);
        this.setFormat(format);
        this.init();
        this.wmsVersion = version;
    }

    public WMSLayer(LayerManager layerManager, WMService initializedService, String srs, List<String> layerNames, String format, String version) {
        this(layerNames.get(0), layerManager, initializedService, srs, layerNames, format, version);
    }

    protected void init() {
        this.getBlackboard().put(RenderingManager.USE_MULTI_RENDERING_THREAD_QUEUE_KEY, true);
        this.getBlackboard().put(LayerNameRenderer.USE_CLOCK_ANIMATION_KEY, true);
    }

    private void setService(WMService service) {
        this.service = service;
        this.serverURL = service.getServerUrl();
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public Image createImage(LayerViewPanel panel) throws IOException {
        Image image;
        MapRequest request = this.createRequest(panel);
        URL newURL = request.getURL();
        if (this.oldURL == null || !newURL.equals(this.oldURL) || this.oldImage == null || (image = (Image)this.oldImage.get()) == null) {
            image = request.getImage();
            MediaTracker mt = new MediaTracker(new JButton());
            mt.addImage(image, 0);
            try {
                mt.waitForID(0);
            }
            catch (InterruptedException e) {
                Assert.shouldNeverReachHere();
            }
            this.oldImage = new SoftReference<Image>(image);
            this.oldURL = newURL;
        }
        return image;
    }

    private BoundingBox toBoundingBox(String srs, Envelope e) {
        return new BoundingBox(srs, e.getMinX(), e.getMinY(), e.getMaxX(), e.getMaxY());
    }

    public MapRequest createRequest(LayerViewPanel panel) throws IOException {
        MapRequest request = this.getService().createMapRequest();
        request.setBoundingBox(this.toBoundingBox(this.srs, panel.getViewport().getEnvelopeInModelCoordinates()));
        request.setFormat(this.format);
        request.setImageWidth(panel.getWidth());
        request.setImageHeight(panel.getHeight());
        request.setLayers(this.layerNames);
        request.setTransparent(true);
        return request;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void addLayerName(String layerName) {
        this.layerNames.add(layerName);
    }

    public List<String> getLayerNames() {
        return Collections.unmodifiableList(this.layerNames);
    }

    public void setSRS(String srs) {
        this.srs = srs;
    }

    public String getSRS() {
        return this.srs;
    }

    public Object clone() throws CloneNotSupportedException {
        WMSLayer clone = (WMSLayer)super.clone();
        clone.layerNames = new ArrayList<String>(this.layerNames);
        return clone;
    }

    public void removeAllLayerNames() {
        this.layerNames.clear();
    }

    @Override
    public Blackboard getBlackboard() {
        return this.blackboard;
    }

    public WMService getService() throws IOException {
        if (this.service == null) {
            Assert.isTrue((this.serverURL != null ? 1 : 0) != 0);
            this.setService(WMSLayer.initializedService(this.serverURL, this.wmsVersion));
        }
        return this.service;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public String getWmsVersion() {
        return this.wmsVersion;
    }

    public void setWmsVersion(String wmsVersion) {
        this.wmsVersion = wmsVersion;
    }

    public Envelope getEnvelope() {
        return this.totalBounds;
    }
}

