/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model.cache;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.Block;
import com.vividsolutions.jump.util.LazyList;
import com.vividsolutions.jump.util.ListWrapper;
import com.vividsolutions.jump.workbench.model.cache.ThreadSafeFeatureCollectionWrapper;
import com.vividsolutions.jump.workbench.ui.plugin.AddNewLayerPlugIn;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;

public class CachingFeatureCollection
extends FeatureCollectionWrapper {
    private Envelope envelopeOfCompletedCache = new Envelope();
    private FeatureCollection featureCollection;
    private boolean cachingByEnvelope = true;
    private boolean initialized = false;

    public CachingFeatureCollection(FeatureCollection featureCollection) {
        super(AddNewLayerPlugIn.createBlankFeatureCollection());
        this.featureCollection = featureCollection;
    }

    public Envelope getEnvelope() {
        try {
            Envelope e = this.featureCollection.getEnvelope();
            if (e != null) {
                return e;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return super.getEnvelope();
    }

    public FeatureSchema getFeatureSchema() {
        return this.featureCollection.getFeatureSchema();
    }

    public List query(final Envelope envelope) {
        final LazyList cachedFeatureCollectionQueryResults = new LazyList(new Block(){

            public Object yield() {
                return CachingFeatureCollection.this.getCachedFeatureCollection().query(envelope);
            }
        });
        return new ListWrapper(){

            public Collection getCollection() {
                return cachedFeatureCollectionQueryResults;
            }

            public Iterator iterator() {
                if (CachingFeatureCollection.this.cachingByEnvelope && CachingFeatureCollection.this.envelopeOfCompletedCache.contains(envelope)) {
                    return super.iterator();
                }
                if (SwingUtilities.isEventDispatchThread()) {
                    return super.iterator();
                }
                final Iterator iterator = CachingFeatureCollection.this.featureCollection.query(envelope).iterator();
                CachingFeatureCollection.this.initializeCacheIfNecessary();
                CachingFeatureCollection.this.emptyCache();
                CachingFeatureCollection.this.envelopeOfCompletedCache = new Envelope();
                return new Iterator(){

                    public void remove() {
                        iterator.remove();
                    }

                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    public Object next() {
                        Feature nextFeature = (Feature)iterator.next();
                        CachingFeatureCollection.this.getCachedFeatureCollection().add(nextFeature);
                        if (!this.hasNext()) {
                            CachingFeatureCollection.this.envelopeOfCompletedCache = new Envelope(envelope);
                        }
                        return nextFeature;
                    }
                };
            }
        };
    }

    private void initializeCacheIfNecessary() {
        if (this.initialized) {
            return;
        }
        this.setCachedFeatureCollection(new ThreadSafeFeatureCollectionWrapper(new FeatureDataset(this.featureCollection.getFeatureSchema())));
        this.initialized = true;
    }

    private FeatureCollection getCachedFeatureCollection() {
        return this.getFeatureCollection();
    }

    private void setCachedFeatureCollection(FeatureCollection cachedFeatureCollection) {
        this.setFeatureCollection(cachedFeatureCollection);
    }

    public CachingFeatureCollection setCachingByEnvelope(boolean cachingByEnvelope) {
        this.cachingByEnvelope = cachingByEnvelope;
        return this;
    }

    public void emptyCache() {
        this.getCachedFeatureCollection().clear();
        this.envelopeOfCompletedCache = new Envelope();
    }
}

