/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.registry;

import com.vividsolutions.jump.util.CollectionMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Registry {
    private CollectionMap classificationToEntriesMap = new CollectionMap();
    private Map typeMap = new HashMap();

    public Registry createEntry(Object classification, Object entry) throws ClassCastException {
        Class c = (Class)this.typeMap.get(classification);
        if (c != null && !c.isInstance(entry)) {
            throw new ClassCastException("Cannot Cast '" + entry + "' into " + c.getName() + " for classification '" + classification + "'");
        }
        this.classificationToEntriesMap.addItem(classification, entry);
        return this;
    }

    public Registry createEntries(Object classification, Collection entries) throws ClassCastException {
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            this.createEntry(classification, i.next());
        }
        return this;
    }

    public List getEntries(Object classification) {
        return new ArrayList(this.classificationToEntriesMap.getItems(classification));
    }

    public Registry createClassification(Object classification, Class type) throws ClassCastException {
        Collection c;
        if (this.classificationToEntriesMap.containsKey(classification) && (c = this.classificationToEntriesMap.getItems(classification)) != null) {
            for (Object entry : c) {
                if (type.isInstance(entry)) continue;
                throw new ClassCastException("Cannot Cast '" + entry + "' into " + type.getName() + " for classification '" + classification + "'");
            }
        }
        this.typeMap.put(classification, type);
        return this;
    }
}

