/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.JUMPVersion;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.ExtensionsAboutPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.SplashPanel;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class AboutDialog
extends JDialog {
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    private JTabbedPane jTabbedPane1 = new JTabbedPane();
    private JPanel infoPanel = new JPanel();
    private BorderLayout borderLayout3 = new BorderLayout();
    private JScrollPane aboutScroll;
    private JLabel lblJavaVersion;
    private JLabel lblFreeMemory;
    private JLabel lblTotalMemory;
    private JLabel lblOSVersion;
    private JLabel lblCommittedMemory;
    private JPanel pnlButtons = new JPanel();
    private JButton btnGC = new JButton();
    private SplashPanel splashPanel;
    private WorkbenchContext wbc;
    private ExtensionsAboutPanel extensionsAboutPanel = new ExtensionsAboutPanel();

    public static AboutDialog instance(WorkbenchContext context) {
        String INSTANCE_KEY = AboutDialog.class.getName() + " - INSTANCE";
        AboutDialog aboutDialog = new AboutDialog(context.getWorkbench().getFrame());
        context.getWorkbench().getBlackboard().put(INSTANCE_KEY, aboutDialog);
        GUIUtil.centreOnWindow(aboutDialog);
        return (AboutDialog)context.getWorkbench().getBlackboard().get(INSTANCE_KEY);
    }

    private AboutDialog(WorkbenchFrame frame) {
        super(frame, I18N.get("ui.AboutDialog.about-jump"), true);
        this.wbc = frame.getContext().getWorkbench().getContext();
        this.extensionsAboutPanel.setPlugInManager(frame.getContext().getWorkbench().getPlugInManager());
        this.splashPanel = new SplashPanel(JUMPWorkbench.splashImage(), I18N.get("ui.AboutDialog.version") + " " + JUMPVersion.CURRENT_VERSION);
        try {
            this.jbInit();
            this.pack();
            this.addComponentListener(new ResizeMe());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        String result;
        this.setMinimumSize(new Dimension(200, 200));
        Border border_0 = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        this.getContentPane().setLayout(this.borderLayout2);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.okButton_actionPerformed(e);
            }
        });
        this.infoPanel.setLayout(this.borderLayout3);
        this.infoPanel.setLayout(new GridBagLayout());
        JLabel lbl_sysinfo = this.createLabel(I18N.get("ui.AboutDialog.system-info"));
        lbl_sysinfo.setFont(lbl_sysinfo.getFont().deriveFont(3, 12.0f));
        lbl_sysinfo.setHorizontalAlignment(2);
        this.panelAdd(lbl_sysinfo, this.infoPanel, 0, 0, 10);
        JLabel lbl_java = this.createLabel(I18N.get("ui.AboutDialog.java-version"));
        lbl_java.setFont(lbl_java.getFont().deriveFont(2));
        this.panelAdd(lbl_java, this.infoPanel, 1, 0, 17);
        JLabel lbl_os = this.createLabel(I18N.get("ui.AboutDialog.os"));
        lbl_os.setFont(lbl_java.getFont());
        this.panelAdd(lbl_os, this.infoPanel, 1, 1, 17);
        JLabel lbl_memtotal = this.createLabel(I18N.get("ui.AboutDialog.total-memory"));
        lbl_memtotal.setFont(lbl_java.getFont());
        this.panelAdd(lbl_memtotal, this.infoPanel, 1, 2, 17);
        JLabel lbl_memcom = this.createLabel(I18N.get("ui.AboutDialog.comitted-memory"));
        lbl_memcom.setFont(lbl_java.getFont());
        this.panelAdd(lbl_memcom, this.infoPanel, 1, 3, 17);
        JLabel lbl_memfree = this.createLabel(I18N.get("ui.AboutDialog.free-memory"));
        lbl_memfree.setFont(lbl_java.getFont());
        this.panelAdd(lbl_memfree, this.infoPanel, 1, 4, 17);
        this.lblJavaVersion = new JLabel();
        this.lblJavaVersion.setToolTipText("");
        this.lblJavaVersion.setText("x");
        this.panelAdd(this.lblJavaVersion, this.infoPanel, 2, 0, 17);
        this.lblOSVersion = new JLabel();
        this.lblOSVersion.setText("x");
        this.panelAdd(this.lblOSVersion, this.infoPanel, 2, 1, 17);
        this.lblTotalMemory = new JLabel();
        this.lblTotalMemory.setText("x");
        this.panelAdd(this.lblTotalMemory, this.infoPanel, 2, 2, 17);
        this.lblCommittedMemory = new JLabel();
        this.lblCommittedMemory.setText("x");
        this.panelAdd(this.lblCommittedMemory, this.infoPanel, 2, 3, 17);
        this.lblFreeMemory = new JLabel();
        this.lblFreeMemory.setToolTipText("");
        this.lblFreeMemory.setText("x");
        this.panelAdd(this.lblFreeMemory, this.infoPanel, 2, 4, 17);
        this.btnGC.setText(I18N.get("ui.AboutDialog.garbage-collect"));
        this.btnGC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.btnGC_actionPerformed(e);
            }
        });
        this.infoPanel.add((Component)this.pnlButtons, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlButtons.add((Component)this.btnGC, null);
        JPanel aboutPanel = new JPanel();
        aboutPanel.setLayout(new GridBagLayout());
        aboutPanel.add((Component)this.splashPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        try {
            URL url = ClassLoader.getSystemResource("readme.txt");
            if (url == null) {
                throw new FileNotFoundException("readme.txt missing in ojhome/.");
            }
            FileInputStream file = new FileInputStream(URLDecoder.decode(url.getFile(), "utf-8"));
            DataInputStream in = new DataInputStream(file);
            byte[] b = new byte[in.available()];
            in.readFully(b);
            in.close();
            result = new String(b, 0, b.length, "ISO-8859-1");
        }
        catch (Exception e) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < e.getStackTrace().length; ++i) {
                buf.append(e.getStackTrace()[i] + "\n");
            }
            result = e + "\n\n" + buf;
        }
        JTextArea readme = new JTextArea(result);
        readme.setFont(new JLabel().getFont().deriveFont(12.0f));
        readme.setEditable(false);
        readme.setAutoscrolls(false);
        aboutPanel.add((Component)readme, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(20, 0, 0, 0), 0, 0));
        this.aboutScroll = new JScrollPane();
        this.aboutScroll.getViewport().add(aboutPanel);
        this.aboutScroll.setHorizontalScrollBarPolicy(32);
        this.aboutScroll.setVerticalScrollBarPolicy(20);
        int app_h = this.splashPanel.getPreferredSize().height + 180;
        this.aboutScroll.setPreferredSize(new Dimension(this.splashPanel.getPreferredSize().width + 25, app_h));
        this.jTabbedPane1.add((Component)this.aboutScroll, I18N.get("ui.AboutDialog.about"));
        this.jTabbedPane1.addTab(I18N.get("ui.AboutDialog.info"), this.infoPanel);
        this.jTabbedPane1.addTab(I18N.get("ui.AboutDialog.Extensions"), this.extensionsAboutPanel);
        this.getContentPane().add((Component)this.jTabbedPane1, "North");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.okButton, null);
        this.jTabbedPane1.setBounds(0, 0, 0, 0);
        int w = this.getContentPane().getWidth() + (this.aboutScroll.getPreferredSize().width - this.getContentPane().getWidth());
        this.setMinimumSize(new Dimension(w, 300));
    }

    private void panelAdd(Component comp, JPanel panel, int cellx, int celly, int position) {
        panel.add(comp, new GridBagConstraints(cellx, celly, 1, 1, 0.0, 0.0, position, 0, new Insets(0, 10, 0, 10), 0, 0));
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return label;
    }

    public void setVisible(boolean b) {
        if (b) {
            DecimalFormat format = new DecimalFormat("###,###");
            this.lblJavaVersion.setText(System.getProperty("java.version"));
            this.lblOSVersion.setText(System.getProperty("os.name") + " (" + System.getProperty("os.version") + ")");
            long totalMem = Runtime.getRuntime().totalMemory();
            long freeMem = Runtime.getRuntime().freeMemory();
            this.lblTotalMemory.setText(format.format(totalMem) + " bytes");
            this.lblCommittedMemory.setText(format.format(totalMem - freeMem) + " bytes");
            this.lblFreeMemory.setText(format.format(freeMem) + " bytes");
        }
        super.setVisible(b);
    }

    void okButton_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    void btnGC_actionPerformed(ActionEvent e) {
        Runtime.getRuntime().gc();
        this.setVisible(true);
    }

    class ResizeMe
    extends ComponentAdapter {
        Dimension minSize;
        Rectangle bounds;

        ResizeMe() {
            this.minSize = AboutDialog.this.getMinimumSize();
            this.bounds = AboutDialog.this.getBounds();
        }

        public void componentResized(ComponentEvent evt) {
            int oldX = this.bounds.x;
            int oldY = this.bounds.y;
            int oldHeight = this.bounds.height;
            int oldWidth = this.bounds.width;
            int newX = AboutDialog.this.getX();
            int newY = AboutDialog.this.getY();
            int newWidth = AboutDialog.this.getWidth();
            int newHeight = AboutDialog.this.getHeight();
            if (newHeight < this.minSize.height || AboutDialog.this.getWidth() != oldWidth) {
                int diff = this.minSize.height - newHeight;
                if (diff > 0 && newY != oldY) {
                    newY -= diff;
                }
                AboutDialog.this.setBounds(oldX, newY, oldWidth, newHeight += Math.max(0, diff));
            }
            this.bounds.setBounds(oldX, newY, oldWidth, newHeight);
            Dimension scold = AboutDialog.this.aboutScroll.getPreferredSize();
            AboutDialog.this.aboutScroll.setPreferredSize(new Dimension(scold.width, scold.height + (newHeight - oldHeight)));
            AboutDialog.this.aboutScroll.revalidate();
        }

        public void componentMoved(ComponentEvent evt) {
            if (AboutDialog.this.getWidth() != this.bounds.width || AboutDialog.this.getHeight() != this.bounds.height) {
                AboutDialog.this.setBounds(this.bounds);
                return;
            }
            this.bounds.setLocation(AboutDialog.this.getX(), AboutDialog.this.getY());
        }
    }
}

