/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AttributePanel;
import com.vividsolutions.jump.workbench.ui.AttributeTablePanel;
import com.vividsolutions.jump.workbench.ui.EnableableToolBar;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.InfoModel;
import com.vividsolutions.jump.workbench.ui.InfoModelListener;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelListener;
import com.vividsolutions.jump.workbench.ui.LayerTableModel;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.TreeLayerNamePanel;
import com.vividsolutions.jump.workbench.ui.cursortool.FeatureInfoTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInfoPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AttributeTab
extends JPanel
implements LayerNamePanel {
    private BorderLayout borderLayout1 = new BorderLayout();
    private ErrorHandler errorHandler;
    private TaskFrame taskFrame;
    private LayerManagerProxy layerManagerProxy;
    private EnableCheck taskFrameEnableCheck = new EnableCheck(){

        public String check(JComponent component) {
            return !AttributeTab.this.taskFrame.isVisible() ? I18N.get("ui.AttributeTab.task-frame-must-be-open") : null;
        }
    };
    private EnableCheck layersEnableCheck = new EnableCheck(){

        public String check(JComponent component) {
            return AttributeTab.this.panel.getModel().getLayers().isEmpty() ? I18N.get("ui.AttributeTab.one-or-more-layers-must-be-present") : null;
        }
    };
    private AttributePanel panel;
    private JScrollPane scrollPane = new JScrollPane();
    private EnableCheck rowsSelectedEnableCheck = new EnableCheck(){

        public String check(JComponent component) {
            return AttributeTab.this.panel.selectedFeatures().isEmpty() ? I18N.get("ui.AttributeTab.one-or-more-rows-must-be-selected") : null;
        }
    };
    private EnableableToolBar toolBar = new EnableableToolBar();
    private InfoModel model;
    private Layer[] selectedLayers = new Layer[0];
    private Layer[] lastSelectedLayers = new Layer[0];

    public InfoModel getModel() {
        return this.model;
    }

    public AttributeTab(InfoModel model, final WorkbenchContext workbenchContext, TaskFrame taskFrame, LayerManagerProxy layerManagerProxy, boolean addScrollPanesToChildren) {
        this.layerManagerProxy = layerManagerProxy;
        this.model = model;
        this.taskFrame = taskFrame;
        taskFrame.addInternalFrameListener(GUIUtil.toInternalFrameListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributeTab.this.toolBar.updateEnabledState();
            }
        }));
        this.panel = new AttributePanel(model, workbenchContext, taskFrame, layerManagerProxy, addScrollPanesToChildren){

            public void layerAdded(LayerTableModel layerTableModel) {
                super.layerAdded(layerTableModel);
                final AttributeTablePanel tablePanel = this.getTablePanel(layerTableModel.getLayer());
                MouseAdapter mouseListener = new MouseAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void mouseReleased(MouseEvent e) {
                        if (!SwingUtilities.isRightMouseButton(e)) {
                            return;
                        }
                        AttributeTab.popupMenu(workbenchContext).setTitle(tablePanel.getModel().getLayer().getName());
                        AttributeTab.access$302(AttributeTab.this, new Layer[]{tablePanel.getModel().getLayer()});
                        AttributeTab.setEnableLastSelectedLayers(true, AttributeTab.this);
                        try {
                            AttributeTab.popupMenu(workbenchContext).show(tablePanel.getLayerNameRenderer(), e.getX(), e.getY());
                        }
                        finally {
                            AttributeTab.setEnableLastSelectedLayers(false, AttributeTab.this);
                        }
                    }
                };
                tablePanel.addMouseListener(mouseListener);
                tablePanel.getTable().addMouseListener(mouseListener);
                tablePanel.getTable().getTableHeader().addMouseListener(mouseListener);
                tablePanel.getLayerNameRenderer().addMouseListener(mouseListener);
            }
        };
        layerManagerProxy.getLayerManager().addLayerListener(new LayerListener(){

            public void featuresChanged(FeatureEvent e) {
            }

            public void layerChanged(LayerEvent e) {
                if (e.getType() == LayerEventType.METADATA_CHANGED) {
                    AttributeTab.this.toolBar.updateEnabledState();
                }
            }

            public void categoryChanged(CategoryEvent e) {
            }
        });
        model.addListener(new InfoModelListener(){

            public void layerAdded(LayerTableModel layerTableModel) {
                AttributeTab.this.panel.getTablePanel(layerTableModel.getLayer()).getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    public void valueChanged(ListSelectionEvent e) {
                        AttributeTab.this.toolBar.updateEnabledState();
                    }
                });
                AttributeTab.this.toolBar.updateEnabledState();
            }

            public void layerRemoved(LayerTableModel layerTableModel) {
                AttributeTab.this.toolBar.updateEnabledState();
            }
        });
        this.errorHandler = workbenchContext.getErrorHandler();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.initScrollPane();
        if (addScrollPanesToChildren) {
            this.remove(this.scrollPane);
            this.add((Component)this.panel, "Center");
        }
        this.installToolBarButtons(workbenchContext, taskFrame);
        this.toolBar.updateEnabledState();
    }

    private void installToolBarButtons(WorkbenchContext workbenchContext, final TaskFrame taskFrame) {
        this.toolBar.add(new JButton(), I18N.get("ui.AttributeTab.pan-to-previous-row"), IconLoader.icon("SmallUp.gif"), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    AttributeTab.this.pan(AttributeTab.this.panel.topSelectedRow().previousRow());
                }
                catch (Throwable t) {
                    AttributeTab.this.errorHandler.handleThrowable(t);
                }
            }
        }, new MultiEnableCheck().add(this.taskFrameEnableCheck).add(this.layersEnableCheck));
        this.toolBar.add(new JButton(), I18N.get("ui.AttributeTab.zoom-to-previous-row"), IconLoader.icon("SmallMagnifyUp.gif"), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    AttributeTab.this.zoom(AttributeTab.this.panel.topSelectedRow().previousRow());
                }
                catch (Throwable t) {
                    AttributeTab.this.errorHandler.handleThrowable(t);
                }
            }
        }, new MultiEnableCheck().add(this.taskFrameEnableCheck).add(this.layersEnableCheck));
        this.toolBar.add(new JButton(), I18N.get("ui.AttributeTab.zoom-to-next-row"), IconLoader.icon("SmallMagnifyDown.gif"), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    AttributeTab.this.zoom(AttributeTab.this.panel.topSelectedRow().nextRow());
                }
                catch (Throwable t) {
                    AttributeTab.this.errorHandler.handleThrowable(t);
                }
            }
        }, new MultiEnableCheck().add(this.taskFrameEnableCheck).add(this.layersEnableCheck));
        this.toolBar.add(new JButton(), I18N.get("ui.AttributeTab.pan-to-next-row"), IconLoader.icon("SmallDown.gif"), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    AttributeTab.this.pan(AttributeTab.this.panel.topSelectedRow().nextRow());
                }
                catch (Throwable t) {
                    AttributeTab.this.errorHandler.handleThrowable(t);
                }
            }
        }, new MultiEnableCheck().add(this.taskFrameEnableCheck).add(this.layersEnableCheck));
        this.toolBar.add(new JButton(), I18N.get("ui.AttributeTab.zoom-to-selected-rows"), IconLoader.icon("SmallMagnify.gif"), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    AttributeTab.this.panel.zoom(AttributeTab.this.panel.selectedFeatures());
                }
                catch (Throwable t) {
                    AttributeTab.this.errorHandler.handleThrowable(t);
                }
            }
        }, new MultiEnableCheck().add(this.taskFrameEnableCheck).add(this.layersEnableCheck).add(this.rowsSelectedEnableCheck));
        this.toolBar.add(new JButton(), I18N.get("ui.AttributeTab.zoom-to-full-extent"), IconLoader.icon("SmallWorld.gif"), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    taskFrame.getLayerViewPanel().getViewport().zoomToFullExtent();
                }
                catch (Throwable t) {
                    AttributeTab.this.errorHandler.handleThrowable(t);
                }
            }
        }, new MultiEnableCheck().add(this.taskFrameEnableCheck).add(this.layersEnableCheck));
        this.toolBar.add(new JButton(), I18N.get("ui.AttributeTab.select-in-task-window"), IconLoader.icon("SmallSelect.gif"), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    AttributeTab.this.panel.selectInLayerViewPanel();
                }
                catch (Throwable t) {
                    AttributeTab.this.errorHandler.handleThrowable(t);
                }
            }
        }, new MultiEnableCheck().add(this.taskFrameEnableCheck).add(this.layersEnableCheck).add(this.rowsSelectedEnableCheck));
        this.toolBar.add(new JButton(), I18N.get("ui.AttributeTab.flash-selected-rows"), IconLoader.icon("Flashlight.gif"), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    AttributeTab.this.panel.flashSelectedFeatures();
                }
                catch (Throwable t) {
                    AttributeTab.this.errorHandler.handleThrowable(t);
                }
            }
        }, new MultiEnableCheck().add(this.taskFrameEnableCheck).add(this.layersEnableCheck).add(this.rowsSelectedEnableCheck));
        FeatureInfoPlugIn featureInfoPlugIn = new FeatureInfoPlugIn();
        this.toolBar.add(new JButton(), featureInfoPlugIn.getName(), GUIUtil.toSmallIcon(FeatureInfoTool.ICON), FeatureInfoPlugIn.toActionListener(featureInfoPlugIn, workbenchContext, null), FeatureInfoPlugIn.createEnableCheck(workbenchContext));
    }

    public TaskFrame getTaskFrame() {
        return this.taskFrame;
    }

    public Layer chooseEditableLayer() {
        return TreeLayerNamePanel.chooseEditableLayer(this);
    }

    public LayerManager getLayerManager() {
        return this.layerManagerProxy.getLayerManager();
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.toolBar.setOrientation(1);
        this.scrollPane.getViewport().add((Component)this.panel, null);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.toolBar, "West");
    }

    private void initScrollPane() {
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(new JTable().getRowHeight());
    }

    private void zoom(AttributePanel.Row row) throws NoninvertibleTransformException {
        this.panel.clearSelection();
        if (row.getPanel().getTable().getModel().getRowCount() == 0) {
            return;
        }
        row.getPanel().getTable().getSelectionModel().setSelectionInterval(row.getIndex(), row.getIndex());
        Rectangle r = row.getPanel().getTable().getCellRect(row.getIndex(), 0, true);
        row.getPanel().getTable().scrollRectToVisible(r);
        if (row.isFirstRow()) {
            row.getPanel().scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        features.add(row.getFeature());
        this.panel.zoom(features);
    }

    private void pan(AttributePanel.Row row) throws NoninvertibleTransformException {
        this.panel.clearSelection();
        if (row.getPanel().getTable().getModel().getRowCount() == 0) {
            return;
        }
        row.getPanel().getTable().getSelectionModel().setSelectionInterval(row.getIndex(), row.getIndex());
        Rectangle r = row.getPanel().getTable().getCellRect(row.getIndex(), 0, true);
        row.getPanel().getTable().scrollRectToVisible(r);
        if (row.isFirstRow()) {
            row.getPanel().scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        features.add(row.getFeature());
        this.panel.pan(features);
    }

    public static TitledPopupMenu popupMenu(WorkbenchContext context) {
        return (TitledPopupMenu)context.getWorkbench().getBlackboard().get(AttributeTab.class.getName() + " - LAYER POPUP MENU", new TitledPopupMenu());
    }

    public static void addPopupMenuItem(WorkbenchContext workbenchContext, PlugIn plugIn, String menuItemName, boolean checkBox, Icon icon, EnableCheck enableCheck) {
        new FeatureInstaller(workbenchContext).addPopupMenuItem((JPopupMenu)AttributeTab.popupMenu(workbenchContext), AttributeTab.wrap(plugIn), menuItemName, checkBox, icon, enableCheck);
    }

    private static PlugIn wrap(final PlugIn plugIn) {
        return new PlugIn(){

            public void initialize(PlugInContext context) throws Exception {
                plugIn.initialize(context);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean execute(PlugInContext context) throws Exception {
                AttributeTab attributeTab = (AttributeTab)context.getLayerNamePanel();
                AttributeTab.setEnableLastSelectedLayers(true, attributeTab);
                try {
                    boolean bl = plugIn.execute(context);
                    return bl;
                }
                finally {
                    AttributeTab.setEnableLastSelectedLayers(false, attributeTab);
                }
            }

            public String getName() {
                return plugIn.getName();
            }
        };
    }

    private static void setEnableLastSelectedLayers(boolean enabled, AttributeTab attributeTab) {
        attributeTab.selectedLayers = enabled ? attributeTab.lastSelectedLayers : new Layer[]{};
    }

    public Collection getSelectedCategories() {
        return new ArrayList();
    }

    public Layer[] getSelectedLayers() {
        if (this.model.getLayers().size() == 1) {
            return new Layer[]{(Layer)this.model.getLayers().get(0)};
        }
        return this.selectedLayers;
    }

    public Collection selectedNodes(Class c) {
        if (!Layerable.class.isAssignableFrom(c)) {
            return new ArrayList();
        }
        return Arrays.asList(this.getSelectedLayers());
    }

    public AttributePanel getPanel() {
        return this.panel;
    }

    public EnableableToolBar getToolBar() {
        return this.toolBar;
    }

    public void addListener(LayerNamePanelListener listener) {
    }

    public void removeListener(LayerNamePanelListener listener) {
    }

    public void dispose() {
    }

    static /* synthetic */ Layer[] access$302(AttributeTab x0, Layer[] x1) {
        x0.lastSelectedLayers = x1;
        return x1;
    }
}

