/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.tree.TreeCellEditor;

public class LayerTreeCellEditor
implements TreeCellEditor {
    private JTextField textField = new JTextField();
    private DefaultCellEditor editor = new DefaultCellEditor(this.textField);
    private JTree tree;

    public LayerTreeCellEditor(JTree tree) {
        this.tree = tree;
        this.textField.setFont(new JLabel().getFont());
    }

    private void changeWidthUsing(JTree tree, int row) {
        int width = (int)((double)tree.getWidth() - tree.getUI().getPathBounds(tree, tree.getUI().getPathForRow(tree, row)).getLocation().getX());
        this.textField.setPreferredSize(new Dimension(width, (int)this.textField.getPreferredSize().getHeight()));
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.changeWidthUsing(tree, row);
        return this.editor.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
    }

    public Object getCellEditorValue() {
        return this.editor.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject anEvent) {
        MouseEvent e = (MouseEvent)anEvent;
        if (SwingUtilities.isRightMouseButton(e)) {
            return false;
        }
        return this.editor.isCellEditable(anEvent);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    public boolean stopCellEditing() {
        return this.editor.stopCellEditing();
    }

    public void cancelCellEditing() {
        this.editor.cancelCellEditing();
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.editor.addCellEditorListener(l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.editor.removeCellEditorListener(l);
    }
}

