/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.OKCancelPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class OKCancelDialog
extends JDialog {
    private OKCancelPanel okCancelPanel = new OKCancelPanel();
    private Component customComponent;

    public OKCancelDialog(Dialog owner, String title, boolean modal, Component customComponent, Validator validator) throws HeadlessException {
        super(owner, title, modal);
        this.initialize(customComponent, validator);
    }

    public OKCancelDialog(Frame owner, String title, boolean modal, Component customComponent, Validator validator) throws HeadlessException {
        super(owner, title, modal);
        this.initialize(customComponent, validator);
    }

    private void initialize(final Component customComponent, final Validator validator) {
        this.getRootPane().setDefaultButton(this.okCancelPanel.getButton("OK"));
        this.customComponent = customComponent;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(customComponent, "Center");
        this.okCancelPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String errorMessage;
                if (OKCancelDialog.this.okCancelPanel.wasOKPressed() && validator != null && (errorMessage = validator.validateInput(customComponent)) != null) {
                    JOptionPane.showMessageDialog(OKCancelDialog.this, errorMessage, OKCancelDialog.this.getTitle(), 0);
                    return;
                }
                OKCancelDialog.this.setVisible(false);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                OKCancelDialog.this.okCancelPanel.setOKPressed(false);
            }
        });
        this.getContentPane().add((Component)this.okCancelPanel, "South");
        this.pack();
        GUIUtil.centreOnWindow(this);
    }

    public boolean wasOKPressed() {
        return this.okCancelPanel.wasOKPressed();
    }

    public Component getCustomComponent() {
        return this.customComponent;
    }

    public static interface Validator {
        public String validateInput(Component var1);
    }
}

