/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.SchemaTableModel;
import com.vividsolutions.jump.workbench.ui.WorkbenchToolBar;
import com.vividsolutions.jump.workbench.ui.addremove.AddRemovePanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPlugIn;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.EditablePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class SchemaPanel
extends JPanel {
    private JPanel jPanel3 = new JPanel();
    private JPanel jPanel1 = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel statusLabel = new JLabel();
    private Layer layer;
    private Point currentClickPoint;
    private JPopupMenu popupMenu = new JPopupMenu();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JPanel buttonPanel = new JPanel();
    private JButton applyButton = new JButton();
    private JCheckBox forceInvalidConversionsToNullCheckBox = new JCheckBox();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private JPanel jPanel2 = new JPanel();
    private Border border1;
    private boolean modified = false;
    private ArrayList listeners = new ArrayList();
    private JButton revertButton = new JButton();
    private BorderLayout borderLayout1 = new BorderLayout();
    private WorkbenchToolBar toolBar = new WorkbenchToolBar(null){

        public JButton addPlugIn(Icon icon, PlugIn plugIn, EnableCheck enableCheck, WorkbenchContext workbenchContext) {
            return super.addPlugIn(icon, SchemaPanel.this.addCleanUp(plugIn), enableCheck, workbenchContext);
        }
    };
    private EnableCheck basicEnableCheck = new EnableCheck(){

        public String check(JComponent component) {
            if (!SchemaPanel.this.layer.isEditable()) {
                return I18N.get("ui.SchemaPanel.layer-must-be-editable");
            }
            if (SchemaPanel.this.rowsToActOn().length == 0) {
                return I18N.get("ui.SchemaPanel.at-least-1-row-must-be-selected");
            }
            return null;
        }
    };
    private MyPlugIn insertPlugIn = new MyPlugIn(){

        public String getName() {
            return I18N.get("ui.SchemaPanel.insert");
        }

        public Icon getIcon() {
            return GUIUtil.toSmallIcon(IconLoader.icon("Plus.gif"));
        }

        public boolean execute(PlugInContext context) throws Exception {
            SchemaPanel.this.markAsModified();
            SchemaPanel.this.getModel().insertBlankRow(SchemaPanel.this.rowsToActOn()[0]);
            return true;
        }
    };
    private MyPlugIn deletePlugIn = new MyPlugIn(){

        public String getName() {
            return I18N.get("ui.SchemaPanel.delete");
        }

        public Icon getIcon() {
            return GUIUtil.toSmallIcon(IconLoader.icon("Delete.gif"));
        }

        public boolean execute(PlugInContext context) throws Exception {
            SchemaPanel.this.markAsModified();
            SchemaPanel.this.getModel().removeFields(SchemaPanel.this.rowsToActOn());
            return true;
        }
    };
    private MyPlugIn moveUpPlugIn = new MyPlugIn(){

        public Icon getIcon() {
            return GUIUtil.toSmallIcon(IconLoader.icon("VCRUp.gif"));
        }

        public String getName() {
            return I18N.get("ui.SchemaPanel.move-field-up");
        }

        public boolean execute(PlugInContext context) throws Exception {
            SchemaPanel.this.markAsModified();
            SchemaPanel.this.move(AddRemovePanel.itemsToMoveUp(SchemaPanel.this.getModel().getFields(), SchemaPanel.this.toFields(SchemaPanel.this.rowsToActOn())), -1);
            return true;
        }

        public MultiEnableCheck createEnableCheck() {
            return super.createEnableCheck().add(new EnableCheck(){

                public String check(JComponent component) {
                    return SchemaPanel.this.min(SchemaPanel.this.rowsToActOn()) == 0 ? I18N.get("ui.SchemaPanel.field-is-already-at-the-top") : null;
                }
            });
        }
    };
    private EditablePlugIn editablePlugIn;
    private MyPlugIn moveDownPlugIn = new MyPlugIn(){

        public Icon getIcon() {
            return GUIUtil.toSmallIcon(IconLoader.icon("VCRDown.gif"));
        }

        public String getName() {
            return I18N.get("ui.SchemaPanel.move-field-down");
        }

        public boolean execute(PlugInContext context) throws Exception {
            SchemaPanel.this.markAsModified();
            SchemaPanel.this.move(AddRemovePanel.itemsToMoveDown(SchemaPanel.this.getModel().getFields(), SchemaPanel.this.toFields(SchemaPanel.this.rowsToActOn())), 1);
            return true;
        }
    };
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JTable table = new JTable();

    private void setModel(SchemaTableModel model) {
        this.table.setModel(model);
        this.table.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                SchemaPanel.this.updateComponents();
            }
        });
        this.initCellEditors();
        this.updateComponents();
    }

    public SchemaPanel(final Layer layer, EditingPlugIn editingPlugIn, WorkbenchContext context) {
        this.editablePlugIn = new EditablePlugIn(editingPlugIn);
        try {
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    SchemaPanel.this.updateComponents();
                }
            });
            this.layer = layer;
            this.jbInit();
            this.initPopupMenu(context);
            this.initToolBar(context);
            this.setModel(new SchemaTableModel(layer));
            layer.getLayerManager().addLayerListener(new LayerListener(){

                public void categoryChanged(CategoryEvent e) {
                }

                public void featuresChanged(FeatureEvent e) {
                }

                public void layerChanged(LayerEvent e) {
                    if (e.getLayerable() != layer) {
                        return;
                    }
                    if (e.getType() == LayerEventType.METADATA_CHANGED) {
                        SchemaPanel.this.updateComponents();
                        SchemaPanel.this.repaint();
                    }
                }
            });
        }
        catch (Exception ex) {
            Assert.shouldNeverReachHere((String)ex.toString());
        }
    }

    private int[] rowsToActOn() {
        if (this.table.getSelectedRowCount() > 0) {
            return this.table.getSelectedRows();
        }
        if (this.getCurrentClickPoint() != null && this.table.rowAtPoint(this.getCurrentClickPoint()) != -1) {
            return new int[]{this.table.rowAtPoint(this.getCurrentClickPoint())};
        }
        return new int[0];
    }

    private void initToolBar(WorkbenchContext context) {
        this.toolBar.addPlugIn(this.insertPlugIn.getIcon(), this.insertPlugIn, this.insertPlugIn.createEnableCheck(), context);
        this.toolBar.addPlugIn(this.deletePlugIn.getIcon(), this.deletePlugIn, this.deletePlugIn.createEnableCheck(), context);
        this.toolBar.addPlugIn(this.moveUpPlugIn.getIcon(), this.moveUpPlugIn, this.moveUpPlugIn.createEnableCheck(), context);
        this.toolBar.addPlugIn(this.moveDownPlugIn.getIcon(), this.moveDownPlugIn, this.moveDownPlugIn.createEnableCheck(), context);
    }

    private void initPopupMenu(WorkbenchContext context) {
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                SchemaPanel.this.setCurrentClickPoint(e.getPoint());
                if (SwingUtilities.isRightMouseButton(e)) {
                    SchemaPanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.addPopupMenuItem(this.editablePlugIn, true, null, this.editablePlugIn.createEnableCheck(context), context);
        this.popupMenu.addSeparator();
        this.addPopupMenuItem(this.insertPlugIn, false, this.insertPlugIn.getIcon(), this.insertPlugIn.createEnableCheck(), context);
        this.addPopupMenuItem(this.deletePlugIn, false, this.deletePlugIn.getIcon(), this.deletePlugIn.createEnableCheck(), context);
        this.popupMenu.addSeparator();
        this.addPopupMenuItem(this.moveUpPlugIn, false, this.moveUpPlugIn.getIcon(), this.moveUpPlugIn.createEnableCheck(), context);
        this.addPopupMenuItem(this.moveDownPlugIn, false, this.moveDownPlugIn.getIcon(), this.moveDownPlugIn.createEnableCheck(), context);
    }

    private void addPopupMenuItem(PlugIn plugIn, boolean checkBox, Icon icon, EnableCheck enableCheck, WorkbenchContext context) {
        FeatureInstaller installer = new FeatureInstaller(context);
        installer.addPopupMenuItem(this.popupMenu, this.addCleanUp(plugIn), plugIn.getName(), checkBox, icon, enableCheck);
    }

    private PlugIn addCleanUp(final PlugIn plugIn) {
        return new PlugIn(){

            public String toString() {
                return plugIn.toString();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean execute(PlugInContext context) throws Exception {
                try {
                    boolean bl = plugIn.execute(context);
                    return bl;
                }
                finally {
                    SchemaPanel.this.setCurrentClickPoint(null);
                    SchemaPanel.this.updateComponents();
                }
            }

            public void initialize(PlugInContext context) throws Exception {
                plugIn.initialize(context);
            }

            public String getName() {
                return plugIn.getName();
            }
        };
    }

    public boolean isModified() {
        return this.modified;
    }

    private Collection toFields(int[] rows) {
        ArrayList<SchemaTableModel.Field> fields = new ArrayList<SchemaTableModel.Field>();
        for (int i = 0; i < rows.length; ++i) {
            fields.add(this.getModel().get(rows[i]));
        }
        return fields;
    }

    private void updateComponents() {
        this.table.setShowGrid(this.layer.isEditable());
        this.table.setRowHeight(20);
        this.applyButton.setEnabled(this.layer.isEditable());
        this.revertButton.setEnabled(this.layer.isEditable());
        this.forceInvalidConversionsToNullCheckBox.setEnabled(this.layer.isEditable());
        this.reportError(this.validateInput());
        this.toolBar.updateEnabledState();
    }

    public SchemaTableModel getModel() {
        return (SchemaTableModel)this.table.getModel();
    }

    private TableColumn fieldNameColumn() {
        return this.table.getColumnModel().getColumn(this.getModel().indexOfColumn(SchemaTableModel.FIELD_NAME_COLUMN_NAME));
    }

    private TableColumn dataTypeColumn() {
        return this.table.getColumnModel().getColumn(this.getModel().indexOfColumn(SchemaTableModel.DATA_TYPE_COLUMN_NAME));
    }

    private void initCellEditors() {
        this.fieldNameColumn().setCellEditor(new MyFieldNameEditor());
        this.dataTypeColumn().setCellEditor(new MyDataTypeEditor(AttributeType.allTypes().toArray()));
        this.fieldNameColumn().setCellRenderer(new StripingRenderer(this.table.getDefaultRenderer(String.class)));
        this.dataTypeColumn().setCellRenderer(new StripingRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return table.getDefaultRenderer(String.class).getTableCellRendererComponent(table, value != null ? SchemaPanel.this.capitalizeFirstLetter(value.toString()) : null, isSelected, hasFocus, row, column);
            }
        }));
        this.table.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                for (int i = 0; i < SchemaPanel.this.table.getColumnCount(); ++i) {
                    ((MyEditor)SchemaPanel.this.table.getColumnModel().getColumn(i).getCellEditor()).cancelCellEditing();
                }
            }
        });
    }

    private String capitalizeFirstLetter(String string) {
        return string.toUpperCase().charAt(0) + string.toLowerCase().substring(1);
    }

    void jbInit() throws Exception {
        this.toolBar.setOrientation(1);
        this.border1 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.setLayout(this.gridBagLayout2);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.statusLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusLabel.setText(" ");
        this.applyButton.setText(I18N.get("ui.SchemaPanel.apply-changes"));
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SchemaPanel.this.applyButton_actionPerformed(e);
            }
        });
        this.forceInvalidConversionsToNullCheckBox.setToolTipText(I18N.get("ui.SchemaPanel.leave-unchecked-if-you-want-to-be-notified-of-conversion-errors"));
        this.forceInvalidConversionsToNullCheckBox.setText(I18N.get("ui.SchemaPanel.force-invalid-conversions-to-null"));
        this.buttonPanel.setLayout(this.gridBagLayout3);
        this.buttonPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.revertButton.setText(I18N.get("ui.SchemaPanel.revert-changes"));
        this.revertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SchemaPanel.this.revertButton_actionPerformed(e);
            }
        });
        this.jPanel3.setLayout(this.borderLayout1);
        this.add((Component)this.jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.toolBar, "West");
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.table, null);
        this.add((Component)this.jPanel1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.statusLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.applyButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.buttonPanel.add((Component)this.forceInvalidConversionsToNullCheckBox, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.jPanel2, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.revertButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 4), 0, 0));
    }

    private void reportError(String message) {
        if (message != null) {
            this.statusLabel.setText(message);
            this.statusLabel.setIcon(GUIUtil.toSmallIcon(IconLoader.icon("Delete.gif")));
        } else {
            this.statusLabel.setText(" ");
            this.statusLabel.setIcon(null);
        }
    }

    private int geometryCount() {
        int geometryCount = 0;
        for (int i = 0; i < this.getModel().getRowCount(); ++i) {
            if (this.getModel().get(i).getType() != AttributeType.GEOMETRY) continue;
            ++geometryCount;
        }
        return geometryCount;
    }

    public String validateInput() {
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            String error = ((MyEditor)this.table.getColumnModel().getColumn(i).getCellEditor()).getCurrentErrorMessage();
            if (error == null) continue;
            return error;
        }
        if (this.geometryCount() > 1) {
            return I18N.get("ui.SchemaPanel.only-one-geometry-field-is-allowed");
        }
        if (this.geometryCount() == 0) {
            return I18N.get("ui.SchemaPanel.a-geometry-field-must-be-defined");
        }
        return null;
    }

    private String validate(int row, AttributeType type) {
        if (type == AttributeType.GEOMETRY) {
            for (int i = 0; i < this.getModel().getRowCount(); ++i) {
                if (i != row && this.getModel().get(i).getType() != null) continue;
            }
        }
        return null;
    }

    private String validate(int row, String name) {
        if (name.trim().length() == 0) {
            return I18N.get("ui.SchemaPanel.field-name-cannot-be-blank");
        }
        for (int i = 0; i < this.getModel().getRowCount(); ++i) {
            if (i == row || this.getModel().get(i).getName() == null || !this.getModel().get(i).getName().equalsIgnoreCase(name.trim())) continue;
            return I18N.get("ui.SchemaPanel.field-name-already-exists") + ": " + name;
        }
        return null;
    }

    private void markAsModified() {
        this.modified = true;
    }

    public void markAsUnmodified() {
        this.modified = false;
    }

    public JTable getTable() {
        return this.table;
    }

    void applyButton_actionPerformed(ActionEvent e) {
        this.fireActionPerformed();
    }

    public void add(ActionListener l) {
        this.listeners.add(l);
    }

    private void fireActionPerformed() {
        for (ActionListener l : this.listeners) {
            l.actionPerformed(null);
        }
    }

    public boolean isForcingInvalidConversionsToNull() {
        return this.forceInvalidConversionsToNullCheckBox.isSelected();
    }

    public void move(Collection fieldsToMove, int displacement) {
        int guaranteedVisibleRow = displacement > 0 ? this.max(this.rowsToActOn()) : this.min(this.rowsToActOn());
        guaranteedVisibleRow += displacement;
        ArrayList<SchemaTableModel.Field> selectedFields = new ArrayList<SchemaTableModel.Field>();
        int[] selectedRows = this.table.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            selectedFields.add(this.getModel().get(selectedRows[i]));
        }
        this.getModel().move(fieldsToMove, displacement);
        this.table.clearSelection();
        for (SchemaTableModel.Field field : selectedFields) {
            this.table.addRowSelectionInterval(this.getModel().indexOf(field), this.getModel().indexOf(field));
        }
        Rectangle r = this.table.getCellRect(guaranteedVisibleRow, 0, true);
        this.table.scrollRectToVisible(r);
    }

    private int min(int[] ints) {
        int min = ints[0];
        for (int i = 0; i < ints.length; ++i) {
            min = Math.min(min, ints[i]);
        }
        return min;
    }

    private int max(int[] ints) {
        int max = ints[0];
        for (int i = 0; i < ints.length; ++i) {
            max = Math.max(max, ints[i]);
        }
        return max;
    }

    void revertButton_actionPerformed(ActionEvent e) {
        this.setModel(new SchemaTableModel(this.layer));
    }

    private void setCurrentClickPoint(Point currentClickPoint) {
        this.currentClickPoint = currentClickPoint;
    }

    private Point getCurrentClickPoint() {
        return this.currentClickPoint;
    }

    public class MyFieldNameEditor
    extends MyEditor {
        private String originalText;

        public MyFieldNameEditor() {
            super(new JTextField());
        }

        public boolean stopCellEditing() {
            if (!this.textField().getText().equals(this.originalText)) {
                SchemaPanel.this.markAsModified();
            }
            return super.stopCellEditing();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.originalText = (String)value;
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        private JTextField textField() {
            return (JTextField)this.getComponent();
        }

        protected String validate() {
            return SchemaPanel.this.validate(this.row, this.textField().getText());
        }
    }

    public abstract class MyEditor
    extends DefaultCellEditor {
        protected int row;
        private String currentErrorMessage;

        public MyEditor(JComboBox comboBox) {
            super(comboBox);
            this.currentErrorMessage = null;
        }

        public MyEditor(JTextField textField) {
            super(textField);
            this.currentErrorMessage = null;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.row = row;
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        public void cancelCellEditing() {
            this.currentErrorMessage = null;
            SchemaPanel.this.updateComponents();
            super.cancelCellEditing();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean stopCellEditing() {
            try {
                if (this.validate() != null) {
                    ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                    boolean bl = false;
                    return bl;
                }
                boolean bl = super.stopCellEditing();
                return bl;
            }
            finally {
                this.currentErrorMessage = this.validate();
                SchemaPanel.this.updateComponents();
            }
        }

        protected abstract String validate();

        public String getCurrentErrorMessage() {
            return this.currentErrorMessage;
        }
    }

    public class MyDataTypeEditor
    extends MyEditor {
        private AttributeType originalType;

        public MyDataTypeEditor(Object[] items) {
            super(new JComboBox<Object>(items));
            final ListCellRenderer originalRenderer = this.comboBox().getRenderer();
            this.comboBox().setRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    return originalRenderer.getListCellRendererComponent(list, value != null ? SchemaPanel.this.capitalizeFirstLetter(value.toString()) : null, index, isSelected, cellHasFocus);
                }
            });
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.originalType = (AttributeType)value;
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        private JComboBox comboBox() {
            return (JComboBox)this.getComponent();
        }

        public boolean stopCellEditing() {
            if (this.originalType != this.comboBox().getSelectedItem()) {
                SchemaPanel.this.markAsModified();
            }
            return super.stopCellEditing();
        }

        protected String validate() {
            return SchemaPanel.this.validate(this.row, (AttributeType)this.comboBox().getSelectedItem());
        }
    }

    private class StripingRenderer
    implements TableCellRenderer {
        private TableCellRenderer originalRenderer;
        private final Color LIGHT_GRAY = new Color(230, 230, 230);

        public StripingRenderer(TableCellRenderer originalRenderer) {
            this.originalRenderer = originalRenderer;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent component = (JComponent)this.originalRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setOpaque(true);
            if (!isSelected) {
                component.setForeground(Color.black);
                component.setBackground(SchemaPanel.this.layer.isEditable() || row % 2 == 0 ? Color.white : this.LIGHT_GRAY);
            }
            return component;
        }
    }

    private abstract class MyPlugIn
    extends AbstractPlugIn {
        private MyPlugIn() {
        }

        public MultiEnableCheck createEnableCheck() {
            return new MultiEnableCheck().add(SchemaPanel.this.basicEnableCheck);
        }

        public abstract Icon getIcon();
    }
}

