/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.util.Block;
import com.vividsolutions.jump.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeUtil {
    public static TreeCellRenderer createSimpleTreeCellRenderer(ImageIcon icon) {
        return TreeUtil.createSimpleTreeCellRenderer(null, icon, new JTree().getFont());
    }

    public static TreeCellRenderer createSimpleTreeCellRenderer(final String text, final ImageIcon icon, final Font font) {
        return new DefaultTreeCellRenderer(){
            {
                this.setOpenIcon(icon);
                this.setClosedIcon(icon);
                this.setLeafIcon(icon);
                this.setBackgroundNonSelectionColor(new Color(0, 0, 0, 0));
            }

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component component = super.getTreeCellRendererComponent(tree, text == null ? value : text, sel, expanded, leaf, row, hasFocus);
                component.setFont(font);
                return component;
            }
        };
    }

    public static void visit(TreeModel model, Visitor visitor) {
        Stack<Object> path = new Stack<Object>();
        path.push(model.getRoot());
        TreeUtil.visit(model, path, visitor);
    }

    public static void visit(TreeModel model, TreePath path, Visitor visitor) {
        Stack<Object> stack = new Stack<Object>();
        stack.addAll(Arrays.asList(path.getPath()));
        TreeUtil.visit(model, stack, visitor);
    }

    private static void visit(TreeModel model, Stack path, Visitor visitor) {
        visitor.visit(path);
        for (int i = 0; i < model.getChildCount(path.peek()); ++i) {
            path.push(model.getChild(path.peek(), i));
            TreeUtil.visit(model, path, visitor);
            path.pop();
        }
    }

    public static TreeModelEvent createTreeModelEvent(Object source, Object node, TreeModel model) {
        TreePath path = TreeUtil.findTreePath(node, model);
        Assert.isTrue((path != null ? 1 : 0) != 0, (String)("Cannot find node in TreeModel: " + node + "\n" + TreeUtil.dump(model)));
        TreePath parentPath = path.getParentPath();
        return new TreeModelEvent(source, parentPath, new int[]{model.getIndexOfChild(parentPath.getLastPathComponent(), node)}, new Object[]{node});
    }

    public static String dump(TreeModel model) {
        final StringBuffer result = new StringBuffer();
        TreeUtil.visit(model, new Visitor(){

            public void visit(Stack path) {
                result.append(StringUtil.repeat(' ', path.size() * 2) + path.lastElement() + "\n");
            }
        });
        return result.toString();
    }

    public static TreePath findTreePath(final Object node, TreeModel model) {
        final TreePath[] treePath = new TreePath[]{null};
        TreeUtil.visit(model, new Visitor(){

            public void visit(Stack path) {
                if (path.peek() != node) {
                    return;
                }
                treePath[0] = new TreePath(path.toArray());
            }
        });
        return treePath[0];
    }

    public static boolean contains(TreeModel model, final Object node) {
        final boolean[] result = new boolean[]{false};
        TreeUtil.visit(model, new Visitor(){

            public void visit(Stack path) {
                if (path.peek() == node) {
                    result[0] = true;
                }
            }
        });
        return result[0];
    }

    public static List lastPathComponents(TreePath[] paths) {
        ArrayList<Object> lastPathComponents = new ArrayList<Object>();
        for (int i = 0; i < paths.length; ++i) {
            lastPathComponents.add(paths[i].getLastPathComponent());
        }
        return lastPathComponents;
    }

    public static void expandAll(JTree tree, TreePath path) {
        TreeUtil.expand(tree, path, new Block(){

            public Object yield(Object node) {
                return Boolean.TRUE;
            }
        });
    }

    public static void expand(final JTree tree, TreePath path, final Block expandNodeCondition) {
        TreeUtil.visit(tree.getModel(), path, new Visitor(){

            public void visit(Stack path) {
                if (!((Boolean)expandNodeCondition.yield(path.peek())).booleanValue()) {
                    return;
                }
                tree.expandPath(TreeUtil.findTreePath(path.peek(), tree.getModel()));
            }
        });
    }

    public static Collection nodes(TreePath path, TreeModel model) {
        final ArrayList nodes = new ArrayList();
        TreeUtil.visit(model, path, new Visitor(){

            public void visit(Stack path) {
                nodes.add(path.peek());
            }
        });
        return nodes;
    }

    public static interface Visitor {
        public void visit(Stack var1);
    }
}

