/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.geom.EnvelopeIntersector;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SpecifyFeaturesTool
extends DragTool {
    protected Iterator candidateLayersIterator() {
        return this.getPanel().getLayerManager().iterator();
    }

    private static Set intersectingFeatures(Layer layer, Envelope envelope) {
        HashSet<Feature> intersectingFeatures = new HashSet<Feature>();
        List candidateFeatures = layer.getFeatureCollectionWrapper().query(envelope);
        String a = "" + layer.getFeatureCollectionWrapper().getUltimateWrappee();
        String b = "" + layer.getFeatureCollectionWrapper().getUltimateWrappee().size();
        for (Feature feature : candidateFeatures) {
            if (!envelope.contains(feature.getGeometry().getEnvelopeInternal()) && !EnvelopeIntersector.intersects(feature.getGeometry(), envelope)) continue;
            intersectingFeatures.add(feature);
        }
        return intersectingFeatures;
    }

    public void mouseClicked(MouseEvent e) {
        try {
            super.mouseClicked(e);
            this.setViewSource(e.getPoint());
            this.setViewDestination(e.getPoint());
            this.fireGestureFinished();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    protected Set specifiedFeatures() throws NoninvertibleTransformException {
        HashSet allFeatures = new HashSet();
        for (Set features : this.layerToSpecifiedFeaturesMap().values()) {
            allFeatures.addAll(features);
        }
        return allFeatures;
    }

    protected Map layerToSpecifiedFeaturesMap() throws NoninvertibleTransformException {
        return SpecifyFeaturesTool.layerToSpecifiedFeaturesMap(this.candidateLayersIterator(), this.getBoxInModelCoordinates());
    }

    public static Map layerToSpecifiedFeaturesMap(Iterator layerIterator, Envelope boxInModelCoordinates) throws NoninvertibleTransformException {
        HashMap<Layer, Set> layerToFeaturesMap = new HashMap<Layer, Set>();
        Iterator i = layerIterator;
        while (i.hasNext()) {
            Set intersectingFeatures;
            Layer layer = (Layer)i.next();
            if (!layer.isVisible() || (intersectingFeatures = SpecifyFeaturesTool.intersectingFeatures(layer, boxInModelCoordinates)).isEmpty()) continue;
            layerToFeaturesMap.put(layer, intersectingFeatures);
        }
        return layerToFeaturesMap;
    }

    protected Collection specifiedFeatures(Collection layers) throws NoninvertibleTransformException {
        ArrayList specifiedFeatures = new ArrayList();
        Map layerToSpecifiedFeaturesMap = this.layerToSpecifiedFeaturesMap();
        for (Layer layer : layerToSpecifiedFeaturesMap.keySet()) {
            if (!layers.contains(layer)) continue;
            specifiedFeatures.addAll((Collection)layerToSpecifiedFeaturesMap.get(layer));
        }
        return specifiedFeatures;
    }
}

