/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.openjump.core.geomutils.GeoUtils;
import org.openjump.core.geomutils.MathVector;

public class MoveSelectedItemsTool
extends DragTool {
    private EnableCheckFactory checkFactory;
    private Shape selectedFeaturesShape;
    private GeometryFactory geometryFactory = new GeometryFactory();
    private List verticesToSnap = null;
    private Coordinate centerCoord = null;
    protected boolean clockwise = true;
    private double fullAngle = 0.0;
    private boolean shiftDown = false;
    private Cursor rotateCursor = MoveSelectedItemsTool.createCursor(IconLoader.icon("RotateSelCursor.gif").getImage());

    public MoveSelectedItemsTool(EnableCheckFactory checkFactory) {
        this.checkFactory = checkFactory;
        this.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f));
        this.allowSnapping();
    }

    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        Coordinate displacement = CoordUtil.subtract(this.getModelDestination(), this.getModelSource());
        ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        for (Layer layerWithSelectedItems : this.getPanel().getSelectionManager().getLayersWithSelectedItems()) {
            transactions.add(this.createTransaction(layerWithSelectedItems, displacement));
        }
        EditTransaction.commit(transactions);
    }

    private EditTransaction createTransaction(Layer layer, final Coordinate displacement) {
        EditTransaction transaction = EditTransaction.createTransactionOnSelection(new EditTransaction.SelectionEditor(){

            public Geometry edit(Geometry geometryWithSelectedItems, Collection selectedItems) {
                for (Geometry item : selectedItems) {
                    if (MoveSelectedItemsTool.this.shiftDown) {
                        MoveSelectedItemsTool.this.rotate(item);
                        continue;
                    }
                    MoveSelectedItemsTool.this.move(item, displacement);
                }
                return geometryWithSelectedItems;
            }
        }, this.getPanel(), this.getPanel().getContext(), this.getName(), layer, this.isRollingBackInvalidEdits(), false);
        return transaction;
    }

    private void move(Geometry geometry, final Coordinate displacement) {
        geometry.apply(new CoordinateFilter(){

            public void filter(Coordinate coordinate) {
                coordinate.x += displacement.x;
                coordinate.y += displacement.y;
            }
        });
    }

    public Cursor getCursor() {
        if (this.shiftDown) {
            return this.rotateCursor;
        }
        return Cursor.getPredefinedCursor(13);
    }

    public Icon getIcon() {
        return IconLoader.icon("Move.gif");
    }

    private void rotate(Geometry geometry) {
        geometry.apply(new CoordinateFilter(){

            public void filter(Coordinate coordinate) {
                double cosAngle = Math.cos(MoveSelectedItemsTool.this.fullAngle);
                double sinAngle = Math.sin(MoveSelectedItemsTool.this.fullAngle);
                double x = coordinate.x - ((MoveSelectedItemsTool)MoveSelectedItemsTool.this).centerCoord.x;
                double y = coordinate.y - ((MoveSelectedItemsTool)MoveSelectedItemsTool.this).centerCoord.y;
                coordinate.x = ((MoveSelectedItemsTool)MoveSelectedItemsTool.this).centerCoord.x + x * cosAngle + y * sinAngle;
                coordinate.y = ((MoveSelectedItemsTool)MoveSelectedItemsTool.this).centerCoord.y + y * cosAngle - x * sinAngle;
            }
        });
    }

    public void mouseMoved(MouseEvent e) {
        boolean shiftWasDown = this.shiftDown;
        this.shiftDown = e.isShiftDown();
        if (shiftWasDown != this.shiftDown) {
            this.getPanel().setCursor(this.getCursor());
        }
        super.mouseMoved(e);
    }

    public void mousePressed(MouseEvent e) {
        try {
            if (!this.check(this.checkFactory.createAtLeastNItemsMustBeSelectedCheck(1))) {
                return;
            }
            if (!this.check(this.checkFactory.createSelectedItemsLayersMustBeEditableCheck())) {
                return;
            }
            this.verticesToSnap = null;
            this.centerCoord = null;
            this.selectedFeaturesShape = this.createSelectedItemsShape();
            super.mousePressed(e);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private Collection verticesToSnap() {
        Envelope viewportEnvelope = this.getPanel().getViewport().getEnvelopeInModelCoordinates();
        if (this.verticesToSnap == null) {
            this.verticesToSnap = new ArrayList();
            for (Geometry selectedItem : this.getPanel().getSelectionManager().getSelectedItems()) {
                Coordinate[] coordinates = selectedItem.getCoordinates();
                for (int j = 0; j < coordinates.length; ++j) {
                    if (!viewportEnvelope.contains(coordinates[j])) continue;
                    this.verticesToSnap.add(coordinates[j]);
                }
            }
            if (this.verticesToSnap.size() > 100) {
                Collections.shuffle(this.verticesToSnap);
                this.verticesToSnap = this.verticesToSnap.subList(0, 99);
            }
        }
        return this.verticesToSnap;
    }

    private Shape createSelectedItemsShape() throws NoninvertibleTransformException {
        List itemsToRender = new ArrayList(this.getPanel().getSelectionManager().getSelectedItems());
        if (itemsToRender.size() > 100) {
            Collections.shuffle(itemsToRender);
            itemsToRender = itemsToRender.subList(0, 99);
        }
        GeometryCollection gc = this.geometryFactory.createGeometryCollection(itemsToRender.toArray(new Geometry[0]));
        if (this.centerCoord == null) {
            this.centerCoord = gc.getCentroid().getCoordinate();
        }
        return this.getPanel().getJava2DConverter().toShape((Geometry)gc);
    }

    protected Shape getShape() throws Exception {
        if (this.shiftDown) {
            boolean ccwQuad;
            AffineTransform transform = new AffineTransform();
            Point2D centerPt = this.getPanel().getViewport().toViewPoint(new Point2D.Double(this.centerCoord.x, this.centerCoord.y));
            Point2D initialPt = this.getViewSource();
            Point2D currPt = this.getViewDestination();
            MathVector center = new MathVector(centerPt.getX(), centerPt.getY());
            MathVector initial = new MathVector(initialPt.getX(), initialPt.getY());
            MathVector curr = new MathVector(currPt.getX(), currPt.getY());
            MathVector initVec = initial.vectorBetween(center);
            MathVector currVec = curr.vectorBetween(center);
            double arcAngle = initVec.angleRad(currVec);
            Coordinate initialCoord = this.getPanel().getViewport().toModelCoordinate(initialPt);
            Coordinate currCoord = this.getPanel().getViewport().toModelCoordinate(currPt);
            boolean toRight = GeoUtils.pointToRight(currCoord, this.centerCoord, initialCoord);
            boolean cwQuad = this.fullAngle >= 0.0 && this.fullAngle <= 90.0 && this.clockwise;
            boolean bl = ccwQuad = this.fullAngle < 0.0 && this.fullAngle >= -90.0 && !this.clockwise;
            if (arcAngle <= 90.0 && (cwQuad || ccwQuad)) {
                this.clockwise = toRight;
            }
            this.fullAngle = this.fullAngle > 90.0 || this.fullAngle < -90.0 ? (this.clockwise && !toRight || !this.clockwise && toRight ? 360.0 - arcAngle : arcAngle) : arcAngle;
            if (!this.clockwise) {
                this.fullAngle = -this.fullAngle;
            }
            transform.rotate(this.fullAngle, centerPt.getX(), centerPt.getY());
            return transform.createTransformedShape(this.selectedFeaturesShape);
        }
        AffineTransform transform = new AffineTransform();
        transform.translate(this.getViewDestination().getX() - this.getViewSource().getX(), this.getViewDestination().getY() - this.getViewSource().getY());
        return transform.createTransformedShape(this.selectedFeaturesShape);
    }

    protected void setModelDestination(Coordinate modelDestination) {
        for (Coordinate vertex : this.verticesToSnap()) {
            Coordinate displacement = CoordUtil.subtract(vertex, this.getModelSource());
            Coordinate snapPoint = this.snap(CoordUtil.add(modelDestination, displacement));
            if (!this.getSnapManager().wasSnapCoordinateFound()) continue;
            this.modelDestination = CoordUtil.subtract(snapPoint, displacement);
            return;
        }
        this.modelDestination = modelDestination;
    }
}

