/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.util.java2xml.Java2XML;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JInternalFrame;

public abstract class AbstractSaveProjectPlugIn
extends AbstractPlugIn {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(Task task, File file, WorkbenchFrame frame) throws Exception {
        JInternalFrame taskWindow = frame.getActiveInternalFrame();
        task.setMaximized(taskWindow.isMaximum());
        if (taskWindow.isMaximum()) {
            Rectangle normalBounds = taskWindow.getNormalBounds();
            task.setTaskWindowLocation(new Point(normalBounds.x, normalBounds.y));
            task.setTaskWindowSize(new Dimension(normalBounds.width, normalBounds.height));
        } else {
            task.setTaskWindowLocation(taskWindow.getLocation());
            task.setTaskWindowSize(taskWindow.getSize());
        }
        task.setSavedViewEnvelope(frame.getContext().getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates());
        StringWriter stringWriter = new StringWriter();
        try {
            new Java2XML().write((Object)task, "project", stringWriter);
        }
        finally {
            stringWriter.flush();
        }
        FileUtil.setContents(file.getAbsolutePath(), stringWriter.toString());
        task.setName(GUIUtil.nameWithoutExtension(file));
        task.setProjectFile(file);
        ArrayList ignoredLayers = new ArrayList(this.ignoredLayers(task));
        if (!ignoredLayers.isEmpty()) {
            String warning = I18N.get("ui.plugin.AbstractSaveProjectPlugIn.some-layers-were-not-saved-to-the-task-file") + " ";
            for (int i = 0; i < ignoredLayers.size(); ++i) {
                Layer ignoredLayer = (Layer)ignoredLayers.get(i);
                if (i > 0) {
                    warning = warning + "\n";
                }
                warning = warning + ignoredLayer.getName();
            }
            warning = warning + " (" + I18N.get("ui.plugin.AbstractSaveProjectPlugIn.data-source-is-write-only") + ")";
            frame.log(warning);
        }
    }

    protected Collection ignoredLayers(Task task) {
        ArrayList<Layer> ignoredLayers = new ArrayList<Layer>();
        for (Layer layer : task.getLayerManager().getLayers()) {
            if (layer.hasReadableDataSource()) continue;
            ignoredLayers.add(layer);
        }
        return ignoredLayers;
    }
}

