/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.FenceLayerFinder;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SelectFeaturesInFencePlugIn
extends AbstractPlugIn {
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        context.getLayerViewPanel().getSelectionManager().clear();
        SelectFeaturesInFencePlugIn.execute(context.getLayerViewPanel(), context.getLayerNamePanel(), context.getLayerViewPanel().getFence(), true, false);
        return true;
    }

    public static void execute(LayerViewPanel layerViewPanel, LayerNamePanel layerNamePanel, Geometry fence, boolean skipUnselectedLayers, boolean mentionModifierHelp) {
        List<Layer> selectedLayers = Arrays.asList(layerNamePanel.getSelectedLayers());
        Map layerToFeaturesInFenceMap = layerViewPanel.visibleLayerToFeaturesInFenceMap(fence);
        for (Layer layer : layerToFeaturesInFenceMap.keySet()) {
            if (layer == new FenceLayerFinder(layerViewPanel).getLayer() || skipUnselectedLayers && !selectedLayers.contains(layer)) continue;
            layerViewPanel.getSelectionManager().getFeatureSelection().selectItems(layer, (Collection)layerToFeaturesInFenceMap.get(layer));
        }
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createFenceMustBeDrawnCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1));
    }
}

